// Copyright 10/04/01 Sun Microsystems, Inc. All Rights Reserved.

#pragma ident  "@(#)TSConverter.cc	1.6 01/10/04 Sun Microsystems"

#include "TSConverter.hh"


TSConverter::TSConverter() throw() 
       : stored_mt_exception_(NULL),stored_corba_exception_(NULL)
{
	bool_object_name_ = FALSE;
	bool_ref_object_name_ = FALSE;
	bool_interface_name_ = FALSE;
	bool_filter_ = FALSE;
	bool_scope_ = FALSE;
	bool_attr_id_list_ = FALSE;
	bool_attr_value_seq_ = FALSE;
	bool_set_list_ = FALSE;
	bool_action_req_ = FALSE;
	sem_init(&pending_,0, 0);
}

TSConverter::~TSConverter()
{
}


void TSConverter::SendReplyConverter
(
    Ptr user_data,
    Ptr call_data
) throw ()
{
    TSConverter* tsc = (TSConverter *)user_data;
	if (tsc->send_std_reply_) tsc->convert_send_reply(tsc);
	else tsc->convert_send_text_reply(tsc);
    tsc->wakeup();
}


void TSConverter::SendErrorConverter
(
    Ptr user_data,
    Ptr call_data
) throw ()
{
    TSConverter* tsc = (TSConverter *)user_data;
	if (tsc->send_std_error_) tsc->convert_std_send_error(tsc);
	else tsc->convert_text_send_error(tsc);
    tsc->wakeup();
}

void TSConverter::convert_std_send_error
(
    TSConverter* tsc
) throw()
{
	try
    {
		if (tsc->asn1_send_object_name_ != EMPTY_ASN1_VALUE)
    		OIConverter::asn1_to_idl(tsc->asn1_send_object_name_,tsc->idl_oi_);
    }
    catch( MTEMException &e)
    {
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }
} 

void TSConverter::convert_text_send_error
(
    TSConverter* tsc
) throw()
{
	// OI converter
	if (tsc->asn1_send_object_name_ != EMPTY_ASN1_VALUE)
   	{
            DU oi_du = oi2fdn(tsc->asn1_send_object_name_);
            tsc->idl_oi_text_ = CORBA::string_dup(oi_du.chp());
	}
	else
	tsc->idl_oi_text_ = CORBA::string_dup("");
}  

void TSConverter::convert_send_reply
(
    TSConverter* tsc
) throw()

{
	X711CMI::GetResultAttributeListType get_idl_attr_list;
	X711CMI::SetResultAttributeListType set_idl_attr_list;
	X711CMI::CreateResultAttributeListType create_idl_attr_list;
	
    try
    {
		switch (tsc->send_reply_type_)
        {
        case GET_RES:
            {
                ResultAttrListConverter::asn1_to_idl(tsc->asn1_send_info_,
                GET_RES, get_idl_attr_list, set_idl_attr_list,
                create_idl_attr_list);
                tsc->idl_reply_info_ <<= get_idl_attr_list;
                break;
            }
        case SET_RES:
            {
                ResultAttrListConverter::asn1_to_idl(tsc->asn1_send_info_,
                SET_RES, get_idl_attr_list, set_idl_attr_list,
                create_idl_attr_list);
                tsc->idl_reply_info_ <<= set_idl_attr_list;
                break;
            }
        case ACTION_RES:
			{
                Asn1Value tmp_send_info=tsc->asn1_send_info_;
                ActionInfoReplyConverter::asn1_to_idl(
                tsc->asn1_cr_attr_value_, tmp_send_info, tsc->idl_reply_info_);
            }
            break;
        case CREATE_RES:
            {
                 ResultAttrListConverter::asn1_to_idl(tsc->asn1_send_info_,
                 CREATE_RES, get_idl_attr_list,
                 set_idl_attr_list, create_idl_attr_list);
                 tsc->idl_reply_info_ <<= create_idl_attr_list;
                 break;
            }
		}

        // OI converter
        if (tsc->asn1_send_object_name_ != EMPTY_ASN1_VALUE)
            OIConverter::asn1_to_idl(tsc->asn1_send_object_name_,tsc->idl_oi_);

        // Time conversion
        if (tsc->asn1_send_curr_time_ != EMPTY_ASN1_VALUE)
            TimeConverter::asn1_to_idl(tsc->asn1_send_curr_time_, 
			tsc->idl_curr_time_);
        else
            tsc->idl_curr_time_._default();
  	}
	catch( MTEMException &e)
   	{
		
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }
}

void TSConverter::convert_send_text_reply
(
    TSConverter* tsc
) throw()
{
    try
    {
	switch (tsc->send_reply_type_)
        {
        case DELETE_RES:
             tsc->idl_reply_info_text_.delete_reply_info(FALSE);
             break;
        case GET_RES:
            {
            ResultAttrListConverter::asn1_to_idl_text(
			tsc->asn1_send_info_, tsc->idl_attr_type_list_text_);
            tsc->idl_reply_info_text_.get_reply_info(
			tsc->idl_attr_type_list_text_);
            }
            break;
        case SET_RES:
            {
            ResultAttrListConverter::asn1_to_idl_text(
			tsc->asn1_send_info_, tsc->idl_attr_type_list_text_);
            tsc->idl_reply_info_text_.set_reply_info(
			tsc->idl_attr_type_list_text_);
            }
			break;
        case ACTION_RES:
            {
            Asn1Value tmp_send_info=tsc->asn1_send_info_;
            ActionInfoReplyConverter::asn1_to_idl_text(
            tsc->asn1_cr_attr_value_, tmp_send_info,
            tsc->idl_action_reply_text_);
            tsc->idl_reply_info_text_.action_reply_info(
			tsc->idl_action_reply_text_);
            }
            break;

        case CREATE_RES:
            {
            ResultAttrListConverter::asn1_to_idl_text(
			tsc->asn1_send_info_, tsc->idl_attr_type_list_text_);
            tsc->idl_reply_info_text_.create_reply_info(
			tsc->idl_attr_type_list_text_);
            }
        }

        // OI converter
        if (tsc->asn1_send_object_name_ != EMPTY_ASN1_VALUE)
		{
           	DU oi_du = oi2fdn(tsc->asn1_send_object_name_);
            tsc->idl_oi_text_ = CORBA::string_dup(oi_du.chp());
        }

        // Time conversion
        if (tsc->asn1_send_curr_time_ != EMPTY_ASN1_VALUE)
            TimeConverter::asn1_to_idl(tsc->asn1_send_curr_time_, 
			tsc->text_curr_time_);
        else
			tsc->text_curr_time_	= CORBA::string_dup("");
    }
    catch(MTEMException &except)
    {
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(except);
    }
    catch ( CORBA::SystemException &except)
    {
        if(stored_corba_exception_ == NULL)
        {
		#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
		#else
		#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
		#else
        		stored_corba_exception_ = except._deep_copy();
		#endif
		#endif
        }
    }
}

void TSConverter::IDL2ASN1ConverterMain
(
	Ptr user_data,
	Ptr call_data
) throw ()
{
	TSConverter* tsc = (TSConverter *)user_data;
	if (tsc->bool_object_name_) tsc->convert_object_name_to_asn1(tsc);
	if (tsc->bool_ref_object_name_) tsc->convert_ref_object_name_to_asn1(tsc);
	if (tsc->bool_interface_name_) tsc->convert_interface_name_to_asn1(tsc);
	if (tsc->bool_filter_) tsc->convert_filter_to_asn1(tsc);
	if (tsc->bool_scope_) tsc->convert_scope_to_asn1(tsc);
	if (tsc->bool_attr_id_list_) tsc->convert_attr_id_list_to_asn1(tsc);
	if (tsc->bool_attr_value_seq_) tsc->convert_attr_value_seq_to_asn1(tsc);
	if (tsc->bool_set_list_) tsc->convert_set_arguments_to_asn1(tsc);
	if (tsc->bool_action_req_) tsc->convert_action_req_to_asn1(tsc);
	tsc->wakeup();
}

void TSConverter::convert_action_req_to_asn1
(
    TSConverter* tsc
) throw()
{
    try
    {
		CORBA::String_var act_type(tsc->action_name_);
		ActionInfoReplyConverter::idl_to_asn1(act_type,tsc->action_info_,
    	tsc->asn1_action_name_,tsc->asn1_action_info_);
    }
    catch(MTEMException &except)
    {
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(except);
    }
    catch ( CORBA::SystemException &except)
    {
		#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
		#else
		#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
		#else
        		stored_corba_exception_ = except._deep_copy();
		#endif
		#endif

    }
}

void TSConverter::convert_set_arguments_to_asn1
(
    TSConverter* tsc
) throw()
{
	SetArgConverter::idl_to_asn1(tsc->idl_set_list_, tsc->asn1_set_list_);
}

void TSConverter::convert_attr_value_seq_to_asn1
(
	TSConverter* tsc
) throw()
{
    try
    {
		// translate attr_list
		//Asn1Value out_attr_value_seq;
    	AttrValSeqConverter::idl_to_asn1(
			tsc->idl_attr_value_seq_, tsc->asn1_attr_value_seq_);
    }
	catch( MTEMException &e)
   	{
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }
}


void TSConverter::convert_filter_to_asn1
(
    TSConverter* tsc
) throw()
{
    try
    { 
	// translate filter
    CMISFilterConverter::idl_to_asn1(tsc->idl_filter_, tsc->asn1_filter_);
    }
	catch( MTEMException &e)
   	{
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }

}

void TSConverter::convert_interface_name_to_asn1
(
    TSConverter* tsc
) throw()
{

     TRY {
		tsc->asn1_interface_name_ = oid_to_asn1_value(
		DU((char *)tsc->idl_interface_name_));
     }
	BEGHANDLERS
    CATCHALL {
         if( stored_mt_exception_ == NULL)
            stored_mt_exception_ = new MTEMException("Invalid Interface name");
	}
    ENDHANDLERS

}


void TSConverter::convert_attr_id_list_to_asn1
(
    TSConverter* tsc
) throw()
{

	tsc->asn1_attr_id_list_ = Asn1IdlConvWrapper::convert_attr_id_list_to_asn1
	(tsc->idl_attr_id_list_);

}

void TSConverter::convert_scope_to_asn1
(
    TSConverter* tsc
) throw()
{
    try
    {
		tsc->asn1_scope_ = Asn1IdlConvWrapper::convert_scope_to_asn1(
			tsc->idl_scope_);
    }
	catch( MTEMException &e)
   	{
                
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }
}


void TSConverter::convert_object_name_to_asn1
(
	TSConverter* tsc
) throw()
{
    try
    {
		tsc->asn1_object_name_ =  
		Asn1IdlConvWrapper::convert_object_name_to_asn1(tsc->idl_object_name_);
    }
	catch( MTEMException &e)
   	{
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }

}

void TSConverter::convert_ref_object_name_to_asn1
(
    TSConverter* tsc
) throw()
{
    try
    {
		tsc->asn1_ref_object_name_ =
    		Asn1IdlConvWrapper::convert_object_name_to_asn1(tsc->idl_ref_object_name_);
    }
	catch( MTEMException &e)
   	{
		
		if( stored_mt_exception_ == NULL) 
		stored_mt_exception_ = new MTEMException(e);
    }
    catch( CORBA::SystemException &except)
    {
		if( stored_corba_exception_ == NULL) 
     	{
			#ifdef ORBACUS
    			stored_corba_exception_ = except._OB_clone();
			#else
			#ifdef ORBIX
        		stored_corba_exception_ = except._it_copy();
			#else
        		stored_corba_exception_ = except._deep_copy();
			#endif
			#endif
     	}
    }
}

void TSConverter::sleep()  
{
	try {
        sem_wait(&pending_);
    } catch (const EMException& e) {
		rgw_debug.print("TSConverter::sleep() Caught exception \n" ) ;
        throw;
    }
    if ( stored_mt_exception_ != NULL )
       throw *stored_mt_exception_;
    if ( stored_corba_exception_ != NULL )
       throw *stored_corba_exception_;
}

void TSConverter::wakeup() throw()
{
	sem_post(&pending_);
}
