#ifndef _AUTH_SERVER_BODY_HH_
#define _AUTH_SERVER_BODY_HH_

// 	Copyright 11/07/01 Sun Microsystems, Inc. All Rights Reserved.

#pragma ident  "@(#)auth_server_body.hh	1.9 01/11/07 Sun Microsystems"

#ifdef ORBACUS
	#include <Any.h>
#else 
#ifdef ORBIX
	#include <omg/orb.hh>	
#else
	#include <any.h>
#endif
#endif

#include <rw/cstring.h>
#include "auth_server.hh"

class AuthenticationServerBody
    : public AuthenticationServer
{
  public:
    AuthenticationServerBody() throw();
    
    ~AuthenticationServerBody() throw();

    CORBA::Boolean
    decrypt_user_profile(
	const CORBA::Any& user_profile_blob,
	RWCString& user_name,
	RWCString& password,
	bool &crypted
    ) throw();

  private:
    static RWCString USER_NAME_;

    // Explicitly Suppressed
    AuthenticationServerBody(const AuthenticationServerBody&);
    AuthenticationServerBody&
    operator=(
	const AuthenticationServerBody&
    );
};


#endif //_AUTH_SERVER_BODY_HH_
