// 	Copyright 06/20/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)corba_eds.cc	1.1 01/06/20 Sun Microsystems"
#include <corba_eds.hh>
#include <egw_global.hh> 
#include <event_consumer.hh> 
#include <cgw_utils/cgw_global.hh> 
#include <cgw_utils/cgw_utils.hh> 
void corba_eds_interface::init_cgw_globals(int dbgport,char *log,int max_threads_)
{
	CGWGlobal::debug_port =dbgport;
	CGWGlobal::default_log_file = "em_corba_eds.log";
	CGWGlobal::log_file =log;
	CGWGlobal::max_threads_ =max_threads_;
}
void corba_eds_interface::init_orb_connections(
    char *epr_name,
    int argc,
    char* argv[]
	)
{
    CORBA::Object_var object;
    try {
        if (!CGWUtils::resolve_sem_cgw_nameservice(argc,argv)) {
                egw_error.print("Could not resolve Naming Service\n");
                exit(1);

        }
    }
    catch (const CORBA::Exception& e) {
        egw_error.print( " ERROR: Could not get the root naming context\n");
        exit(2);
    }
    egw_debug.print("PASSED: Getting the root/default naming context\n");


    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup(epr_name);
    name[0].kind = CORBA::string_dup("");

    try {
        object = CGWGlobal::root_nc_->resolve(name);
        EGWGlobal::epr_ = EventPortRegistry::_narrow(object);
        if (CORBA::is_nil(EGWGlobal::epr_)) {
             egw_error.print( " ERROR: Could not get EventPortRegistry\n");
            exit(3);
        }
    }
    catch (const CORBA::Exception& e) {
             egw_error.print( " ERROR: Could not get EventPortRegistry\n");
        exit(4);
    }


	CGWGlobal::dispatch_thread_pool_ =
    new SemThreadPool((size_t) CGWGlobal::max_threads_);
}
 
void corba_eds_interface::shutdown_orb_connections()
{
    if ((CGWGlobal::dispatch_thread_pool_) != NULL ){ 
    	if (CGWGlobal::dispatch_thread_pool_->isShutdown()) return;
    
    	try {
	    EventConsumer::disconnect_all_consumers();
	    CGWGlobal::dispatch_thread_pool_->shutdown();
    	}
    	catch (const EMException& e) {
	    egw_error.print(
	    "Some thread in the thread pool raised an exception: %s\n", e.why());
    	}
    }
#if defined(ORBACUS) || defined(ORBIX) 
    CGWGlobal::orb_->shutdown(true);
#else
   CGWGlobal::orb_->shutdown();
#endif
}
const Asn1Value& corba_eds_interface::get_user_id(const RWCString& ae_title) throw (EMException)
{
	try{
	EventConsumer* const consumer = EventConsumer::get_consumer(ae_title);
	return consumer->get_user_id();
	}
	catch (const JIDM::NoEventPort& e) {
        egw_error.print( "Failed to get event Port for consumer %s:\n\t %s Exception thrown\n ", ae_title.data(), e._name());
	throw EMException("JIDM::NoEventPort",e._name());
       
    }
    catch (const CORBA::Exception& e) {
        egw_error.print(
            "Failed to find  consumer %s:\n\t %s Exception thrown\n",
            ae_title.data(), e._name());
	throw EMException("CORBA::Exception",e._name());
    }
}
void corba_eds_interface::send_event  (const RWCString& ae_title,EventReq& event_msg,bool val) throw (EMException)
{
	try{
	EventConsumer* const consumer = EventConsumer::get_consumer(ae_title);
	consumer->push(event_msg,val);
	}

 	catch (const JIDM::NoEventPort& e) {
        egw_error.print(
            "Failed to get event Port for consumer %s:\n\t %s Exception thrown\n ", ae_title.data(), e._name());

 	}
	catch (const CORBA::Exception& e) {
	egw_error.print(
	"Failed to deliver event to consumer %s:\n\t %s Exception thrown\n", ae_title.data(), e._name());
    	}
	  catch (const SEMTHRInvalidPointer& e) {
		egw_error.print("Failed to deliver event to consumer %s: %s.\n", ae_title.data(), e.why());
    	}

}

void corba_eds_interface::remove_event_consumer(const RWCString & ae_title)
{
	EventConsumer::remove_consumer(ae_title);
}

void corba_eds_interface::add_event_consumer(const RWCString & ae_title)
{
	try{
	EventConsumer* const consumer = EventConsumer::get_consumer(ae_title);
	}
	catch (const JIDM::NoEventPort& e) {
        egw_error.print( "Failed to get event Port for consumer %s:\n\t %s Exception thrown\n ", ae_title.data(), e._name());
	throw EMException("JIDM::NoEventPort",e._name());
       
    }
    catch (const CORBA::Exception& e) {
        egw_error.print(
            "Failed to add  consumer %s:\n\t %s Exception thrown\n",
            ae_title.data(), e._name());
	throw EMException("CORBA::Exception",e._name());
    }
}
