/***************************************************************************
 *
 *			   INFORMIX SOFTWARE, INC.
 *
 *			      PROPRIETARY DATA
 *
 *	THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF 
 *	INFORMIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *	CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR 
 *	DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT 
 *	SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
 *
 *	THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *	SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE. 
 *	UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *  Product:	
 *
 *  Title:	mirlt.h
 *  Sccsid:    
 *  Author:	
 *  Date:	
 *  Description:
 *		Public interface to Rtree functionality 
 *
 ************************************************************************
 */

#ifndef MIRLT_INCLUDED
#define MIRLT_INCLUDED

#include "mitypes.h"
#include "miami.h"

/* -----------------------------------
 * Support for Oncheck customization *
 * ===================================
 */

/*
 * Type of Rtree entry. (See: mi_rltchk_type() accessor)
 */
typedef enum mi_rltchk_types
    {
    MI_RLT_PAGE,	/* Page level (glue) record */
    MI_RLT_ITUP,	/* Internal Item Record */
    MI_RLT_LTUP,	/* Leaf-level (user data) record */
    MI_RLT_CHKEND	/* Last-call indicator */
    } MI_RLTCHK_TYPES;
/*
 * Opaque handle for descriptor of oncheck instance of entry in an Rtree
 */
typedef struct mi_rltchk_desc MI_RLTCHK_DESC;

/* *****************************
 * Accessors on MI_RLTCHK_DESC *
 * *****************************
 */

/* 
 * General Info
 */
MI_DECL
mi_boolean MI_PROC_EXPORT
mi_rltchk_isroot ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_level ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pageno ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_options ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
MI_AM_TABLE_DESC * MI_PROC_EXPORT
mi_rltchk_amtabdesc ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
MI_RLTCHK_TYPES MI_PROC_EXPORT
mi_rltchk_type ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
MI_DATUM MI_PROC_EXPORT
mi_rltchk_rootbb ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_errcode ARGS((MI_RLTCHK_DESC *chk_desc));

/* 
 * Accessors valid only for type MI_RLT_PAGE
 */
MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pgitems ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pgspace_used ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pgspace_free ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pgrlink ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_pgpvn ARGS((MI_RLTCHK_DESC *chk_desc));

/*
 * Accessors valid only for type MI_RLT_ITUP
 */
MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_itpvn ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_itchld ARGS((MI_RLTCHK_DESC *chk_desc));

/*
 * Accessors valid only for type MI_RLT_LTUP
 */
MI_DECL
mi_boolean MI_PROC_EXPORT
mi_rltchk_ltdel ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_ltsize ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_ltrowid ARGS((MI_RLTCHK_DESC *chk_desc));

MI_DECL
mi_integer MI_PROC_EXPORT
mi_rltchk_ltfragid ARGS((MI_RLTCHK_DESC *chk_desc));


#endif /* MIRLT_INCLUDED */
