#include "plcstdrv.h"

int         testcall();
int         testunload();
int         div_by_2();
int         cust_blob_func();
int         custnomap1();
int         custnomap2();

struct functable functiontable[] =
{
    {"testcall", testcall},
    {"testunload", testunload},
    {"div_by_2", div_by_2},
    {"cust_blob_func", cust_blob_func},
    {"custnomap1", custnomap1},
    {"custnomap2", custnomap2},
    {0, 0}    
};

/******************************************************************************
***  NOTE: THERE  IS NO  NEED TO MODIFY THE FUNCTION BELOW TO ADD           ***
***        CONVERSION  FUNCTIONS                                            ***
******************************************************************************/

/******************************************************************************
     ROUTINE:   	pl_get_user_function

     PURPOSE:  		Return a pointer to a function to perform field
			manipulation during conversions

     PARAMETERS:        funcname - Text name of a user supplied
				   conversion function to return a pointer to


     ALGORITHM:		Loop over the user defined functiontable array and
                        return the function corresponding to  'funcname'.
                        Return NULL if not found.


*******************************************************************************/

(*pl_get_user_function(funcname)) ()
    char       *funcname;
{
    struct functable *fptr;
 
    /*
     *  If the function does not exist, return a null if not found.
     */
 
    fptr = functiontable;
    while (fptr->fname)
        {
        if (strcmp(fptr->fname, funcname) == 0)
            return (fptr->func);
        fptr++;
        }
    return (0);
}

