/****************************************************************************
 *
 *                               IBM INC.
 *
 *                           PROPRIETARY DATA
 *
 * Licensed Material - Property Of IBM
 *
 * "Restricted Materails of IBM"
 *
 * IBM Informix Client SDK
 *
 * (c)  Copyright IBM Corporation 2002. All rights reserved.
 *
 *  Title:	srvinfo.h
 *  Sccsid:	@(#)srvinfo.h	9.1	6/3/92  12:10:04
 *  Description:
 *		Server information structure and its related macros
 *
 ***************************************************************************
 */
#ifndef SRVINFO_H
#define SRVINFO_H

#include "ifxtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 *  WARNING:  This is an ESQL released header file.  Please notify client
 *	      folks if you need to make any changes.  We need to gurantee
 *	      backward compatibility on the data structures and macros
 *	      defined here.
 ***************************************************************************/

#define PVNAMELEN	80

typedef struct SrvInfo
	{
#ifndef TURBO	/* For client applications */
	muint SQLIVersion;	/* version of SQLI, see sqlmtype.h */
	muint TypeList;		/* type of server, bit map */
	muint CapList;		/* server's capabilities, bit map */
	muint DBList;		/* database characteristics */
	muint Reserved1;	/* reserved */
	muint Reserved2;	/* reserved */
#else		/* For backend server only */
	uint4 SQLIVersion;		/* version of SQLI, see sqlmtype.h */
	uint4 TypeList;			/* type of server, bit map */
	uint4 CapList;			/* server's capabilities, bit map */
	uint4 DBList;			/* database characteristics */
	uint4 Reserved1;		/* reserved */
	uint4 Reserved2;		/* reserved */
#endif
	char ProdVersion[PVNAMELEN+1];	/* product name */
	} ifx_srvinfo_t;


/*
 * Server's types (used with INFO_TYPE submessage of SQ_INFO)
 * These values could be sent in the ORed format or as a series
 * of four-byte values
 */
#define TYP_SE		0x00000001L	/* on if SE, off OnLine */
#define TYP_MT		0x00000002L	/* on if multithreaded */
#define TYP_RDA		0x00000004L	/* on if RDA gateway */
#define TYP_DRDA 	0x00000008L	/* on if DRDA gateway */

/* From OWS group */
#ifdef NT
#define TYP_OWS       0x00000010L     /* on if OnLine Workgroup Server */
 
/* From Gateway group - UDJ 01/16/96 */
#define TYP_EDASQL    0x00000020L     /* on if EDA/SQL gateway */
#define TYP_EGM       0x00000040L     /* on if Enterprise Gateway Manager */
 
#endif /* NT */
/*
 * Capabilities (used with INFO_CAPABILITY submessage of SQ_INFO
 * These values could be sent in the ORed format or as a series
 * of four-byte values.
 * The capabilities can also be used to describe the client SQLI.
 */
#define CAP_NLS		0x00000001L	/* on if NLS ready */
#define CAP_NCHAR	0x00000002L	/* on if able to treat CHAR */
					/* as NCHAR */
#define CAP_MCOLL	0x00000004L	/* on if multiple coll seq */
#define CAP_MLANG	0x00000008L	/* on if multiple lang */
#define CAP_MBYTE	0x00000010L	/* on if multiple byte */
#define CAP_STAR	0x00000020L	/* on if distributed capable */
#define CAP_XA		0x00000040L	/* on if XA capable */

/*
 * Public IFX functions to obtain server info.
 */

#ifndef TURBO
#if defined(__STDC__) || defined(__cplusplus)
extern	mint ifx_srvinfo(ifx_srvinfo_t *info);
#else /* defined(__STDC__) || defined(__cplusplus)  */
extern	mint ifx_srvinfo();
#endif /* defined(__STDC__) || defined(__cplusplus)  */
#endif /* TURBO */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* SRVINFO_H */
