/***************************************************************************
 *
 *                         INFORMIX SOFTWARE, INC.
 *
 *                            PROPRIETARY DATA
 *
 *      THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF
 *      INFORMIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *      CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR
 *      DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT
 *      SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
 *
 *      THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *      SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE.
 *      UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *
 *  Title:      cdrapi.h
 *  Description:
 *              definitions for CDR API
 *
 ***************************************************************************
 */
#ifndef CDRAPI_H
#define CDRAPI_H

#ifdef NT
#include <time.h>
#else
#include <sys/time.h>		/* time_t */
#endif /*NT*/

#include <cdrerr.h>


#define CDR_NAMESIZE		128	/* max len for CDR identifiers */
#define CDR_PATHSIZE		256

#define SVR_NAMESIZE		CDR_NAMESIZE	/* for server identifiers */
#define CDR_USERSIZE		34	/* max name len for user name */
								/* 32 + 2bytes to allow quoted ownernames
                                   for ansi support */
#ifndef CDR_DIRNAMESIZE
#define CDR_DIRNAMESIZE		CDR_PATHSIZE /* ATS and RIS dir names */
#endif
#define CDR_LOGFILESIZE		CDR_PATHSIZE /* log filename */

#define CDR_SELECTSIZE		8192  /* max len for select statement */
#define CDR_STOREDPROCSIZE	128	/* max len for stored procedure */

/* GLS support for client locale field widths */
#ifndef TURBO /* frontend */
/* max # of bytes occupied by a logical multi-byte character */
#define MB_MAXSIZE			4 
#define CDR_GL_NAMESIZE		(MB_MAXSIZE * CDR_NAMESIZE)
#define SVR_GL_NAMESIZE		(MB_MAXSIZE * SVR_NAMESIZE)
#define CDR_GL_USERSIZE		(MB_MAXSIZE * CDR_USERSIZE)
#define CDR_GL_SELECTSIZE	(MB_MAXSIZE * CDR_SELECTSIZE)
#define CDR_GL_SPSIZE		(MB_MAXSIZE * CDR_STOREDPROCSIZE)
#else /* backend */
#define CDR_GL_NAMESIZE		CDR_NAMESIZE
#define SVR_GL_NAMESIZE		SVR_NAMESIZE
#define CDR_GL_USERSIZE		CDR_USERSIZE
#define CDR_GL_SELECTSIZE	CDR_SELECTSIZE
#define CDR_GL_SPSIZE		CDR_STOREDPROCSIZE
#endif /* ifndef TURBO */

/*
 * API datatypes
 */ 
#ifdef TURBO
#include <machine.h>
#else
#include <datetime.h>
#include <decimal.h>
#ifndef MACHINE_INCL
#ifndef _IFXTYPES_H_
typedef unsigned char		uint1;
typedef unsigned short		uint2;
#ifdef M64ADDR
typedef unsigned int 		uint4;
#else
typedef unsigned long 		uint4;
#endif /* M64ADDR */
#endif /* _IFXTYPES_H_ */
#ifndef  IDENTSIZE
#define IDENTSIZE			SVR_NAMESIZE
#endif /* IDENTSIZE */
#endif /* !define(MACHINE_INCL) */
#endif /* defined(TURBO) */

/* replicate definition flags */
#define D_MASTER		0x01
#define D_PARTICIPANTS	0x02

/* replicate participant modes */
#define A_RDONLYMODE	0x01
#define A_PRIMARYMODE	0x02
/* replicate participant flags stored in the same field as modes */
#define A_USETABOWNER	0x04

#define	GET_PART_MODE(_m)	((_m) & (A_RDONLYMODE|A_PRIMARYMODE))
#define	GET_PART_FLAGS(_f)	((_f) & A_USETABOWNER)

/* replicate attribute flags */
#define A_NONSERIAL		0x00000001
#define A_CANNONICAL	0x00000002

/* Same define with correct spelling; can't remove the line above
 * because of existing applications. 
 */
#define A_CANONICAL		0x00000002  
#define A_BEGIN			0x00000004
#define A_FREQ			0x00000008
#define A_THRESHOLD		0x00000010

/* group definition sequential flags */
#define A_SEQ			0x00000020
#define A_NONSEQ		0x00000040
#define ATTRSMASK		0x000000FF	/* Mask out everybody else */

/* conflict resoluction rules */
#define A_PRIMARY		0x00010000
#define A_SECONDARY		0x01000000

/*
 * conflict resolution scope and spooling flags
 * NOTE: these CANNOT conflict with replicate attribute flags above.
 */
#define A_TSCOPE		0x00000100	/* txn conflict resolution scope */
#define A_RSCOPE                0x00000200      /* row-by-row scope */
#define A_RIS                   0x00000400      /* activate RIS */
#define A_NRIS                  0x00002000      /* deactivate RIS */
#define A_ATS                   0x00000800      /* activate ATS */
#define A_NATS                  0x00004000      /* deactivate ATS */
#define A_TRIGGER               0x00001000      /* fire triggers */
#define A_NTRIGGER              0x00008000      /* don't fire triggers */

#define A_SCOPE			(A_TSCOPE | A_RSCOPE)	/* All possible scopes */
#define A_DSFLAGS       (A_SCOPE | A_TRIGGER | A_ATS | A_RIS) /* All possible dsFlags */
											/* should go here */
#define CRFLAGMASK		0x0000FF00	/* Mask out all but these flags */


/* conflict resolution rules */
#define R_TIMESTAMP		0x01
#define R_STOREDPROC	0x02
#define R_IGNORE		0x04
#define R_DEFAULT		0x04
#define R_MANUAL		0x10
/* All possible conflict rules */
#define R_CRRULES (R_TIMESTAMP | R_STOREDPROC | R_IGNORE)

/* stored procedure options */
#define R_STOREDPROC_OPTM	0x01	/* optimized option */
#define R_STOREDPROC_EXEC	0x02	/* always execute option */

/* All possible conflict rules */
#define R_CRRULES (R_TIMESTAMP | R_STOREDPROC | R_IGNORE)

/* server attribute flags */
#define A_IDLE			0x01
#define A_SENDQ			0x02
#define A_RECVQ			0x04
#define A_ATSDIR		0x08
#define A_RISDIR		0x10
#define A_INIT			0x20
#define A_SYNCSERV		0x40

#define A_ROOT			0x0100
#define A_NONROOT		0x0200
#define A_LEAF		 	0x0400	

/* A_SUSPENDED can never be set by api, used extensively on server recovery */
#define A_SUSPENDED     0x4000  /* do not add to A_ROUTEMASK */

/* flags stored in global catalog */
#define A_ROUTEMASK	(A_ROOT|A_NONROOT|A_LEAF)

/* participate group operators */
#define A_ADD			1
#define A_REMOVE		2

/* flags  for  forced spooling of queues  */
#define A_FORCE_SPOOL   0x01

typedef struct plist
{
    char	serv[SVR_GL_NAMESIZE + 1];			/* server name */
    char	db[SVR_GL_NAMESIZE + 1];			/* database */
    char	table[SVR_GL_NAMESIZE + 1];			/* table */
    char	owner[CDR_GL_USERSIZE + 1];			/* owner */
    char	selectstmt[CDR_GL_SELECTSIZE + 1];	/* select stmt */
	uint4	partmode;							/* participant mode */
    struct plist	*part_next;					/* next participant */
} CDR_plist;



typedef struct freq
{
    uint2	hr;		/* hour 0-32767 */
    uint1	min;	/* minute 0-59 */
    uint1	type;	/* see frequency types below values */
    uint1	day;
    uint1	month;
} CDR_freq;


/* frequency types */
#define FREQ_IMMED			1 /* immediate */
#define FREQ_INTERVAL		2 /* every hour,minute */
#define	FREQ_TIME			3 /* at specified time */
#define FREQ_DAYOFWEEK		4 /* day=day of week (1-7) */
#define FREQ_DAYOFMONTH		5 /* day=day of month (1-31,'L') */


typedef struct conf
{
	uint1	method;							/* conflict method */
	char	storedproc[CDR_GL_SPSIZE + 1];	/* stored procedure */
	uint1	storedprocopt;					/* stored procedure option */
} CDR_conf;



typedef struct repl_attrs
{
	uint4		flags;		/* replicate attributes */
	time_t		begin;		/* start time */
	CDR_freq*	freq;		/* freq tx's sent */
	uint4		threshold;	/* threshold (in bytes) */
	CDR_conf*	primary;	/* primary method*/
	CDR_conf*	secondary;	/* secondary method */
} CDR_repl_attrs;


typedef struct idlist
{
	char			id[SVR_GL_NAMESIZE+1];	/* identifier */
	struct idlist*	id_next;				/* next identifier */
} CDR_idlist;


typedef struct q_type
{
	uint1	 qtype;						/*
										 * Unused field, only present
										 * for backward compatability
										 */
	char	 dbspace[SVR_GL_NAMESIZE+1]; /* dbspace for Q_STABLE */
} CDR_qtype;


typedef struct serv_attrs
{
	uint2		sflags;						/* definition flags */
	uint2		idle;						/* connection time-out (minutes) */
	CDR_qtype*	sendq;						/* send queue type */
	CDR_qtype*	recvq;						/* receive queue type */
	char		atsDir[CDR_DIRNAMESIZE+1];	/*  ATS spool dir */
	char		risDir[CDR_DIRNAMESIZE+1];	/*  RIS spool dir */
	char		syncServ[SVR_GL_NAMESIZE+1];/* catalog sync server name */
} CDR_serv_attrs;

#ifndef TURBO
/*
 * Used to make the current CLI and API work with old versions of CDR/SERVER.
 * Value of CDRversion                   Server Version(s)
 * -------------------                   -----------------
 *       1                               7.2x
 *       2                               7.3
 *       3                               7.31 and 9.20
 */
extern int CDRversion;

extern int cdr_define_repl(char *, CDR_repl_attrs *, uint4, CDR_plist *, 
						   void **);
extern int cdr_modify_repl(char *, CDR_repl_attrs *);
extern int cdr_start_repl(char	*, CDR_idlist *, time_t, void **);
extern int cdr_stop_repl(char *, CDR_idlist *, time_t, void **);
extern int cdr_delete_repl(char *, time_t);
extern int cdr_suspend_repl (char*, time_t);
extern int cdr_resume_repl (char*, time_t);
extern int cdr_participate_repl(char *, uint1, CDR_plist *, void **) ;
extern int cdr_modify_replmode(char *, CDR_plist *, void **) ;
extern int cdr_define_serv(char *, CDR_serv_attrs *);
extern int cdr_modify_serv(char *, CDR_serv_attrs *);
extern int cdr_delete_serv(char *);
extern int cdr_suspend_serv(char *, CDR_idlist *, time_t, void **);
extern int cdr_resume_serv(char *, CDR_idlist *, time_t, void **);
extern int cdr_modify_servmode(char *, uint4);
extern int cdr_participate_group(char*, uint1, CDR_idlist*, void**);
extern int cdr_define_group(char*, uint4, CDR_idlist*, CDR_freq*, void**);
extern int cdr_delete_group(char*, time_t);
extern int cdr_start_group(char*, CDR_idlist*, time_t, void**);
extern int cdr_stop_group(char*, CDR_idlist*, time_t, void**);
extern int cdr_suspend_group(char*, time_t);
extern int cdr_resume_group(char*, time_t);
extern int cdr_modify_group(char*, uint4, CDR_freq*);
extern int cdr_prune_errors(dtime_t *, dtime_t *, int);
extern int cdr_prune_single_error(char *, long);
extern int cdr_error_reviewed(char *, long);
extern int cdr_move_errortab(char *, int);
extern int cdr_connect(char *);
extern int cdr_start_cdr(void);
extern int cdr_stop_cdr(void);
extern int cdr_stop_cdr2(uint4);
extern int cdr_connect_serv(char *);
extern int cdr_disconnect_serv(char *);
#endif /* TURBO */

#endif /* CDRAPI_H */

