// Copyright 06/22/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)jidm_proxy_agent_impl.hh	1.4 01/06/22 Sun Microsystems"

#ifndef _JIDM_PROXY_AGENT_IMPL_HH_
#define _JIDM_PROXY_AGENT_IMPL_HH_

#ifdef ORBACUS
#include <OB/CORBA.h>
#include "jidm/JIDM_skel.h"
#else 
#ifdef ORBIX
#include "jidm/JIDMS.hh"
#else
#include "jidm/JIDM_s.hh"
#endif
#endif


class JIDMProxyAgentImpl
{
	public:
   
		// Required for instantiating RWTValSlist<JIDMProxyAgentImpl>
		JIDMProxyAgentImpl() throw();

		JIDMProxyAgentImpl(const JIDMProxyAgentImpl&) throw();

		JIDMProxyAgentImpl&
		operator=(const JIDMProxyAgentImpl&) throw();
    
		int
		operator==(const JIDMProxyAgentImpl&) throw();

		JIDMProxyAgentImpl(const JIDM::Criteria& the_criteria)
		throw (
		JIDM::InvalidCriteria
		);
    
		virtual ~JIDMProxyAgentImpl() throw();

		JIDM::Criteria*
		access_criteria() throw(CORBA::SystemException);
   
		virtual JIDM::Criteria*
		destroy(
		JIDM::ProxyAgent::DestructionMode mode,
		const JIDM::Criteria& the_criteria
		) throw (
		JIDM::InvalidCriteria,
		JIDM::CannotMeetCriteria,
		CORBA::SystemException
		);

		CosNaming::NamingContext_ptr 
		get_domain_naming_context() throw();
    
		CosLifeCycle::FactoryFinder_ptr
		get_domain_factory_finder() throw();

		void add_reference_();
  
	private:

		U32 refcnt_ ;
		rwlock_t proxy_agent_refcnt_lock_;
		JIDM::Criteria_var access_criteria_;
		JIDM::ProxyAgentController_var finder_controller_;
};

#endif //_JIDM_PROXY_AGENT_IMPL_HH_
