// 	Copyright 10/18/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)corba_eds.hh	1.2 01/10/18 Sun Microsystems"

#ifndef CORBA_EDS_HH_ 
#define CORBA_EDS_HH_ 
#include <pmi/debug.hh>
#include <pmi/message.hh>
#include <em_c++utils/em_exception.hh>
#include<rw/cstring.h>

Debug_extern(egw_error)
Debug_extern(egw_debug)
class corba_eds_interface
{
   public:
	static void init_cgw_globals(int dbgport,char *log,int max_threads_);
	static void init_orb_connections(
    		char *epr_name,
    		int argc,
    		char* argv[]
	);
	static void shutdown_orb_connections();
	static void send_event  (const RWCString& ae_title,EventReq& event_msg,bool val)throw (EMException);
	static const Asn1Value& get_user_id(const RWCString& ae_title) throw (EMException);
	static void remove_event_consumer(const RWCString& ae_title);
	static void add_event_consumer(const RWCString& ae_title);
  private:
    corba_eds_interface();
    ~corba_eds_interface();
    corba_eds_interface(const corba_eds_interface&);
    corba_eds_interface operator=(const corba_eds_interface&);
};
#endif
