/***************************************************************************
 *
 *			   INFORMIX SOFTWARE, INC.
 *
 *			      PROPRIETARY DATA
 *
 *	THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF 
 *	INFORMIX SOFTWARE, INC.	 THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *	CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR 
 *	DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT 
 *	SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
 *
 *	THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *	SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE. 
 *	UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *  Title:	cdrerr.h
 *
 *  Description:
 *		return codes for CDR api
 *
 ***************************************************************************
 */

#ifndef CDRERR_DOT_H
#define CDRERR_DOT_H

#define CDR_SUCCESS		0	/* command successful */
#define CDR_ENOCONNECT	1	/* no connection for the specified server */
#define CDR_EBUF		2	/* future use */
#define CDR_ECOLUNDEF	3	/* table column undefined */
#define CDR_ECOMPAT		4	/* incompatible server version */
#define CDR_ECONNECT	5	/* unable to connect to server specified */
#define CDR_EDBDNE		6	/* database does not exist */
#define CDR_EDBLOG		7	/* database not logged */
#define CDR_EFREQ		8	/* Bad or mismatched frequency attributes */
#define CDR_ECONNECTED	9	/* already connected to specified server */
#define CDR_EGRPSTATE	10	/* illegal group state change */
#define CDR_EGRPUNDEF	11	/* undefined group */
#define CDR_EGRPUNIQ	12	/* group name already in use */
#define CDR_EIDLE		13	/* invalid idle time */
#define CDR_EINVOP		14	/* invalid operator or specifier */
#define CDR_ELEN		15	/* future use */
#define CDR_ELOGFILE	16	/* future use */
#define CDR_ENOPART		17	/* participants required for operation specified */
#define CDR_ENOPKEY		18	/* table does not contain primary key */
#define CDR_EOWNER		19	/* table does not exist */
#define CDR_EPACTIVE	20	/* server already participating in replicate */
#define CDR_EPDEF		21	/* future use */
#define CDR_EPKEYSELCT	22	/* primary key not contained in select clause */
#define CDR_EPRIKEY		23	/* future use */
#define CDR_ERECVQ		24	/* Dbspace for receive queue does not exist */
#define CDR_EREPACTIVE	25	/* replicate already participating in a group */
#define CDR_EREPDEF		26	/* group operation not permitted on replicate */
#define CDR_EREPLSYN	27	/* future use */
#define CDR_EREPLUNIQ	28	/* replicate name already in use */
#define CDR_ETBLDNE		29	/* table does not exist */
#define CDR_EREPSTATE	30	/* illegal replicate state change */
#define CDR_EREPUNDEF	31	/* undefined replicate */
#define CDR_ESENDQ		32	/* dbspace specified for the send queue does
								not exist */
#define CDR_ESERVDEF	33	/* server not participant in replicate/group */
#define CDR_ESERVMAX	34	/* not used */
#define CDR_ESERVRESOLV	35	/* server not defined in sqlhosts */
#define CDR_ESERVSET	36	/* disjoint servers for replicates */
#define CDR_ESERVUNDEF	37	/* undefined server */
#define CDR_ESPDNE		38	/* stored procedure does not exist */
#define CDR_ESQLSYN		39	/* illegal select syntax */
#define CDR_ESQLUNSUP	40	/* unsupported SQL syntax (join, etc..) */
#define CDR_ETHOLD		41	/* future use */
#define CDR_ETIME		42	/* invalid time */
#define CDR_EVALID		43	/* participants required for specified operation */
#define CDR_ENAMERR		44	/* illegal name syntax */
#define CDR_EPART		45	/* invalid participant */
#define CDR_EREPL		46	/* future use */
#define CDR_ESERV		47	/* invalid server */	
#define CDR_ENOMEM		48	/* out of memory */
#define CDR_EREPMAX		49	/* maximum number of replicates exceeded */
#define CDR_EPARTMAX	50	/* maximum participants */
#define CDR_ERUMOR		51	/* attempt to delete server remotely */
#define CDR_ESERVUNIQ	52	/* server name already in use */
#define CDR_EDUPL		53	/* duplicate server or replicate */
#define CDR_EBADCRULE	54	/* Bad conflict rule specified */
#define CDR_ENOSCOPE	55	/* Resolution scope not specified */
#define CDR_ESCOLSDNE	56	/* Shadow columns do not exist for table */
#define CDR_ECRDELTAB	57	/* Error creating delete table */
#define CDR_ENOCRULE	58	/* No conflict resolution rule specified */
#define CDR_EBADSCOLS	59	/* Table has badtype for shadow columns or has
								shadow columns at wrong place */
#define CDR_EGRPPART	60	/* illegal operation on group participant */ 
#define CDR_ENOPERM		61	/* user doesn't have permission to issue command */ 
#define CDR_ENOCDR		62	/* CDR not active */
#define CDR_ECDR		63	/* CDR already active */
#define CDR_ENOSYNC		64	/* remote/cyclic synchronization not allowed */
#define CDR_ESERVID		65	/* server identifier already in use */		
#define CDR_ENOTIME		66	/* No upper time for prune error */
#define CDR_ERRNOTFOUND	67	/* Error not found for delete or update */
#define CDR_EPARTMODE	68	/* illegal participant mode */
#define CDR_ECONFLICT	69	/* conflict mode for replicate not ignore */
#define CDR_ECONSAME	70	/* connect/disconnect to/from same server */
#define CDR_EROOT		71	/* conflicting root server flags */
#define CDR_EPARENT		72	/* cannot delete server with children */
#define CDR_ESPAROOT	73	/* leaf-root configuration not allowed */
#define CDR_ELIMITED	75	/* request denied on limited server */
#define CDR_EMSGFORMAT	76	/* unsupported message format */
#define CDR_EDROPDB		77	/* couldn't drop syscdr database (sqerr -425) */ 
#define CDR_EATSDIR		78	/* ATS directory does not exist */
#define CDR_ERISDIR		79	/* RIS directory does not exist */
#define CDR_ECRCHANGE	80	/* Illegal Conflict resolution change */
#define CDR_EUDTBADCOL  81  /* UDT collection types not allowed */
#define CDR_EUDTEXPR	82	/* UDTs not allowed in expressions 
							   (such as where clauses) */
#define CDR_ENOUDTPKEY	83	/* No UDTs in primary key allowed */
#define CDR_ESYNC		84	/* No sync server with non-root & leaf */
#define CDR_EPARTFLAGS  85	/* incorrect participant flags */
#define CDR_ELEAF       86  /* conflicting leaf server flags or
							   attempt to sync with leaf server */
#define CDR_ESTOPFLAGS  87  /* invalid cdr stop options */
#define CDR_EMODRECVQ	89	/* cannot modify dbspace for queues */
#define CDR_ECLOCKSKEW	90  /* system clocks are out of synchronizaton */
#define CDR_ESERVSTATE	91	/* invalid server state transition */


#define CDR_ESERVERR	100	/* fatal server error */
#define CDR_ENOSUPPORT	101	/* unsupported feature */
#define CDR_EINVSYNC	102	/* Root server can not sync with non
							 * root or leaf servers */
#define CDR_EINVCONNECT 103 /* Invalid server to connect */
#define CDR_ETEMPDB  	104 /* Can not use temp dbspaces for Send/Recv 
							 * queues and error tables */

#endif /* CDRERR_DOT_H */
