/*
 * Decompiled with CFR 0.152.
 */
package com.sun.em.jdmk.mpa;

import com.sun.em.jdmk.mpa.ResourceBundleHolder;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class Client {
    private RemoteMBeanServer connectorClient = null;
    private String domain;
    private boolean connected;
    private boolean debug;
    private static int ASSOC_RELEASED = 46;
    private static int NO_SUCH_OI = 15;
    private static int NO_SUCH_OC = 14;
    private static int DUPLICATE_OI = 25;
    private static int ACCESS_DENIED = 16;
    private static int NO_SUCH_ATTR = 19;
    private static int INVALID_ATTR_VAL = 20;
    private static int GET_LIST_ERR = 21;
    private static int PROCESS_FAILURE = 24;
    private static int INVALID_OI = 33;
    private static int SUCCESS = 0;
    private static int CONNECT_FAILED = 200;
    private static int LOST_CONNECTION = 201;
    private static int CANNOT_TRANSLATE = 202;
    private static int UNSUPPORTED_FILTER = 203;
    private static int NO_SUCH_METHOD = 204;
    private static final PrintStream o = System.out;

    public Client(boolean bl) {
        this.debug = bl;
        this.connected = false;
    }

    public int connectAgent(String string, int n, String string2) {
        if (this.debug) {
            o.println("Client.connectAgent: connecting to " + string + " " + n + " " + string2);
        }
        if (this.connected) {
            return SUCCESS;
        }
        try {
            RmiConnectorAddress rmiConnectorAddress = new RmiConnectorAddress(string, n, string2);
            this.connectorClient = new RmiConnectorClient();
            this.connectorClient.connect((ConnectorAddress)rmiConnectorAddress);
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("CommunicationException connecting"));
            return CONNECT_FAILED;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Connect failed"));
            throwable.printStackTrace();
            return CONNECT_FAILED;
        }
        this.connected = true;
        if (this.debug) {
            o.println("Client.connectAgent: Connected.");
        }
        return SUCCESS;
    }

    public int createObject(String string, String string2, String[] stringArray, String[][] stringArray2, String[] stringArray3) {
        if (this.debug) {
            o.println("Client.createObject");
        }
        try {
            ObjectName objectName = new ObjectName(string2);
            ObjectInstance objectInstance = this.connectorClient.createMBean(string, objectName);
            AttributeList attributeList = this.makeAttributeList(stringArray, stringArray3, stringArray2);
            this.connectorClient.setAttributes(objectInstance.getObjectName(), attributeList);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            o.println(ResourceBundleHolder.getString("InstanceAlreadyExistException"));
            return DUPLICATE_OI;
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            return LOST_CONNECTION;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Exception In Client.CreateObject"));
            throwable.printStackTrace();
            return PROCESS_FAILURE;
        }
        return SUCCESS;
    }

    public int deleteObject(String string) {
        if (this.debug) {
            o.println("Client.deleteObject: " + string);
        }
        try {
            ObjectName objectName = new ObjectName(string);
            this.connectorClient.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            o.println(ResourceBundleHolder.getString("object not found"));
            return NO_SUCH_OI;
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            return LOST_CONNECTION;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Delete failed"));
            throwable.printStackTrace();
            return PROCESS_FAILURE;
        }
        return SUCCESS;
    }

    public void disconnectAgent() {
        if (this.debug) {
            o.println("Client.disconnectAgent");
        }
        if (!this.connected) {
            return;
        }
        try {
            this.connectorClient.disconnect();
            this.connected = false;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Exception disconnecting"));
            throwable.printStackTrace();
        }
    }

    public String[] getAllObjectNames(String string, int[] nArray) {
        if (this.debug) {
            o.println("Client.getAllObjectNames: " + string);
        }
        String[] stringArray = new String[]{};
        nArray[0] = SUCCESS;
        try {
            ObjectName objectName = new ObjectName(String.valueOf(string) + ":*");
            Set set = this.connectorClient.queryNames(objectName, null);
            if (set.size() <= 0) {
                return stringArray;
            }
            stringArray = new String[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string2 = ((ObjectName)iterator.next()).toString();
                stringArray[n++] = string2;
            }
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            nArray[0] = LOST_CONNECTION;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Exception: getAllObjectNames"));
            throwable.printStackTrace();
            nArray[0] = PROCESS_FAILURE;
        }
        return stringArray;
    }

    public String[] getAttribute(String string, String string2, String string3, int[] nArray) {
        String[] stringArray;
        block13: {
            if (this.debug) {
                o.println("Client.getAttribute: " + string + " " + string2 + " " + string3);
            }
            stringArray = new String[]{};
            nArray[0] = SUCCESS;
            try {
                ObjectName objectName = new ObjectName(string);
                Object object = this.connectorClient.getAttribute(objectName, string2);
                if (string3.indexOf("Array") > -1) {
                    Object[] objectArray = (Object[])object;
                    stringArray = new String[objectArray.length];
                    int n = 0;
                    while (n < objectArray.length) {
                        try {
                            stringArray[n] = new String(objectArray[n].toString());
                        }
                        catch (NullPointerException nullPointerException) {
                            stringArray[n] = Client.setDefaultValue(string3);
                        }
                        ++n;
                    }
                    break block13;
                }
                stringArray = new String[1];
                try {
                    stringArray[0] = new String(object.toString());
                }
                catch (NullPointerException nullPointerException) {
                    stringArray[0] = Client.setDefaultValue(string3);
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                o.println(ResourceBundleHolder.getString("object not found"));
                nArray[0] = NO_SUCH_OI;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                o.println(String.valueOf(ResourceBundleHolder.getString("Exception: getAttribute ")) + string2);
                nArray[0] = NO_SUCH_ATTR;
            }
            catch (NullPointerException nullPointerException) {
                o.println(String.valueOf(ResourceBundleHolder.getString("Null pointer exception ")) + string2);
                nArray[0] = INVALID_ATTR_VAL;
            }
            catch (CommunicationException communicationException) {
                o.println(ResourceBundleHolder.getString("Lost connection with agent"));
                this.disconnectAgent();
                nArray[0] = LOST_CONNECTION;
            }
            catch (Throwable throwable) {
                o.println(ResourceBundleHolder.getString("Exception: getAttribute "));
                throwable.printStackTrace();
                nArray[0] = PROCESS_FAILURE;
            }
        }
        return stringArray;
    }

    public String[] getObjectsByClass(String string, String string2, int[] nArray) {
        if (this.debug) {
            o.println("Client.getObjectByClass: object_class=" + string + " domain=" + string2);
        }
        String[] stringArray = new String[]{};
        nArray[0] = SUCCESS;
        try {
            ObjectName objectName = new ObjectName(String.valueOf(string2) + ":*");
            Set set = this.connectorClient.queryMBeans(objectName, null);
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectInstance objectInstance = (ObjectInstance)iterator.next();
                String string3 = objectInstance.getClassName();
                if (this.debug) {
                    o.println("Client.getObjectByClass: found MBean of class " + string3);
                }
                if (!string3.equals(string)) continue;
                linkedList.add(objectInstance.getObjectName().toString());
            }
            stringArray = new String[linkedList.size()];
            int n = 0;
            while (n < linkedList.size()) {
                stringArray[n] = (String)linkedList.get(n);
                if (this.debug) {
                    o.println("Client.getObjectByClass: adding " + stringArray[n]);
                }
                ++n;
            }
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            nArray[0] = LOST_CONNECTION;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("Exception: getObjectsByClas"));
            throwable.printStackTrace();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        Client client = new Client(true);
        o.println(ResourceBundleHolder.getString("Client Main Testing Connect"));
        int n = client.connectAgent(stringArray[0], 1099, "name=RmiConnectorServer");
        if (n == 0) {
            o.println(ResourceBundleHolder.getString("Connect ok"));
        } else {
            o.println(ResourceBundleHolder.getString("Connect failed"));
        }
        o.println(ResourceBundleHolder.getString("\nTesting get_objects_by_class\n"));
        int[] nArray = new int[1];
        String[] stringArray2 = client.getObjectsByClass("DefaultDomain", "SimpleStandard", nArray);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            o.println(" -->" + stringArray2[n2]);
            ++n2;
        }
        if (stringArray.length > 1) {
            o.println(ResourceBundleHolder.getString("\nTesting getAttribute\n"));
            String[] stringArray3 = client.getAttribute(stringArray[1], stringArray[2], stringArray[3], nArray);
            if (nArray[0] != 0) {
                o.println("Get Failed reason: " + nArray[0]);
            } else {
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    o.println(stringArray3[n3]);
                    ++n3;
                }
            }
        }
    }

    protected AttributeList makeAttributeList(String[] stringArray, String[] stringArray2, String[][] stringArray3) {
        AttributeList attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray3.length) {
            int n2;
            Serializable[] serializableArray;
            if (stringArray2[n].equals("JavaIntegerArray")) {
                serializableArray = new Integer[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Integer(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaShortArray")) {
                serializableArray = new Short[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Short(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaLongArray")) {
                serializableArray = new Long[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Long(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaByteArray")) {
                serializableArray = new Byte[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Byte(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaFloatArray")) {
                serializableArray = new Float[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Float(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaDoubleArray")) {
                serializableArray = new Double[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Double(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaBooleanArray")) {
                serializableArray = new Boolean[stringArray3[n].length];
                n2 = 0;
                while (n2 < stringArray3[n].length) {
                    serializableArray[n2] = new Boolean(stringArray3[n][n2]);
                    ++n2;
                }
                attributeList.add(new Attribute(stringArray[n], serializableArray));
            } else if (stringArray2[n].equals("JavaInteger")) {
                attributeList.add(new Attribute(stringArray[n], new Integer(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaShort")) {
                attributeList.add(new Attribute(stringArray[n], new Short(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaLong")) {
                attributeList.add(new Attribute(stringArray[n], new Long(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaByte")) {
                attributeList.add(new Attribute(stringArray[n], new Byte(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaFloat")) {
                attributeList.add(new Attribute(stringArray[n], new Float(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaBoolean")) {
                attributeList.add(new Attribute(stringArray[n], new Boolean(stringArray3[n][0])));
            } else if (stringArray2[n].equals("JavaDouble")) {
                attributeList.add(new Attribute(stringArray[n], new Double(stringArray3[n][0])));
            } else if (stringArray2[n].indexOf("Array") > -1) {
                attributeList.add(new Attribute(stringArray[n], stringArray3[n]));
            } else {
                attributeList.add(new Attribute(stringArray[n], stringArray3[n][0]));
            }
            ++n;
        }
        return attributeList;
    }

    public Object[] performAction(String string, String string2, Object[] objectArray, String string3, String string4, int[] nArray) {
        if (this.debug) {
            o.println("performAction: " + string);
            o.println(" name-> " + string2);
            o.println(" in type-> " + string3);
            o.println(" reply type-> " + string3);
            int n = 0;
            while (n < objectArray.length) {
                o.println(" info-> " + objectArray[n].toString());
                ++n;
            }
        }
        nArray[0] = SUCCESS;
        try {
            ObjectName objectName = new ObjectName(string);
            String[] stringArray = new String[1];
            Object[] objectArray2 = new Object[1];
            if (string3.indexOf("Array") > -1) {
                objectArray2[0] = objectArray;
            } else if (string3.equals("JavaVoid")) {
                objectArray2 = null;
            } else {
                objectArray2[0] = objectArray[0];
            }
            if (string3.equals("JavaString")) {
                stringArray[0] = "java.lang.String";
            } else if (string3.equals("JavaInteger")) {
                stringArray[0] = "java.lang.Integer";
            } else if (string3.equals("JavaFloat")) {
                stringArray[0] = "java.lang.Float";
            } else if (string3.equals("JavaBoolean")) {
                stringArray[0] = "java.lang.Boolean";
            } else if (string3.equals("JavaDouble")) {
                stringArray[0] = "java.lang.Double";
            } else if (string3.equals("JavaVoid")) {
                stringArray = null;
            } else if (string3.equals("JavaStringArray")) {
                stringArray[0] = "[Ljava.lang.String;";
            } else if (string3.equals("JavaIntegerArray")) {
                stringArray[0] = "[Ljava.lang.Integer;";
            } else if (string3.equals("JavaFloatArray")) {
                stringArray[0] = "[Ljava.lang.Float;";
            } else if (string3.equals("JavaBooleanArray")) {
                stringArray[0] = "[Ljava.lang.Boolean;";
            } else if (string3.equals("JavaDoubleArray")) {
                stringArray[0] = "[Ljava.lang.Double;";
            }
            Object object = this.connectorClient.invoke(objectName, string2, objectArray2, stringArray);
            if (string4.indexOf("Array") > -1) {
                if (this.debug) {
                    o.println("\treply-> " + object.toString());
                }
                return (Object[])object;
            }
            if (string4.equals("JavaVoid")) {
                Object[] objectArray3 = new Object[]{"NULL"};
                if (this.debug) {
                    o.println("\treply-> " + objectArray3[0]);
                }
                return objectArray3;
            }
            Object[] objectArray4 = new Object[]{object};
            if (this.debug) {
                o.println("\treply-> " + objectArray4[0].toString());
            }
            return objectArray4;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            o.println(ResourceBundleHolder.getString("object not found"));
            nArray[0] = NO_SUCH_OI;
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            nArray[0] = LOST_CONNECTION;
        }
        catch (Exception exception) {
            o.println(ResourceBundleHolder.getString("EXception: performAction"));
            exception.printStackTrace();
            nArray[0] = PROCESS_FAILURE;
        }
        Object[] objectArray5 = new Object[]{new String("")};
        return objectArray5;
    }

    public int setAttribute(String string, String[] stringArray, String[][] stringArray2, String[] stringArray3) {
        if (this.debug) {
            o.println("Client.setAttribute");
        }
        try {
            ObjectName objectName = new ObjectName(string);
            AttributeList attributeList = this.makeAttributeList(stringArray, stringArray3, stringArray2);
            this.connectorClient.setAttributes(objectName, attributeList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            o.println(ResourceBundleHolder.getString("object not found"));
            return NO_SUCH_OI;
        }
        catch (CommunicationException communicationException) {
            o.println(ResourceBundleHolder.getString("Lost connection with agent"));
            this.disconnectAgent();
            return LOST_CONNECTION;
        }
        catch (Throwable throwable) {
            o.println(ResourceBundleHolder.getString("EXception: setAttribute"));
            throwable.printStackTrace();
            return PROCESS_FAILURE;
        }
        return SUCCESS;
    }

    static String setDefaultValue(String string) {
        if (string.indexOf("Integer") > -1) {
            return new String("0");
        }
        if (string.indexOf("Short") > -1) {
            return new String("0");
        }
        if (string.indexOf("Long") > -1) {
            return new String("0");
        }
        if (string.indexOf("Byte") > -1) {
            return new String("0");
        }
        if (string.indexOf("Float") > -1) {
            return new String("0.0");
        }
        if (string.indexOf("Double") > -1) {
            return new String("0.0");
        }
        if (string.indexOf("Boolean") > -1) {
            return new String("false");
        }
        if (string.indexOf("String") > -1) {
            return new String("");
        }
        if (string.indexOf("Serialized") > -1) {
            return new String("");
        }
        if (string.indexOf("External") > -1) {
            return new String("");
        }
        return new String("");
    }
}

