/*
 * Decompiled with CFR 0.152.
 */
package com.sun.em.jdmk.compiler;

import com.sun.em.jdmk.compiler.Error;
import com.sun.em.jdmk.compiler.GdmoWriter;
import com.sun.em.jdmk.compiler.Java2Gdmo;
import com.sun.em.jdmk.compiler.Registration;
import com.sun.em.jdmk.compiler.Type;
import java.io.IOException;
import java.io.Writer;

public class Attribute
extends GdmoWriter {
    private String name;
    private String module;
    private Type type;
    private boolean canRead = false;
    private boolean canWrite = false;

    public Attribute(String string) {
        this(string, null);
    }

    public Attribute(String string, Type type) {
        this.name = Java2Gdmo.firstToLower(string);
        this.type = type;
    }

    public String getDeclLine() {
        String string = "";
        if (this.module != null) {
            string = String.valueOf(this.name) + "\"" + this.module + "\":";
        }
        string = String.valueOf(string) + this.name + "\t\t";
        string = this.isReadWritable() ? String.valueOf(string) + "GET-REPLACE" : String.valueOf(string) + "GET";
        return string;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isReadWritable() {
        return this.canRead && this.canWrite;
    }

    public boolean isReadable() {
        return this.canRead;
    }

    public void setIsReadable(boolean bl) {
        this.canRead = bl;
    }

    public void setIsWriteable(boolean bl) {
        this.canWrite = bl;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void validate() {
        if (!this.canRead && this.canWrite) {
            Error.report("setter without matching getter, ignoring method " + this.getSourceName());
        } else {
            this.markAsValid();
        }
    }

    public void writeGdmo(Writer writer, Registration registration) throws IOException {
        if (!this.isValid()) {
            return;
        }
        writer.write(String.valueOf(this.name) + " ATTRIBUTE\n");
        writer.write("    WITH ATTRIBUTE SYNTAX " + this.type.getAsn1ModuleName() + "." + this.type.getAsn1TypeName() + ";\n");
        writer.write("REGISTERED AS " + registration.getAttributeReg(this.name) + ";\n\n");
    }
}

