
/***************************************************************************
 *
 *                         INFORMIX SOFTWARE, INC.
 *
 *                            PROPRIETARY DATA
 *
 *      THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF
 *      INFORMIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *      CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR
 *      DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT
 *      SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
 *
 *      THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *      SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE.
 *      UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW. 
 *
 *
 *  Title:      memdur.h
 *  Description:
 * 		Memory duration defenitions used by mi_* memory routines
 *		(defined in milib.h) and server internal sapi memory 
 *		routines.             
 *
 ***************************************************************************
 */

#ifndef _MEMDUR_H_
#define _MEMDUR_H_

/*
 * Memory Durations
 *   These values are used to indicate which memory pool an allocation
 *   should come from. For historical reasons they were assigned as unique
 *   bits, and there is not yet any reason to change this.
 */

typedef enum
{
    PER_NONE	    = 0,	/* none - unused */
    PER_ROUTINE     = 1,    	/* for routine life */
    PER_COMMAND     = 2,     	/* for duration of individual SQL command,
                        	   statements contain commands */
    PER_STATEMENT   = 4,        /* reserved */
    PER_TRANSACTION = 8,	/* reserved */
    PER_EXCEPTION   = 16,	/* reserved */
    PER_SESSION     = 32,	/* reserved */
    PER_SYSTEM      = 64,	/* reserved */
    PER_CURSOR      = 512,	/* reserved */
    PER_CONNECTION  = 1024	/* reserved */
} MI_MEMORY_DURATION;

/* Alias for PER_FUNCTION */
#define PER_FUNCTION 	PER_ROUTINE



#endif /* _MEMDUR_H_ */


