/*
 * pldriver.h
 */

#ifndef _PLDRIVER
#define _PLDRIVER

#include <sys/param.h>
#include <sys/stat.h>

typedef struct drivertable drivertable;
struct drivertable {
    int          driver;        /* Driver id		  */
    int          method;        /* Id of method		  */
    int        (*func)();       /* The subroutine to call    */
    drivertable *inherit;       /* Inherited function chain  */
    drivertable *current;       /* Current pointer in chain  */
};

/*------------------------------------------------------------------------*/
/*  Device array specifies particulars of devices			  */
/*------------------------------------------------------------------------*/

typedef struct devicearray devicearray;
struct devicearray {
    char   *nodename;		/*  node for device, null if local*/
    char   *arrayname;		/*  name of device array accessed */
    char   *filename;		/*  name of file to access	  */
    char   *command;		/*  Command to execute when pipe  */
    int	    itemnumber;		/*  The device item in the array  */
    int     filetype;		/*  file type			  */
    int     blocksize;		/*  block size for i/o		  */
    int     mode;		/*  Access mode on device	  */
    long    maxsize;		/*  Max size for writing to device*/
    int     remote;	        /*  1 = remote, 0 = local         */
    dev_t   dev_id;	        /*  st_dev from stat(), id of file system */
};

/*------------------------------------------------------------------------*/
/*  Custom function table definition                                      */
/*------------------------------------------------------------------------*/

struct functable
{
    char       *fname;          /* custom conversion function name */
    int         (*func) ();     /* custom conversion function pointer */
};

/*------------------------------------------------------------------------*/
/*  Define the driver methods						  */
/*------------------------------------------------------------------------*/

#define PL_MTH_CONFIGURE    9	/* Configure driver		     */
#define PL_MTH_OPEN        33   /* Open file     		     */
#define PL_MTH_CLOSE        8   /* Close the open file               */
#define PL_MTH_RAWREAD     36   /* Raw level file read request       */
#define PL_MTH_RAWWRITE    37   /* Raw level file write request      */

/*------------------------------------------------------------------------*/
/*  Define the driver method return codes 				  */
/*------------------------------------------------------------------------*/

#define PL_RTN_FAIL 	   -1		/* Operation failed		  */
#define PL_RTN_OK 	    0		/* Operation was successful       */
#define PL_RTN_EOF    	    2		/* At end of file		  */

#endif 
