
/**********************************************************************
*  Date:   	%D%						      *
*  Version:	%I%						      *
**********************************************************************/

/**********************************************************************
*  Copyright 1991, 1992, 1993 by Aepix  Software, Inc.                *
*  							   	      *
*  All rights reserved.  May not be reproduced or distributed, in     *
*  printed or electronic form, without permission of Aepix Software,  *
*  Inc.  May not be distributed as object code, separately or linked  *
*  with other object modules, except as licensed to recipient.	      *
*  							   	      *
***********************************************************************/

/**********************************************************************
*                      PROPRIETARY DATA                      	      *
*  							   	      *
*  THIS DOCUMENT CONTAINS TADE SECRET DATA WHICH IS THE PROPERTY OF   *
*  OF AEPIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED IN CONFIDENCE  *
*  TO RECIPIENT.  INFORMATION CONTAINED HEREIN MAY NOT BE USED,       *
*  COPIED, OR DISCLOSED IN WHOLE OR IN PART EXCEPT AS INDICATED BY    *
*  WRITTEN AGREEMENT OF AN OFFICER OF AEPIX SOFTWARE, INC.            *
********************************************************************* */

/******************************************************************************

     ROUTINE:   	pl_get_user_method

     PURPOSE:  		Configure the methods table for a user supplied
			file access driver

     PARAMETERS:        driver - Text name of user supplied driver
			method - method id from pldriver.h file


     ALGORITHM:		If the driver is "Fixed", "XBASE", or "Delimited"
			this routine is not called, the methods are loaded
			from the base program.

			The function will be repeatedly called to load
			a methods table for all other driver names.  An
			appropriate function should be returned.  The
			invalid_method routine should be returned
			for any method for which functionality will not
			be supplied.

			After the methods table is loaded, the
			PL_MTH_CONFIGURE method function is invoked.  A pointer
			to the configured methods table is passed.

			To inherit the methods table for the Fixed, XBASE,
			or Delimited drivers, the PL_MTH_CONFIGURE method
			may call pl_inherit_fixed, pl_inherit_delim or
			pl_inherit_xbase, passing the methods table.

			After invoking any of these routines, the method
			table "inherit" function will be set to the function
			supplied by the appropriate driver.  In the user
			supplied method, the function

			  pl_driver_inherit(method)

			may be called to get the function pointer for the
			inherited driver


******************************************************************************/

#include "plcstdrv.h"

static int  invalid_method();
int         generate_configure();
int         genwrite_configure();

(*pl_get_user_method(driver, method)) ()
    char       *driver;
    int         method;
{
    /*
     *  TEST CODE
     */

    if (strcmp(driver, "GENERATE") == 0)
        {
        if (method == PL_MTH_CONFIGURE)
            return (generate_configure);
        }

    if (strcmp(driver, "GENWRITE") == 0)
        {
        if (method == PL_MTH_CONFIGURE)
            return (genwrite_configure);
        }
    return (0);
}
