/*
 * Decompiled with CFR 0.152.
 */
package com.sun.em.jdmk.event;

import com.sun.em.jdmk.event.EMEventListener;
import com.sun.em.jdmk.event.EMListener;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class AgentStruct
implements NotificationListener {
    private final int CONNECT = 0;
    private String agentHost;
    private Integer port;
    private RemoteMBeanServer client = null;
    private Hashtable listenerHash = null;
    private static final String sccsID = "@(#)AgentStruct.java\t1.9 03/03/11 Sun Microsystems";

    public AgentStruct(String string, String string2) {
        this.agentHost = string;
        this.port = new Integer(string2);
    }

    public void createListener(String string, String string2) {
        try {
            ObjectName objectName = new ObjectName(string);
            EMListener eMListener = new EMListener(this.agentHost, string2);
            this.client.addNotificationListener(objectName, (NotificationListener)eMListener, null, null);
            this.listenerHash.put(string, eMListener);
        }
        catch (Exception exception) {
            System.out.println("event_debug:    " + exception);
        }
    }

    public void deleteListener(String string) {
        try {
            EMEventListener eMEventListener = (EMEventListener)this.listenerHash.remove(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void disconnect() throws Exception {
        this.client.disconnect();
    }

    public void establishConnection() throws Exception {
        if (this.client != null && this.client.isConnected()) {
            return;
        }
        RmiConnectorAddress rmiConnectorAddress = new RmiConnectorAddress(this.agentHost, this.port.intValue(), "name=RmiConnectorServer");
        this.client = new RmiConnectorClient();
        this.client.connect((ConnectorAddress)rmiConnectorAddress);
        this.listenerHash = new Hashtable();
        this.eventRegister();
    }

    private void eventRegister() throws Exception {
        ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        this.client.addNotificationListener(objectName, (NotificationListener)this, null, null);
        Set set = this.client.queryMBeans(new ObjectName("*:*"), null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            if (objectInstance.getObjectName().toString().equals("JMImplementation:type=MBeanServerDelegate")) continue;
            this.createListener(objectInstance.getObjectName().toString(), objectInstance.getClassName());
        }
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public RemoteMBeanServer getClient() {
        return this.client;
    }

    public String getPort() {
        return this.port.toString();
    }

    public void handleNotification(Notification notification, Object object) {
        Object object2;
        Object object3 = object2 = new Object();
        synchronized (object3) {
            if (notification instanceof MBeanServerNotification) {
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                String string = objectName.toString();
                String string2 = null;
                EMListener eMListener = null;
                try {
                    if (notification.getType().equals("JMX.mbean.registered")) {
                        string2 = this.client.getObjectInstance(objectName).getClassName();
                    } else {
                        eMListener = (EMListener)this.listenerHash.get(string);
                        string2 = eMListener.getObjectClass();
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    int n = string.indexOf("type=");
                    if (n >= 0) {
                        string2 = string.substring(n + 5);
                        if (string2.indexOf(",") >= 0) {
                            string2 = string2.substring(0, string2.indexOf(","));
                        }
                    }
                    string2 = new String("");
                }
                String string3 = null;
                String[] stringArray = new String[1];
                String[] stringArray2 = new String[1];
                stringArray[0] = string2;
                stringArray2[0] = string;
                if (notification.getType().equals("JMX.mbean.unregistered")) {
                    this.deleteListener(string);
                    string3 = new String("DELETE");
                } else if (notification.getType().equals("JMX.mbean.registered")) {
                    this.createListener(string, string2);
                    string3 = new String("CREATE");
                } else {
                    string3 = notification.getType();
                }
                this.sendPmiEvent(string3, this.agentHost, stringArray, stringArray2);
            } else {
                System.out.println("Event not an instance of MBeanServerNotification\n");
            }
        }
    }

    public native int sendPmiEvent(String var1, String var2, String[] var3, String[] var4);
}

