/*
 * Decompiled with CFR 0.152.
 */
package com.sun.em.jdmk.compiler;

import com.sun.em.jdmk.compiler.Error;
import com.sun.em.jdmk.compiler.GdmoWriter;
import com.sun.em.jdmk.compiler.Java2Gdmo;
import com.sun.em.jdmk.compiler.JdmkSimpleType;
import com.sun.em.jdmk.compiler.Registration;
import com.sun.em.jdmk.compiler.Type;
import java.io.IOException;
import java.io.Writer;

public class Action
extends GdmoWriter {
    private static final Type serialType = new JdmkSimpleType("Serializable", "JavaSerialized");
    private String name;
    private String invalidReason;
    private Type returnType;
    private Type paramType;

    public Action(String string) {
        this.name = Java2Gdmo.firstToLower(string);
    }

    public String getDeclLine() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Type getParamType() {
        return this.paramType;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public static Type getSerialType() {
        return serialType;
    }

    public static boolean isValidParamClassType(Class clazz) {
        try {
            return Class.forName("java.io.Serializable").isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            Error.reportInternal(exception);
            return false;
        }
    }

    public void setParamType(Type type) {
        this.paramType = type;
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public void validate() {
        this.markAsValid();
    }

    public void writeGdmo(Writer writer, Registration registration) throws IOException {
        if (!this.isValid()) {
            return;
        }
        writer.write(String.valueOf(this.name) + " ACTION\n");
        writer.write("    BEHAVIOUR " + this.name + "Behaviour BEHAVIOUR DEFINED AS\n" + "        !action derived from " + this.getSourceName() + " Java method!;;\n");
        writer.write("    WITH INFORMATION SYNTAX " + this.paramType.getAsn1ModuleName() + "." + this.paramType.getAsn1TypeName() + ";\n");
        writer.write("    WITH REPLY SYNTAX " + this.returnType.getAsn1ModuleName() + "." + this.returnType.getAsn1TypeName() + ";\n");
        writer.write("REGISTERED AS " + registration.getActionReg(this.name) + ";\n\n");
    }
}

