// 	Copyright 11/07/01 Sun Microsystems, Inc. All Rights Reserved.

#pragma ident  "@(#)auth_server_body.cc	1.18 01/11/07 Sun Microsystems"

#include <sys/types.h>
#include <iostream.h>
#include "auth_server_body.hh"

#ifdef ORBACUS
	#include <Any.h>
	#include <cos/CosLifeCycle.h>
#else 
#ifdef ORBIX
	#include <omg/orb.hh>	
	#include <cos/CosLifeCycle.hh>
#else
	#include <any.h>
	#include <cos/CosLifeCycle_c.hh>
#endif
#endif

#include "em_c++utils/em_basic_types.hh"

RWCString AuthenticationServerBody::USER_NAME_("user name");

AuthenticationServerBody::AuthenticationServerBody(
) throw()
    
{
}

AuthenticationServerBody::~AuthenticationServerBody(
) throw() {
}

// decrypt_user_profile method extracts user name and unix password from the
// Criteria supplied by the client program and return validated user name and
// unix clear password 
// [Change Note - Returns Crypted password only]

CORBA::Boolean
AuthenticationServerBody::decrypt_user_profile(
    const CORBA::Any& user_profile_blob,
    RWCString& user_name,
    RWCString& password,
    bool &crypted

) throw() {
   
    crypted=true;
#if defined(ORBACUS) || defined(ORBIX)
    const CosLifeCycle::Criteria *tmp_user_profile;
    if (!(user_profile_blob >>= tmp_user_profile)) {
	// "Unknown user profile data\n"
	return false;
    }
    CosLifeCycle::Criteria user_profile=*tmp_user_profile;
#else
    CosLifeCycle::Criteria user_profile(2);
    if (!(user_profile_blob >>= user_profile)) {
	// "Unknown user profile data\n"
	return false;
    }
#endif
    CORBA::ULong len = user_profile.length();
    if(len != 2) {
	// "Unacceptable user profile length\n"
	return false;
    }	

    for(CORBA::ULong i = 0; i < len; ++i)
    {
	if(!strcmp(user_profile[i].name, USER_NAME_.data())) 
	{
#ifdef ORBACUS
	    const char* user_name_;
#else
	    char* user_name_;
#endif
	    if (user_profile[i].value >>= user_name_) {
		user_name = user_name_;
	    }
	    else {
		// "Unable to extract user name\n"
		return false;
	    }
#ifndef ORBACUS
#ifndef ORBIX
		delete []user_name_;	
#endif
#endif
	}
	if(!strcmp(user_profile[i].name, "UNIX_CLEAR"))
	{
#ifdef ORBACUS
	    const char* password_;
#else
	    char* password_;
#endif
		crypted=false;
	    if (user_profile[i].value >>= password_) {
		password = password_;
	    }
	    else {
		// "Unable to extract user [clear text] password\n"
		return false;
	    }
#ifndef ORBACUS
#ifndef ORBIX
		delete []password_;	
#endif
#endif
	}
	if(!strcmp(user_profile[i].name, "UNIX_CRYPT"))
	{
#if defined(ORBACUS) || defined(ORBIX)
	    const CORBA::OctetSeq *pwd_seq;
#else
	    CORBA::OctetSeq pwd_seq;
#endif
	    if (!(user_profile[i].value >>= pwd_seq)) {
		// "Unable to extract user [UNIX_CRYPT encrypted] password\n"
		return false;
	    }

#if defined(ORBACUS) || defined(ORBIX)
	    int password_length = pwd_seq->length();
#else
	    int password_length = pwd_seq.length();
#endif
	    // Assumes that password control is OFF in SEM
	    if(0 == password_length) {
		continue;
	    }

	    char* password_ = new char[password_length+1];
	    for(int j = 0; j < password_length; ++j) {
#if defined(ORBACUS) || defined(ORBIX)
		password_[j] = (CORBA::Char)(*pwd_seq)[j];
#else
		password_[j] = (CORBA::Char)pwd_seq[j];
#endif
	    }
	    password_[j] = '\0';
	    password = password_;
	}
    }
    return true;
}

