//      Copyright 10/15/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)event_port_impl.cc	1.10 01/10/15 Sun Microsystems"

#include "event_port_impl.hh"
#include "event_port_registry_impl.hh"
#include <cgw_utils/cgw_global.hh>
#include <cgw_utils/cgw_utils.hh>


#include "epr_debug.hh"

EventPortImpl::EventPortImpl(
    const RWCString& ae_title,
    const JIDM::Criteria& creation_criteria,
    CosEventChannelAdmin::SupplierAdmin_ptr supplier_admin,
    EventPortRegistryImpl& epr,
    const char* 
) throw()
    : POA_JIDM::EventPort(),
      supplier_admin_(
	  CosEventChannelAdmin::SupplierAdmin::_duplicate(supplier_admin)),
      associated_criteria_(new JIDM::Criteria(creation_criteria)),
      ae_title_(ae_title),
      epr_(epr)
{
}

EventPortImpl::~EventPortImpl() throw() {
}

void
EventPortImpl::destroy() throw(CORBA::SystemException) {

  try {
    const PortableServer::ObjectId_var oid = CGWGlobal::cgwPOA_->servant_to_id(this);
    CGWGlobal::cgwPOA_->deactivate_object(oid);
    epr_.delete_event_port(ae_title_);
  }
  catch (CORBA::Exception& e) {
    CGWUtils::print_corba_exception(
            epr_error,
            "EventPortImpl::destroy caught exception \n",
            e);
  }

}

CosEventChannelAdmin::SupplierAdmin_ptr
EventPortImpl::supplier_admin() throw (CORBA::SystemException)
{
    return CosEventChannelAdmin::SupplierAdmin::_duplicate(supplier_admin_);
}

JIDM::Criteria*
EventPortImpl::associated_criteria() throw(CORBA::SystemException) {
    return new JIDM::Criteria(associated_criteria_);
}

