#! /usr/bin/sh
#
# ident "@(#)sms_env.sh 1.36     01/10/12 SMI"
#
# Copyright (c) 1999-2001 by Sun Microsystems, Inc.
# All rights reserved.

# Basic SMS environment configuration defaults.
SMS_VERSION=SMS1.1
SMSOPT=/opt/SUNWSMS/${SMS_VERSION}
PATH=${SMSOPT}/bin:/usr/sbin:/usr/bin:/usr/ucb:.
LD_LIBRARY_PATH=
LD_RUN_PATH=/usr/lib

# Use this environment variable to specify the
# command line arguments passed to the ssd at
# start-up time.
SSD_OPTIONS=

export PATH
export LD_LIBRARY_PATH
export LD_RUN_PATH
export SSD_OPTIONS

#NO_FRAD=TRUE
#export NO_FRAD

NO_COD_LOGGING=TRUE
export NO_COD_LOGGING

HWAD_NO_JTAG_CHKPT=
export HWAD_NO_JTAG_CHKPT

# If your HW is older than 1.3 you need to uncomment this!
#TAKE_CONSOLEBUS_OUT_OF_RESET=TRUE
#export TAKE_CONSOLEBUS_OUT_OF_RESET

# If your HW is older than 1.3 you need to uncomment this!
#TAKE_DCPU_OUT_OF_RESET=TRUE
#export TAKE_DCPU_OUT_OF_RESET

SCHIZO_TEMP=TRUE
export SCHIZO_TEMP

MAXCAT_AR_KLUDGE=TRUE
export MAXCAT_AR_KLUDGE

# Uncomment the following to disable jtag reset on startup
#HWAD_NO_JTAG_RESET=
#export HWAD_NO_JTAG_RESET

# Uncomment out the following variable if running on a system that has
# SEEPROMs programmed but they do not contain valid CRC.
#FRAD_NO_CRC=TRUE
#export FRAD_NO_CRC

################################
# ESMD workaround env. variables
################################

# Disable power supply good bit and current/voltage companion 10% actions.
# Detection and messages will still occur, but no action will be taken w/
# this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_PWR_FAILURE_ACTION=
#export ESMD_DISABLE_PWR_FAILURE_ACTION

# Disable SC over/under temperature actions. Detection and messages will
# still occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_SC_TEMP_ACTION=
#export ESMD_DISABLE_SC_TEMP_ACTION

# Disable SC over/under voltage actions. Detection and messages will
# still occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_SC_VOL_ACTION=
#export ESMD_DISABLE_SC_VOL_ACTION

# Disable SCPER over/under temperature (or ambient temp.) actions.
# Detection and messages will still occur, but no action will be
# taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_SCPER_TEMP_ACTION=
#export ESMD_DISABLE_SCPER_TEMP_ACTION

# Disable SCPER over/under voltage actions. Detection and messages will
# still occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_SCPER_VOL_ACTION=
#export ESMD_DISABLE_SCPER_VOL_ACTION

# Disable the BPS unit_fail action. Detection and messages will still
# occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_BPS_UNIT_FAIL_ACTION=
#export ESMD_DISABLE_BPS_UNIT_FAIL_ACTION

# Disable the BPS fan_fail action. Detection and messages will still
# occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_BPS_FAN_FAIL_ACTION=
#export ESMD_DISABLE_BPS_FAN_FAIL_ACTION

# Disable the BPS over/under hk voltage actions. Detection and messages
# will still occur, but no action will be taken w/ this var. set.
# If your HW is older than 1.3 you need to uncomment this!
#ESMD_DISABLE_BPS_HK_ACTION=
#export ESMD_DISABLE_BPS_HK_ACTION

# Disable the 1.5v cnvtr warnings and actions.
ESMD_DISABLE_1P5V_CNVTR=
export ESMD_DISABLE_1P5V_CNVTR

# Disable the 12.0v warnings and actions on SCPER boards.
# If your HW _is_ 1.3 and you don't have the rework to fix the +12v
# problem on the SCPER uncomment this.
#ESMD_DISABLE_SCPER_12VDC=
#export ESMD_DISABLE_SCPER_12VDC

# Disable the 1.5v warnings and actions on SC boards.
ESMD_DISABLE_SC_1P5VDC=
export ESMD_DISABLE_SC_1P5VDC

# Enable the EXB and CSB CAP rework SW workaround.
# If your machine does _not_ have the EXB and CSB CAP rework, then
# uncomment this!.
#ESMD_ENABLE_EXB_CSB_CAP_REWORK_SW_WORKAROUND=
#export ESMD_ENABLE_EXB_CSB_CAP_REWORK_SW_WORKAROUND

# hardware revision 1 has different poweron reset steps as against rev 0.x.
# default to new hardware so setenv if running on 0.x rev hardware
#HW_REV0=TRUE
#export HW_REV0

# Set this variable if running with mcpu rev1. This will be taken out with new
# rev 2 mcpu board in the machines
#DCPU_REV1=TRUE
#export DCPU_REV1

# Set this variable if running with HPCI's that have low 1.5v readings.
# If your HW is older than 1.3 you need to uncomment this!
#MARGIN_1P5V_HPCI=
#export MARGIN_1P5V_HPCI

# For rev 1.2 and up csb
CSB_REV2=
export CSB_REV2

# For rev 1.3 expander
EXB_REV3=
export EXB_REV3

# For rev 1.3 IO board
IOB_REV3=
export IOB_REV3

# Default value for max number of domains set to 18
HWAD_MAX_ACTIVE_DOMAIN=18
export HWAD_MAX_ACTIVE_DOMAIN

# Default lock policy checking to off for now
HWAD_DISABLE_POLICY_CHECK=
export HWAD_DISABLE_POLICY_CHECK

# Remove when PCI bridge chip hardware has been replaced
SMS_4490854=
export SMS_4490854
