/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import com.sun.jdmk.Trace;
import com.sun.jdmk.UnsignedLong;
import java.net.InetAddress;
import java.util.Vector;
import javax.management.snmp.BerDecoder;
import javax.management.snmp.BerEncoder;
import javax.management.snmp.BerException;
import javax.management.snmp.SnmpCounter;
import javax.management.snmp.SnmpCounter64;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpGauge;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpIpAddress;
import javax.management.snmp.SnmpNull;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOpaque;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class SnmpMessage
implements SnmpDefinitions {
    public int version;
    public byte[] community;
    public byte[] data;
    public int dataLength;
    public InetAddress address;
    public int port;
    String dbgTag = "SnmpMessage";

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    public void decodeMessage(byte[] byArray, int n) throws SnmpStatusException {
        try {
            BerDecoder berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            this.version = berDecoder.fetchInteger();
            this.community = berDecoder.fetchOctetString();
            this.data = berDecoder.fetchAny();
            this.dataLength = this.data.length;
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
    }

    public SnmpPduPacket decodePdu() throws SnmpStatusException {
        SnmpPduPacket snmpPduPacket = null;
        BerDecoder berDecoder = new BerDecoder(this.data);
        try {
            int n = berDecoder.getTag();
            berDecoder.openSequence(n);
            switch (n) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
                    snmpPduRequest.requestId = berDecoder.fetchInteger();
                    snmpPduRequest.errorStatus = berDecoder.fetchInteger();
                    snmpPduRequest.errorIndex = berDecoder.fetchInteger();
                    snmpPduPacket = snmpPduRequest;
                    break;
                }
                case 165: {
                    SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                    snmpPduBulk.requestId = berDecoder.fetchInteger();
                    snmpPduBulk.nonRepeaters = berDecoder.fetchInteger();
                    snmpPduBulk.maxRepetitions = berDecoder.fetchInteger();
                    snmpPduPacket = snmpPduBulk;
                    break;
                }
                case 164: {
                    SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
                    snmpPduTrap.enterprise = new SnmpOid(berDecoder.fetchOid());
                    snmpPduTrap.agentAddr = new SnmpIpAddress(berDecoder.fetchOctetString(64));
                    snmpPduTrap.genericTrap = berDecoder.fetchInteger();
                    snmpPduTrap.specificTrap = berDecoder.fetchInteger();
                    snmpPduTrap.timeStamp = berDecoder.fetchInteger(67);
                    snmpPduPacket = snmpPduTrap;
                    break;
                }
                default: {
                    throw new SnmpStatusException(9);
                }
            }
            snmpPduPacket.type = n;
            snmpPduPacket.varBindList = this.decodeVarBindList(berDecoder);
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            if (this.isDebugOn()) {
                this.debug("decodePdu", berException);
            }
            throw new SnmpStatusException(9);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.isDebugOn()) {
                this.debug("decodePdu", illegalArgumentException);
            }
            throw new SnmpStatusException(9);
        }
        snmpPduPacket.version = this.version;
        snmpPduPacket.community = this.community;
        snmpPduPacket.address = this.address;
        snmpPduPacket.port = this.port;
        return snmpPduPacket;
    }

    private SnmpVarBind[] decodeVarBindList(BerDecoder berDecoder) throws BerException {
        Object[] objectArray;
        berDecoder.openSequence();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (berDecoder.cannotCloseSequence()) {
            objectArray = new SnmpVarBind();
            berDecoder.openSequence();
            objectArray.oid = new SnmpOid(berDecoder.fetchOid());
            objectArray.setSnmpValue(this.decodeVarBindValue(berDecoder));
            berDecoder.closeSequence();
            vector.addElement(objectArray);
        }
        berDecoder.closeSequence();
        objectArray = new SnmpVarBind[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private SnmpValue decodeVarBindValue(BerDecoder berDecoder) throws BerException {
        SnmpValue snmpValue = null;
        int n = berDecoder.getTag();
        switch (n) {
            case 2: {
                try {
                    snmpValue = new SnmpInt(berDecoder.fetchInteger());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 4: {
                try {
                    snmpValue = new SnmpString(berDecoder.fetchOctetString());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 6: {
                try {
                    snmpValue = new SnmpOid(berDecoder.fetchOid());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 5: {
                berDecoder.fetchNull();
                try {
                    snmpValue = new SnmpNull();
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 64: {
                try {
                    snmpValue = new SnmpIpAddress(berDecoder.fetchOctetString(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 65: {
                try {
                    snmpValue = new SnmpCounter(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 66: {
                try {
                    snmpValue = new SnmpGauge(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 67: {
                try {
                    snmpValue = new SnmpTimeticks(berDecoder.fetchIntegerAsLong(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 68: {
                try {
                    snmpValue = new SnmpOpaque(berDecoder.fetchOctetString(n));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 70: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                try {
                    snmpValue = new SnmpCounter64(UnsignedLong.make(berDecoder.fetchIntegerAsLong(n)));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 128: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.noSuchObject;
                break;
            }
            case 129: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.noSuchInstance;
                break;
            }
            case 130: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n);
                snmpValue = SnmpVarBind.endOfMibView;
                break;
            }
            default: {
                throw new BerException();
            }
        }
        return snmpValue;
    }

    public static String dumpHexBuffer(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 << 1);
        int n3 = 1;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = byArray[n5] & 0xFF;
            stringBuffer.append(Character.forDigit(n6 >>> 4, 16));
            stringBuffer.append(Character.forDigit(n6 & 0xF, 16));
            if (++n3 % 16 == 0) {
                stringBuffer.append('\n');
                n3 = 1;
            } else {
                stringBuffer.append(' ');
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    public int encodeMessage(byte[] byArray) throws SnmpTooBigException {
        int n = 0;
        if (this.data == null) {
            throw new IllegalArgumentException("Data field is null");
        }
        try {
            BerEncoder berEncoder = new BerEncoder(byArray);
            berEncoder.openSequence();
            berEncoder.putAny(this.data, this.dataLength);
            berEncoder.putOctetString(this.community != null ? this.community : new byte[]{});
            berEncoder.putInteger(this.version);
            berEncoder.closeSequence();
            n = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
        return n;
    }

    public void encodePdu(SnmpPduPacket snmpPduPacket, int n) throws SnmpStatusException, SnmpTooBigException {
        this.version = snmpPduPacket.version;
        this.community = snmpPduPacket.community;
        this.address = snmpPduPacket.address;
        this.port = snmpPduPacket.port;
        this.data = new byte[n];
        try {
            BerEncoder berEncoder = new BerEncoder(this.data);
            berEncoder.openSequence();
            this.encodeVarBindList(berEncoder, snmpPduPacket.varBindList);
            switch (snmpPduPacket.type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                    berEncoder.putInteger(snmpPduRequest.errorIndex);
                    berEncoder.putInteger(snmpPduRequest.errorStatus);
                    berEncoder.putInteger(snmpPduRequest.requestId);
                    break;
                }
                case 165: {
                    SnmpPduBulk snmpPduBulk = (SnmpPduBulk)snmpPduPacket;
                    berEncoder.putInteger(snmpPduBulk.maxRepetitions);
                    berEncoder.putInteger(snmpPduBulk.nonRepeaters);
                    berEncoder.putInteger(snmpPduBulk.requestId);
                    break;
                }
                case 164: {
                    SnmpPduTrap snmpPduTrap = (SnmpPduTrap)snmpPduPacket;
                    berEncoder.putInteger(snmpPduTrap.timeStamp, 67);
                    berEncoder.putInteger(snmpPduTrap.specificTrap);
                    berEncoder.putInteger(snmpPduTrap.genericTrap);
                    berEncoder.putOctetString(snmpPduTrap.agentAddr.byteValue(), 64);
                    berEncoder.putOid(snmpPduTrap.enterprise.longValue());
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(snmpPduPacket.type));
                }
            }
            berEncoder.closeSequence(snmpPduPacket.type);
            this.dataLength = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
    }

    private void encodeVarBindList(BerEncoder berEncoder, SnmpVarBind[] snmpVarBindArray) throws SnmpStatusException, SnmpTooBigException {
        int n = 0;
        try {
            berEncoder.openSequence();
            if (snmpVarBindArray != null) {
                int n2 = snmpVarBindArray.length - 1;
                while (n2 >= 0) {
                    SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                    if (snmpVarBind != null) {
                        berEncoder.openSequence();
                        this.encodeVarBindValue(berEncoder, snmpVarBind.value);
                        berEncoder.putOid(snmpVarBind.oid.longValue());
                        berEncoder.closeSequence();
                        ++n;
                    }
                    --n2;
                }
            }
            berEncoder.closeSequence();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException(n);
        }
    }

    private void encodeVarBindValue(BerEncoder berEncoder, SnmpValue snmpValue) throws SnmpStatusException {
        if (snmpValue == null) {
            berEncoder.putNull();
        } else if (snmpValue instanceof SnmpIpAddress) {
            berEncoder.putOctetString(((SnmpIpAddress)snmpValue).byteValue(), 64);
        } else if (snmpValue instanceof SnmpCounter) {
            berEncoder.putInteger(((SnmpCounter)snmpValue).longValue(), 65);
        } else if (snmpValue instanceof SnmpGauge) {
            berEncoder.putInteger(((SnmpGauge)snmpValue).longValue(), 66);
        } else if (snmpValue instanceof SnmpTimeticks) {
            berEncoder.putInteger(((SnmpTimeticks)snmpValue).longValue(), 67);
        } else if (snmpValue instanceof SnmpOpaque) {
            berEncoder.putOctetString(((SnmpOpaque)snmpValue).byteValue(), 68);
        } else if (snmpValue instanceof SnmpInt) {
            berEncoder.putInteger(((SnmpInt)snmpValue).intValue());
        } else if (snmpValue instanceof SnmpString) {
            berEncoder.putOctetString(((SnmpString)snmpValue).byteValue());
        } else if (snmpValue instanceof SnmpOid) {
            berEncoder.putOid(((SnmpOid)snmpValue).longValue());
        } else if (snmpValue instanceof SnmpCounter64) {
            if (this.version == 0) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            berEncoder.putUnsignedLong(((SnmpCounter64)snmpValue).longValue(), 70);
        } else if (snmpValue instanceof SnmpNull) {
            int n = ((SnmpNull)snmpValue).getTag();
            if (this.version == 0 && n != 5) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            if (this.version == 1 && n != 5 && n != 128 && n != 129 && n != 130) {
                throw new SnmpStatusException("Invalid value " + snmpValue);
            }
            berEncoder.putNull(n);
        } else {
            throw new SnmpStatusException("Invalid value " + snmpValue);
        }
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: ");
        stringBuffer.append(this.version);
        stringBuffer.append("\n");
        if (this.community == null) {
            stringBuffer.append("Community: null");
        } else {
            stringBuffer.append("Community: {\n");
            stringBuffer.append(SnmpMessage.dumpHexBuffer(this.community, 0, this.community.length));
            stringBuffer.append("\n}\n");
        }
        if (this.data == null) {
            stringBuffer.append("Data: null");
        } else {
            stringBuffer.append("Data: {\n");
            stringBuffer.append(SnmpMessage.dumpHexBuffer(this.data, 0, this.dataLength));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.toString();
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

