/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.SendQ;
import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpSendServer;
import com.sun.jdmk.comm.SnmpTimerServer;
import com.sun.jdmk.comm.WaitQ;
import java.io.Serializable;
import java.util.Vector;

final class SnmpQManager
implements Serializable {
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;
    static String dbgTag = "SnmpQManager";

    SnmpQManager() {
        this.startQThreads();
    }

    public void addRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.addRequest(snmpInformRequest);
    }

    public void addWaiting(SnmpInformRequest snmpInformRequest) {
        this.waitq.addWaiting(snmpInformRequest);
    }

    static void debug(String string, String string2) {
        SnmpQManager.debug(dbgTag, string, string2);
    }

    static void debug(String string, String string2, String string3) {
        Trace.send(2, 1024, string, string2, string3);
    }

    static void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 1024, string, string2, throwable);
    }

    static void debug(String string, Throwable throwable) {
        SnmpQManager.debug(dbgTag, string, throwable);
    }

    public Vector getAllOutstandingRequest(long l) {
        return this.newq.getAllOutstandingRequest(l);
    }

    public SnmpInformRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    static boolean isDebugOn() {
        return Trace.isSelected(2, 1024);
    }

    static boolean isTraceOn() {
        return Trace.isSelected(1, 1024);
    }

    public SnmpInformRequest removeRequest(long l) {
        SnmpInformRequest snmpInformRequest = null;
        snmpInformRequest = this.newq.removeRequest(l);
        if (snmpInformRequest == null) {
            snmpInformRequest = this.waitq.removeRequest(l);
        }
        return snmpInformRequest;
    }

    public void removeRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.removeElement(snmpInformRequest);
        this.waitq.removeElement(snmpInformRequest);
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public void stopQThreads() {
        ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
        this.waitq.isBeingDestroyed = true;
        ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
        this.newq.isBeingDestroyed = true;
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
    }

    static void trace(String string, String string2) {
        SnmpQManager.trace(dbgTag, string, string2);
    }

    static void trace(String string, String string2, String string3) {
        Trace.send(1, 1024, string, string2, string3);
    }
}

