/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.HtmlRequestHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;

public class HtmlAdaptorServer
extends CommunicatorServer
implements MBeanRegistration,
DynamicMBean {
    private String dclassName = this.getClass().getName();
    private String ddescription = "HtmlAdaptorServer class: Provides a management interface of an agent to Web browser clients.";
    private MBeanAttributeInfo[] dattributes = new MBeanAttributeInfo[12];
    private MBeanConstructorInfo[] dconstructors = new MBeanConstructorInfo[3];
    private MBeanOperationInfo[] doperations = new MBeanOperationInfo[5];
    private MBeanInfo dmbeaninfo = null;
    private InetAddress addrLastClient = null;
    private Vector authInfo = new Vector();
    private ObjectName userParser = null;
    private transient ServerSocket sockListen = null;
    private transient Socket sock = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public HtmlAdaptorServer() {
        this(8082);
    }

    public HtmlAdaptorServer(int n) {
        super(3);
        this.port = n;
        this.maxActiveClientCount = 10;
        this.dbgTag = this.makeDebugTag();
        this.buildInfo();
    }

    public HtmlAdaptorServer(int n, AuthInfo[] authInfoArray) {
        this(n);
        if (authInfoArray != null) {
            int n2 = 0;
            while (n2 < authInfoArray.length) {
                this.addUserAuthenticationInfo(authInfoArray[n2]);
                ++n2;
            }
        }
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
            this.authInfo.addElement(authInfo);
        }
    }

    private void buildInfo() {
        this.dattributes[0] = new MBeanAttributeInfo("Active", "boolean", "Active: True if the HtmlAdaptorServer is in the ONLINE state.", true, false, true);
        this.dattributes[1] = new MBeanAttributeInfo("ActiveClientCount", "int", "ActiveClientCount: The number of clients being processed currently by the HtmlAdaptorServer.", true, false, false);
        this.dattributes[2] = new MBeanAttributeInfo("AuthenticationOn", "boolean", "AuthenticationOn: True if the HtmlAdaptorServer requests authentication.", true, false, true);
        this.dattributes[3] = new MBeanAttributeInfo("Host", "java.lang.String", "Host: Hostname.", true, false, false);
        this.dattributes[4] = new MBeanAttributeInfo("LastConnectedClient", "java.lang.String", "LastConnectedClient: The IP address of the last connected client.", true, false, false);
        this.dattributes[5] = new MBeanAttributeInfo("MaxActiveClientCount", "int", "MaxActiveClientCount: The maximum number of clients the HtmlAdaptorServer can process concurrently.", true, true, false);
        this.dattributes[6] = new MBeanAttributeInfo("Parser", "javax.management.ObjectName", "Parser: ObjectName of the MBean used to customized HTML pages generated by the HtmlAdaptorServer.", true, true, false);
        this.dattributes[7] = new MBeanAttributeInfo("Port", "int", "Port: Port number used.", true, true, false);
        this.dattributes[8] = new MBeanAttributeInfo("Protocol", "java.lang.String", "Protocol: html.", true, false, false);
        this.dattributes[9] = new MBeanAttributeInfo("ServedClientCount", "int", "ServedClientCount: The number of clients that have been processed by the HtmlAdaptorServer since its creation.", true, false, false);
        this.dattributes[10] = new MBeanAttributeInfo("State", "int", "State: State of the HtmlAdaptorServer.", true, false, false);
        this.dattributes[11] = new MBeanAttributeInfo("StateString", "java.lang.String", "StateString: State of the HtmlAdaptorServer.", true, false, false);
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            if (constructorArray[n].getParameterTypes().length == 0) {
                this.dconstructors[0] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with default port number equal to 8082.", constructorArray[n]);
            } else if (constructorArray[n].getParameterTypes().length == 1) {
                this.dconstructors[1] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with the specified port number.", constructorArray[n]);
            } else {
                this.dconstructors[2] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with the specified port number and user authentication information list.", constructorArray[n]);
            }
            ++n;
        }
        this.doperations[0] = new MBeanOperationInfo("start", "start: Start the HtmlAdaptorServer.", null, "void", 1);
        this.doperations[1] = new MBeanOperationInfo("stop", "stop: Stop the HtmlAdaptorServer.", null, "void", 1);
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("state", "int", "state: The state to wait for."), new MBeanParameterInfo("timeout", "long", "timeout: The maximum time to wait in milliseconds.")};
        this.doperations[2] = new MBeanOperationInfo("waitState", "waitState: Waits to be notified of a specific state change in the HtmlAdaptorServer.", mBeanParameterInfoArray, "boolean", 1);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{new MBeanParameterInfo("class name", "java.lang.String", "class name: The name of the class used to parse HTML page."), new MBeanParameterInfo("object name", "java.lang.String", "object name: The name of the MBean to register in the MBeanServer."), new MBeanParameterInfo("class loader name", "java.lang.String", "class loader name: The ObjectName of the MBean to use as class loader, if it is empty, the default agent class loader will be used by the MBeanServer.")};
        this.doperations[3] = new MBeanOperationInfo("createParser", "createParser: Create, Register to the MBeanServer and set Parser attribute with the HTML parser MBean", mBeanParameterInfoArray2, "void", 1);
        this.doperations[4] = new MBeanOperationInfo("resetParser", "resetParser: Remove the customization from HtmlAdaptorServer by reseting the Parser property to null.", null, "void", 1);
        this.dmbeaninfo = new MBeanInfo(this.dclassName, this.ddescription, this.dattributes, this.dconstructors, this.doperations, new MBeanNotificationInfo[0]);
    }

    synchronized boolean checkChallengeResponse(String string) {
        if (this.isTraceOn()) {
            this.trace("checkChallengeResponse", " Validate  request");
        }
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.isDebugOn()) {
                this.debug("checkChallengeResponse", "No such element. [Exception=" + noSuchElementException + "]");
            }
            return false;
        }
        if (this.isTraceOn()) {
            this.trace("checkChallengeResponse", " Validate the request for [Login=" + string2 + ", Password=" + string3 + "]");
        }
        Enumeration enumeration = this.authInfo.elements();
        while (enumeration.hasMoreElements()) {
            AuthInfo authInfo = (AuthInfo)enumeration.nextElement();
            if (!authInfo.getLogin().equals(string2) || !authInfo.getPassword().equals(string3)) continue;
            return true;
        }
        return false;
    }

    public void createParser(String string, String string2, String string3) throws MalformedObjectNameException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectName objectName;
        Object object = null;
        if (string3 != null && string3.length() > 0) {
            objectName = new ObjectName(string3);
            object = this.topMBS.instantiate(string, objectName);
        } else {
            object = this.topMBS.instantiate(string);
        }
        try {
            if (!Class.forName("com.sun.jdmk.comm.HtmlParser").isAssignableFrom(object.getClass())) {
                object = null;
                throw new MBeanException(new ServiceNotFoundException("The HtmlParser interface is not implemented by the MBbean = " + string));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isDebugOn()) {
                this.debug("setParser", " Class not found. [Exception=" + classNotFoundException + "]");
            }
            object = null;
            throw new MBeanException(new ServiceNotFoundException(classNotFoundException.toString()));
        }
        objectName = new ObjectName(string2);
        this.topMBS.registerMBean(object, objectName);
        try {
            this.setParser(objectName);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            if (this.isDebugOn()) {
                this.debug("setParser", " Service not found. [Exception=" + serviceNotFoundException + "]");
            }
            throw new MBeanException(serviceNotFoundException);
        }
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doBind", "Bind the socket listener to [Port=" + this.port + ", MaxActiveClientCount=" + this.maxActiveClientCount + "]");
        }
        try {
            this.sockListen = new ServerSocket(this.port, 2 * this.maxActiveClientCount);
            if (this.isTraceOn()) {
                this.trace("doBind", "Bound to [Address=" + this.sockListen.getInetAddress() + ", Port=" + this.sockListen.getLocalPort() + "]");
            }
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doProcess", "Process a request received on [Socket=" + this.sock + "]");
        }
        this.addrLastClient = this.sock.getInetAddress();
        HtmlRequestHandler htmlRequestHandler = new HtmlRequestHandler(this.sock, this, this.topMBS, this.objectName, this.servedClientCount);
        this.sock = null;
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doReceive", "Listens for a connection on [Listener=" + this.sockListen + "]");
        }
        try {
            this.sock = this.sockListen.accept();
            if (this.isTraceOn()) {
                this.trace("doReceive", "Accepted a connection on [Socket=" + this.sock + "]");
            }
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doUnbind", "Finally close the socket [Listener=" + this.sockListen + "]");
        }
        try {
            this.sockListen.close();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null || string.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null or empty"), "The getAttribute method of HtmlAdaptorServer was called with a null or empty attribute name string.");
        }
        if (string.equals("Active")) {
            return new Boolean(this.isActive());
        }
        if (string.equals("ActiveClientCount")) {
            return new Integer(this.getActiveClientCount());
        }
        if (string.equals("AuthenticationOn")) {
            return new Boolean(this.isAuthenticationOn());
        }
        if (string.equals("Host")) {
            return this.getHost();
        }
        if (string.equals("LastConnectedClient")) {
            return this.getLastConnectedClient();
        }
        if (string.equals("MaxActiveClientCount")) {
            return new Integer(this.getMaxActiveClientCount());
        }
        if (string.equals("Parser")) {
            return this.getParser();
        }
        if (string.equals("Port")) {
            return new Integer(this.getPort());
        }
        if (string.equals("Protocol")) {
            return this.getProtocol();
        }
        if (string.equals("ServedClientCount")) {
            return new Integer(this.getServedClientCount());
        }
        if (string.equals("State")) {
            return new Integer(this.getState());
        }
        if (string.equals("StateString")) {
            return this.getStateString();
        }
        throw new AttributeNotFoundException(String.valueOf(string) + " is unknown in HtmlAdaptorServer");
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        String string = null;
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the HtmlAdaptorServer");
        }
        if (stringArray.length == 0) {
            return attributeList;
        }
        int n = 0;
        while (n < stringArray.length) {
            block5: {
                string = stringArray[n];
                String string2 = stringArray[n];
                try {
                    Object object = this.getAttribute(string2);
                    attributeList.add(new Attribute(string2, object));
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block5;
                    this.debug("getAttributes", "Unexpected exception [Exception=" + exception + "]");
                }
            }
            ++n;
        }
        return attributeList;
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return new String("unknown");
        }
        return this.addrLastClient.getHostAddress();
    }

    public MBeanInfo getMBeanInfo() {
        return this.dmbeaninfo;
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public ObjectName getParser() {
        return this.userParser;
    }

    public String getProtocol() {
        return "html";
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null || string.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("String parameter 'actionName' of invoke method of HtmlAdaptorServer cannot be null or empty"), "String parameter 'actionName' of invoke method of HtmlAdaptorServer cannot be null or empty");
        }
        if (string.equals("start")) {
            this.start();
            return null;
        }
        if (string.equals("stop")) {
            this.stop();
            return null;
        }
        if (string.equals("waitState")) {
            try {
                if (objectArray.length != 2 || !(objectArray[0] instanceof Integer) || !(objectArray[1] instanceof Long)) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke waitState: expecting params[0] instanceof Integer and params[1] instanceof Long"), "Wrong content for array Object[] params to invoke waitState method of HtmlAdaptorServer");
                }
                if (stringArray.length != 2 || !stringArray[0].equals("int") || !stringArray[1].equals("long")) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke waitState: expecting signature[0].equals(\"int\") and signature[1].equals(\"long\")"), "Wrong content for array String[] signature to invoke waitState method of HtmlAdaptorServer");
                }
                return new Boolean(this.waitState((Integer)objectArray[0], (Long)objectArray[1]));
            }
            catch (Exception exception) {
                throw new MBeanException(exception, "invoke waitState: " + exception.getClass().getName() + "caught [" + exception.getMessage() + "]");
            }
        }
        if (string.equals("createParser")) {
            try {
                if (!(objectArray.length == 3 && objectArray[0] instanceof String && objectArray[1] instanceof String && objectArray[2] instanceof String)) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke createParser: expecting params[0] instanceof String and params[1] instanceof String and params[2] instanceof String"), "Wrong content for array Object[] params to invoke createParser method of HtmlAdaptorServer");
                }
                if (!(stringArray.length == 3 && stringArray[0].equals("String") && stringArray[1].equals("String") && stringArray[2].equals("String"))) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke createParser: expecting signature[0].equals(\"String\") and signature[1].equals(\"String\") and signature[2].equals(\"String\")"), "Wrong content for array String[] signature to invoke createParser method of HtmlAdaptorServer");
                }
                this.createParser((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            }
            catch (Exception exception) {
                throw new MBeanException(exception, "invoke createParser: " + exception.getClass().getName() + "caught [" + exception.getMessage() + "]");
            }
            return null;
        }
        if (string.equals("resetParser")) {
            this.resetParser();
            return null;
        }
        if (string.startsWith("get") && string.length() > 3) {
            String string2 = string.substring(3);
            try {
                return this.getAttribute(string2);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new ReflectionException(new NoSuchMethodException(string), "The action with name " + string + " could not be found in HtmlAdaptorServer");
            }
        }
        if (string.startsWith("is") && string.length() > 2) {
            String string3 = string.substring(2);
            try {
                return this.getAttribute(string3);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new ReflectionException(new NoSuchMethodException(string), "The action with name " + string + " could not be found in HtmlAdaptorServer");
            }
        }
        if (string.startsWith("set") && string.length() > 3) {
            String string4 = string.substring(3);
            if (objectArray.length != 1) {
                throw new RuntimeOperationsException(new IllegalArgumentException("invoke " + string + ": expecting params.length == 1"), "Array Object[] params to invoke createParser method of HtmlAdaptorServer should be of length 1");
            }
            try {
                this.setAttribute(new Attribute(string4, objectArray[0]));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new ReflectionException(new NoSuchMethodException(string), "The action with name " + string + " could not be found in HtmlAdaptorServer");
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new MBeanException(invalidAttributeValueException, "InvalidAttributeValueException thrown when invoking setAttribute for attribute with [name=" + string4 + "] and [value=" + objectArray[0] + "]");
            }
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(string), "The action with name " + string + " could not be found in HtmlAdaptorServer");
    }

    public boolean isAuthenticationOn() {
        return this.authInfo.isEmpty() ^ true;
    }

    String makeDebugTag() {
        return "HtmlAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(String.valueOf(mBeanServer.getDefaultDomain()) + ":" + "name=HtmlAdaptorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
        }
    }

    public void resetParser() {
        this.userParser = null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("setAttribute: attribute parameter cannot be null"), "Cannot invoke setAttribute method of " + this.dclassName + " with null attribute parameter");
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null || string.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("setAttribute: name field of attribute parameter cannot be null or empty"), "Cannot invoke setAttribute method of " + this.dclassName + " with null or empty attribute parameter name field");
        }
        if (string.equals("Port")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(object != null ? object.getClass() : Class.forName("java.lang.Integer"))) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + string + " to a " + (object != null ? object.getClass().getName() : object) + " object, java.lang.Integer expected");
                }
                this.setPort((Integer)attribute.getValue());
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("setAttribute", "setAttribute Port: caught [Exception=" + exception + "]");
                }
                throw new MBeanException(exception, "setAttribute Port: " + exception.getClass().getName() + " caught [" + exception.getMessage() + "]");
            }
        } else if (string.equals("MaxActiveClientCount")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(object != null ? object.getClass() : Class.forName("java.lang.Integer"))) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + string + " to a " + (object != null ? object.getClass().getName() : object) + " object, java.lang.Integer expected");
                }
                this.setMaxActiveClientCount((Integer)attribute.getValue());
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("setAttribute", "setAttribute MaxActiveClientCount: caught [Exception=" + exception + "]");
                }
                throw new MBeanException(exception, "setAttribute MaxActiveClientCount: " + exception.getClass().getName() + " caught [" + exception.getMessage() + "]");
            }
        } else if (string.equals("Parser")) {
            try {
                if (!Class.forName("javax.management.ObjectName").isAssignableFrom(object != null ? object.getClass() : Class.forName("javax.management.ObjectName"))) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + string + " to a " + (object != null ? object.getClass().getName() : object) + " object, javax.management.ObjectName expected");
                }
                this.setParser((ObjectName)attribute.getValue());
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("setAttribute", "setAttribute Parser: caught [Exception=" + exception + "]");
                }
                throw new MBeanException(exception, "setAttribute Parser: " + exception.getClass().getName() + " caught [" + exception.getMessage() + "]");
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + string + " is unknown in HtmlAdaptorServer, or is not writable");
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        Iterator iterator = ((AbstractList)attributeList).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName();
            Object object = attribute.getValue();
            try {
                Object var7_7 = null;
                this.setAttribute(attribute);
                attributeList2.add(new Attribute(string, this.getAttribute(string)));
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("setAttributes", "Exception when setting " + string + ". [Exception=" + exception + "]");
            }
        }
        return attributeList2;
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    public void setParser(ObjectName objectName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (objectName == null) {
            this.resetParser();
            return;
        }
        ObjectInstance objectInstance = this.topMBS.getObjectInstance(objectName);
        try {
            if (!Class.forName("com.sun.jdmk.comm.HtmlParser").isAssignableFrom(Class.forName(objectInstance.getClassName()))) {
                throw new ServiceNotFoundException("The HtmlParser interface is not implemented by the MBbean = " + objectName);
            }
            this.userParser = objectName;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isDebugOn()) {
                this.debug("setParser", "Class not found [Exception=" + classNotFoundException + "]");
            }
            throw new ServiceNotFoundException(classNotFoundException.toString());
        }
    }

    public void stop() {
        block2: {
            if (this.state != 0 && this.state != 3) break block2;
            super.stop();
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
                socket.close();
            }
            catch (IOException iOException) {
                if (!this.isDebugOn()) break block2;
                this.debug("stop", "I/O exception. [Exception=" + iOException + "]");
            }
        }
    }
}

