/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.manager;

import com.sun.jdmk.Task;
import com.sun.jdmk.TaskServer;
import com.sun.jdmk.Trace;
import com.sun.jdmk.snmp.SnmpPduFactoryBER;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.manager.SnmpEventReportHandler;
import javax.management.snmp.manager.SnmpEventReportListener;
import javax.management.snmp.manager.SnmpInformListener;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpTrapListener;

public class SnmpEventReportDispatcher
implements Runnable {
    private int port = 162;
    private DatagramSocket dSocket = null;
    private Vector trapListeners;
    private Vector informListeners;
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private TaskServer taskServer = null;
    private Vector eventReportReceivers;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    String dbgTag = "SnmpEventReportDispatcher";

    public SnmpEventReportDispatcher() throws SocketException {
        this(162);
    }

    public SnmpEventReportDispatcher(int n) throws SocketException {
        this.port = n;
        this.dSocket = new DatagramSocket(this.port);
        this.trapListeners = new Vector();
        this.informListeners = new Vector();
        this.eventReportReceivers = new Vector();
    }

    public SnmpEventReportDispatcher(int n, TaskServer taskServer) throws SocketException {
        this.port = n;
        this.dSocket = new DatagramSocket(this.port);
        this.trapListeners = new Vector();
        this.informListeners = new Vector();
        this.eventReportReceivers = new Vector();
        this.taskServer = taskServer;
    }

    public void addEventReportListener(SnmpEventReportListener snmpEventReportListener) {
        this.eventReportReceivers.addElement(snmpEventReportListener);
    }

    public void addInformListener(SnmpInformListener snmpInformListener) {
        this.informListeners.addElement(snmpInformListener);
    }

    public void addTrapListener(SnmpTrapListener snmpTrapListener) {
        this.trapListeners.addElement(snmpTrapListener);
    }

    private boolean checkPduType(SnmpPduPacket snmpPduPacket) {
        if (snmpPduPacket.type == 166) {
            return true;
        }
        if (this.isDebugOn()) {
            this.debug("checkPduType", "cannot respond to this kind of PDU");
        }
        return false;
    }

    public boolean containsEventReportReceiver(SnmpEventReportListener snmpEventReportListener) {
        return this.eventReportReceivers.contains(snmpEventReportListener);
    }

    public boolean containsInformListener(SnmpInformListener snmpInformListener) {
        return this.informListeners.contains(snmpInformListener);
    }

    public boolean containsTrapListener(SnmpTrapListener snmpTrapListener) {
        return this.trapListeners.contains(snmpTrapListener);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    public Enumeration getEventReportListeners() {
        return this.eventReportReceivers.elements();
    }

    public Enumeration getInformListeners() {
        return this.informListeners.elements();
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public Enumeration getTrapListeners() {
        return this.trapListeners.elements();
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private SnmpMessage makeResponseMessage(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        SnmpMessage snmpMessage;
        block10: {
            snmpMessage = null;
            SnmpPduPacket snmpPduPacket2 = null;
            if (snmpPduPacket != null) {
                snmpPduPacket2 = this.makeResponsePdu(snmpPduPacket);
            }
            if (snmpPduPacket2 == null) break block10;
            try {
                snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
                snmpMessage = null;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                    snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                    }
                    snmpMessage = null;
                }
                catch (Exception exception) {
                    snmpMessage = null;
                }
            }
        }
        return snmpMessage;
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        DatagramPacket datagramPacket2;
        block6: {
            datagramPacket2 = null;
            SnmpMessage snmpMessage = this.makeResponseMessage(datagramPacket, snmpPduPacket);
            if (snmpMessage == null) break block6;
            try {
                datagramPacket.setLength(snmpMessage.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    SnmpPduPacket snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                    snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
                    datagramPacket.setLength(snmpMessage.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw new InternalError();
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    private SnmpPduPacket makeResponsePdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduPacket snmpPduPacket2 = null;
        if (this.checkPduType(snmpPduPacket)) {
            snmpPduPacket2 = snmpPduPacket;
        }
        return snmpPduPacket2;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.type = snmpPduPacket.type;
        snmpPduRequest.version = snmpPduPacket.version;
        snmpPduRequest.community = snmpPduPacket.community;
        snmpPduRequest.requestId = snmpPduPacket.requestId;
        snmpPduRequest.address = snmpPduPacket.address;
        snmpPduRequest.port = snmpPduPacket.port;
        snmpPduRequest.errorStatus = 1;
        snmpPduRequest.errorIndex = 0;
        snmpPduRequest.varBindList = null;
        return snmpPduRequest;
    }

    public void removeEventReportListener(SnmpEventReportListener snmpEventReportListener) {
        this.eventReportReceivers.removeElement(snmpEventReportListener);
    }

    public void removeInformListener(SnmpInformListener snmpInformListener) {
        this.informListeners.removeElement(snmpInformListener);
    }

    public void removeTrapListener(SnmpTrapListener snmpTrapListener) {
        this.trapListeners.removeElement(snmpTrapListener);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Runnable runnable;
                    Object object;
                    Object object2;
                    Object object3;
                    SnmpPduPacket snmpPduPacket;
                    byte[] byArray = new byte[SnmpPeer.defaultSnmpRequestPktSize];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, SnmpPeer.defaultSnmpRequestPktSize);
                    this.dSocket.setSoTimeout(0);
                    if (this.isTraceOn()) {
                        this.trace("run", "Now waiting for event reports...");
                    }
                    this.dSocket.receive(datagramPacket);
                    if (this.isTraceOn()) {
                        this.trace("run", "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    SnmpMessage snmpMessage = new SnmpMessage();
                    snmpMessage.address = datagramPacket.getAddress();
                    snmpMessage.port = datagramPacket.getPort();
                    snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
                    SnmpPduPacket snmpPduPacket2 = this.pduFactory.decodePdu(snmpMessage);
                    if (snmpPduPacket2.type == 164 || snmpPduPacket2.type == 167) {
                        Enumeration enumeration;
                        if (this.isTraceOn()) {
                            if (snmpPduPacket2.type == 164) {
                                this.trace("run", "Received an SNMP trap V1");
                            } else {
                                this.trace("run", "Received an SNMP trap V2");
                            }
                        }
                        snmpPduPacket = snmpPduPacket2;
                        object3 = this.trapListeners;
                        synchronized (object3) {
                            enumeration = this.trapListeners.elements();
                            while (enumeration.hasMoreElements()) {
                                object2 = (SnmpTrapListener)enumeration.nextElement();
                                object = new SnmpEventReportHandler((SnmpTrapListener)object2, snmpPduPacket);
                                runnable = new SnmpTask((SnmpEventReportHandler)object);
                                this.taskServer.submitTask((Task)runnable);
                            }
                        }
                        object3 = this.eventReportReceivers;
                        synchronized (object3) {
                            enumeration = this.eventReportReceivers.elements();
                            while (enumeration.hasMoreElements()) {
                                object2 = (SnmpEventReportListener)enumeration.nextElement();
                                object = new SnmpEventReportHandler((SnmpEventReportListener)object2, snmpPduPacket);
                                runnable = new SnmpTask((SnmpEventReportHandler)object);
                                this.taskServer.submitTask((Task)runnable);
                            }
                        }
                    }
                    if (snmpPduPacket2.type == 166) {
                        block35: {
                            if (this.isTraceOn()) {
                                this.trace("run", "Received an Inform Request");
                            }
                            snmpPduPacket = snmpPduPacket2;
                            object3 = this.makeResponsePacket(datagramPacket, snmpPduPacket);
                            if (this.isTraceOn() && object3 != null) {
                                this.trace("run", "Response packet to be sent:\n" + SnmpMessage.dumpHexBuffer(((DatagramPacket)object3).getData(), 0, ((DatagramPacket)object3).getLength()));
                            }
                            if (object3 != null) {
                                try {
                                    this.dSocket.send((DatagramPacket)object3);
                                }
                                catch (SocketException socketException) {
                                    if (this.isDebugOn()) {
                                        if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                                            this.debug("run", "interrupted");
                                        } else {
                                            this.debug("run", "i/o exception");
                                            this.debug("run", socketException);
                                        }
                                    }
                                }
                                catch (InterruptedIOException interruptedIOException) {
                                    if (this.isDebugOn()) {
                                        this.debug("run", "interrupted");
                                    }
                                }
                                catch (Exception exception) {
                                    if (!this.isDebugOn()) break block35;
                                    this.debug("run", "failure when sending response");
                                    this.debug("run", exception);
                                }
                            }
                        }
                        Vector vector = this.informListeners;
                        synchronized (vector) {
                            object2 = this.informListeners.elements();
                            while (object2.hasMoreElements()) {
                                object = (SnmpInformListener)object2.nextElement();
                                runnable = new SnmpEventReportHandler((SnmpInformListener)object, snmpPduPacket);
                                SnmpTask snmpTask = new SnmpTask((SnmpEventReportHandler)runnable);
                                this.taskServer.submitTask(snmpTask);
                            }
                        }
                    }
                    if (!this.isDebugOn()) continue;
                    this.debug("run", "trashed the packet because it's not an SNMP event report");
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "packet decoding failed");
                continue;
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", exception);
                continue;
            }
            break;
        }
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        if (snmpPduFactory == null) {
            snmpPduFactory = new SnmpPduFactoryBER();
        }
        this.pduFactory = snmpPduFactory;
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    private class SnmpTask
    implements Task {
        private SnmpEventReportHandler handler;

        public SnmpTask(SnmpEventReportHandler snmpEventReportHandler) {
            this.handler = snmpEventReportHandler;
        }

        public void cancel() {
        }

        public synchronized void run() {
            this.handler.run();
        }
    }
}

