/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibNode;
import com.sun.jdmk.snmp.agent.SnmpMibOid;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpMibTable;
import com.sun.jdmk.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibGroup
extends SnmpMibOid
implements Serializable {
    protected Hashtable subgroups = null;

    public abstract void check(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n2 = lArray.length;
        Object var6_6 = null;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        Object object = snmpRequestTree.getUserData();
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        long l = lArray[n];
        if (this.isNestedArc(l)) {
            super.findHandlingNode(snmpVarBind, lArray, n, snmpRequestTree);
            return;
        }
        if (this.isTable(l)) {
            SnmpMibTable snmpMibTable = this.getTable(l);
            snmpMibTable.findHandlingNode(snmpVarBind, lArray, n + 1, snmpRequestTree);
        } else {
            this.validateVarId(l, object);
            if (n + 2 > n2) {
                throw SnmpMibNode.noSuchInstanceException;
            }
            if (n + 2 < n2) {
                throw SnmpMibNode.noSuchInstanceException;
            }
            if (lArray[n + 1] != 0L) {
                throw SnmpMibNode.noSuchInstanceException;
            }
            snmpRequestTree.add(this, n, snmpVarBind);
        }
    }

    long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, int n2, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n3 = lArray.length;
        Object var7_7 = null;
        if (snmpRequestTree == null) {
            throw SnmpMibNode.noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        if (n >= n3) {
            return super.findNextHandlingNode(snmpVarBind, lArray, n, n2, snmpRequestTree);
        }
        long l = lArray[n];
        long[] lArray2 = null;
        try {
            if (this.isTable(l)) {
                SnmpMibTable snmpMibTable = this.getTable(l);
                lArray2 = snmpMibTable.findNextHandlingNode(snmpVarBind, lArray, n + 1, n2 + 1, snmpRequestTree);
                lArray2[n2] = l;
                return lArray2;
            }
            if (this.isReadable(l)) {
                if (n == n3 - 1) {
                    lArray2 = new long[n2 + 2];
                    lArray2[n2 + 1] = 0L;
                    lArray2[n2] = l;
                    snmpRequestTree.add(this, n2, snmpVarBind);
                    return lArray2;
                }
            } else if (this.isNestedArc(l)) {
                return super.findNextHandlingNode(snmpVarBind, lArray, n, n2, snmpRequestTree);
            }
            throw SnmpMibNode.noSuchObjectException;
        }
        catch (SnmpStatusException snmpStatusException) {
            long[] lArray3 = new long[]{this.getNextVarId(l, object)};
            return this.findNextHandlingNode(snmpVarBind, lArray3, 0, n2, snmpRequestTree);
        }
    }

    public abstract void get(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public void getRootOid(Vector vector) {
    }

    public abstract SnmpMibTable getTable(long var1);

    public boolean isNestedArc(long l) {
        if (this.subgroups == null) {
            return false;
        }
        Object v = this.subgroups.get(new Long(l));
        return v != null;
    }

    public abstract boolean isReadable(long var1);

    public abstract boolean isTable(long var1);

    public abstract boolean isVariable(long var1);

    void registerNestedArc(long l) {
        Long l2 = new Long(l);
        if (this.subgroups == null) {
            this.subgroups = new Hashtable();
        }
        this.subgroups.put(l2, l2);
    }

    void registerNode(long[] lArray, int n, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        super.registerNode(lArray, n, snmpMibNode);
        if (n < 0) {
            return;
        }
        if (n >= lArray.length) {
            return;
        }
        this.registerNestedArc(lArray[n]);
    }

    protected void registerObject(long l) throws IllegalAccessException {
        long[] lArray = new long[]{l};
        super.registerNode(lArray, 0, null);
    }

    public abstract void set(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public void validateVarId(long l, Object object) throws SnmpStatusException {
        if (!this.isVariable(l)) {
            throw SnmpMibNode.noSuchObjectException;
        }
    }
}

