/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.Task;
import com.sun.jdmk.TaskServer;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class DaemonTaskServer
implements Runnable,
TaskServer {
    private transient boolean on = false;
    private transient boolean isRunning = false;
    private transient boolean terminating = false;
    private transient LinkedList list = new LinkedList();
    private transient Thread thread = null;
    private transient long sequenceNumber = 0L;
    private static int count = 0;

    protected void cancel(Task task) throws InterruptedException {
        task.cancel();
    }

    protected void execute(Task task) throws InterruptedException {
        task.run();
    }

    private boolean isListEmpty() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            boolean bl = this.list.isEmpty();
            Object var3_3 = null;
            return bl;
        }
    }

    private synchronized boolean isOn() {
        return this.on;
    }

    private synchronized boolean isRunning() {
        return this.isRunning;
    }

    private final synchronized Task nextTask() throws InterruptedException {
        try {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                Task task = (Task)this.list.removeFirst();
                Object var3_5 = null;
                return task;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.wait();
            try {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    Task task = (Task)this.list.removeFirst();
                    Object var3_6 = null;
                    return task;
                }
            }
            catch (NoSuchElementException noSuchElementException2) {
                return null;
            }
        }
    }

    public synchronized void reset() {
        if (this.isOn() || this.isRunning()) {
            throw new IllegalStateException("Must be stopped in order to reset");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
        this.terminating = false;
    }

    public void run() {
        try {
            this.running();
            while (this.isOn()) {
                try {
                    Task task = this.nextTask();
                    if (task == null) continue;
                    this.execute(task);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            Object var2_2 = null;
            this.stopped();
        }
    }

    private synchronized void running() {
        this.isRunning = true;
    }

    public void start() {
        Thread thread;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (this.terminating) {
                throw new IllegalStateException("Task Server Terminated");
            }
            if (this.isOn()) {
                Object var3_2 = null;
                return;
            }
            this.on = true;
            thread = this.thread = new Thread((Runnable)this, "DaemonTaskServer(" + count++ + ")");
            thread.setDaemon(true);
        }
        thread.start();
    }

    public void stop() throws InterruptedException {
        Thread thread;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (!this.isOn() && this.thread == null) {
                Object var3_2 = null;
                return;
            }
            thread = this.thread;
            this.on = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        if (thread != null && Thread.currentThread() != thread) {
            thread.join();
        }
    }

    private synchronized void stopped() {
        this.isRunning = false;
        this.thread = null;
    }

    public synchronized void submitTask(Task task) {
        if (this.terminating) {
            throw new IllegalStateException("Task Server Terminated");
        }
        if (task == null) {
            return;
        }
        this.list.addLast(task);
        this.wakethread();
    }

    public void terminate() throws InterruptedException {
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            this.terminating = true;
        }
        this.stop();
        daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            while (!this.isListEmpty()) {
                try {
                    Task task;
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        task = (Task)this.list.removeFirst();
                    }
                    this.cancel(task);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
        }
    }

    private final synchronized void wakethread() {
        this.notifyAll();
    }
}

