/*
 * @(#)file      SnmpSubNextRequestHandler.java
 * @(#)author    Sun Microsystems, Inc.
 * @(#)version   4.11
 * @(#)date      01/08/24
 *
 * Copyright 2000 Sun Microsystems, Inc. All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2000 Sun Microsystems, Inc. Tous droits rservs.
 * Ce logiciel est propriet de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation. 
 *
 */


package com.sun.jdmk.comm;



// jmx imports
//
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpStatusException;

// jdmk import
//
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;
/* NPCTE fix for bugId 4492741, esc 0 */
import com.sun.jdmk.ThreadContext;
/* end of NPCTE fix for bugId 4492741 */
class SnmpSubNextRequestHandler extends SnmpSubRequestHandler {
  
    /**
     * The constuctor initialize the subrequest with the whole varbind
     * list contained in the original request.
     */
    protected SnmpSubNextRequestHandler(SnmpMibAgent agent, 
					SnmpPduPacket req) {
        super(agent,req);  
    
        // The translation table is easy in this case ...
        //
        final int max= translation.length;
        final SnmpVarBind[] list= req.varBindList;
        final NonSyncVector nonSyncVarBind = ((NonSyncVector)varBind);
        for(int i=0; i < max; i++) {
            translation[i]= i;
            // we need to allocate a new SnmpVarBind. Otherwise the first
            // sub request will modify the list...
            //
	    final SnmpVarBind newVarBind = 
		new SnmpVarBind(list[i].oid, list[i].value);
            nonSyncVarBind.addNonSyncElement(newVarBind);
        }
    }
  
    public void run() {
    
        try {
	    /* NPCTE fix for bugId 4492741, esc 0, 16-August-2001 */
     	    final ThreadContext oldContext =
                ThreadContext.push("SnmpUserData",data);
	    try { 
            	if (isTraceOn()) {
                	trace("run", "[" + Thread.currentThread() + 
		      	"]:getNext operation on " + agent.getMibName());
            	}
      
            	// Always call with V2. So the merge of the responses will 
	    	// be easier.
            	//
            	agent.getNext(createMibRequest(varBind, snmpVersionTwo, data));
	    } finally {
                ThreadContext.restore(oldContext);
            }
	    /* end of NPCTE fix for bugId 4492741 */

      
        } catch(SnmpStatusException x) {
            errorStatus = x.getStatus() ;
            errorIndex=  x.getErrorIndex();
            if (isDebugOn()) {
                debug("run", "[" + Thread.currentThread() + 
		      "]:a Snmp error occured during the operation");
            }
        }
        catch(Exception x) {
            errorStatus = SnmpDefinitions.snmpRspGenErr ;
            if (isDebugOn()) {
                debug("run", "[" + Thread.currentThread() + 
		      "]:a generic error occured during the operation");
            }
        }
        if (isTraceOn()) {
            trace("run", "[" + Thread.currentThread() + 
		  "]:operation completed");
        }
    }
 
    /**
     * The method updates a given var bind list with the result of a 
     * previsouly invoked operation.
     * Prior to calling the method, one must make sure that the operation was
     * successful. As such the method getErrorIndex or getErrorStatus should be
     * called.
     */
    protected void updateResult(SnmpVarBind[] result) {
  
        final int max=varBind.size();
        for(int i= 0; i< max ; i++) {
            // May be we should control the position ...
            //
            final int index= translation[i];
            final SnmpVarBind elmt= 
		(SnmpVarBind)((NonSyncVector)varBind).elementAtNonSync(i);

            final SnmpVarBind vb= result[index];
            if (vb == null) {
                result[index]= elmt;
		/* NPCTE fix for bugid 4381195 esc 0. <J.C.> < 17-Oct-2000> */
	        // if ((elmt != null) &&  (elmt.value == null) && 
		//    (version == snmpVersionTwo)) 
		//    elmt.value = SnmpVarBind.endOfMibView;
 		/* end of NPCTE fix for bugid 4381195 */
                continue;
            }

            final SnmpValue val= vb.value;
            if ((val == null)|| (val == SnmpVarBind.endOfMibView)){
		/* NPCTE fix for bugid 4381195 esc 0. <J.C.> < 17-Oct-2000> */
		if ((elmt != null) &&
		    (elmt.value != SnmpVarBind.endOfMibView)) 
		    result[index]= elmt;
		// else if ((val == null) && (version == snmpVersionTwo)) 
		//    vb.value = SnmpVarBind.endOfMibView;
		continue;
 		/* end of NPCTE fix for bugid 4381195 */
            }
     
	    /* NPCTE fix for bugid 4381195 esc 0. <J.C.> < 17-Oct-2000> */
	    if (elmt == null) continue;
	    /* end of NPCTE fix for bugid 4381195 */

	    if (elmt.value == SnmpVarBind.endOfMibView) continue;


            // Now we need to take the smallest oid ...
            //
            if (elmt.oid.compareTo(vb.oid) <=0) {
                // Take the smallest (lexicographically)
                //
                result[index]= elmt;
            }
        }
    }
    
    protected String makeDebugTag() {
        return "SnmpSubNextRequestHandler";
    }
}
