/*
 * @(#)file      SnmpSubBulkRequestHandler.java
 * @(#)author    Sun Microsystems, Inc.
 * @(#)version   4.11
 * @(#)date      01/08/24
 *
 * Copyright 2000 Sun Microsystems, Inc. All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2000 Sun Microsystems, Inc. Tous droits rservs.
 * Ce logiciel est propriet de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation. 
 *
 */


package com.sun.jdmk.comm;



// java import
//
import java.util.Enumeration;

// jmx imports
//
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpStatusException;

// jdmk import
//
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibRequest;

import com.sun.jdmk.ThreadContext;

class SnmpSubBulkRequestHandler extends SnmpSubRequestHandler {

    /**
     * Full Ctor
     */
    protected SnmpSubBulkRequestHandler(SnmpMibAgent agent, SnmpPduBulk req, int maxRepeat, int R) {
        super(agent, req);
        this.nonRepeat= 0;
        this.maxRepeat= maxRepeat;  
        this.globalR= R;
    }

    /**
     * The constuctor initialize the subrequest with the whole varbind list contained
     * in the original request.
     */
    protected SnmpSubBulkRequestHandler(SnmpMibAgent agent, SnmpPduBulk req, int nonRepeat,
                                        int maxRepeat, int R,boolean nouse) {
        super(agent,req, true); 
        this.nonRepeat= nonRepeat;
        this.maxRepeat= maxRepeat;  
        this.globalR= R;
    }
    
    public void run() {
    
        size= varBind.size();
    
        try {
            // Invoke a getBulk operation
            //
	    /* NPCTE fix for bugId 4492741, esc 0, 16-August-2001 */
	    final ThreadContext oldContext =
                ThreadContext.push("SnmpUserData",data);
	    try {
            	if (isTraceOn()) {
                	trace("run", "[" + Thread.currentThread() + 
			"]:getBulk operation on " + agent.getMibName());
            	}
            	agent.getBulk(createMibRequest(varBind,version,data), 
				  nonRepeat, maxRepeat);
	    } finally {
                ThreadContext.restore(oldContext);
            }  
	    /* end of NPCTE fix for bugId 4492741 */
     
        } catch(SnmpStatusException x) {
            errorStatus = x.getStatus() ;
            errorIndex=  x.getErrorIndex();
            if (isDebugOn()) {
                debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
            }
        }
        catch(Exception x) {
            errorStatus = SnmpDefinitions.snmpRspGenErr ;
            if (isDebugOn()) {
                debug("run", "[" + Thread.currentThread() + "]:an generic error occured during the operation");
            }
        }
        if (isTraceOn()) {
            trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    /**
     * The method updates the varbind list of the subrequest and the non repeater
     */
    protected  void updateRequestNonRepeater(SnmpVarBind var, int pos) {
        updateRequest(var, pos);
        nonRepeat ++;
    }
  
    /**
     * The method updates a given var bind list with the result of a 
     * previsouly invoked operation.
     * Prior to calling the method, one must make sure that the operation was
     * successful. As such the method getErrorIndex or getErrorStatus should be
     * called.
     */
    protected void updateResult(SnmpVarBind[] result) {
   
        // we can assume that the run method is over ...
        // 
        SnmpVarBind element;
        Enumeration e= varBind.elements();
    
        // First go through all the values once ...
        for(int i=0; i < size; i++) {
            // May be we should control the position ...
            //
            if (e.hasMoreElements() ==false)
                return;
            element= (SnmpVarBind) e.nextElement();
            result[translation[i]]= element;
        }
    
        // Now update the values which have been repeated
        // more than once.
        int localR= size - nonRepeat;
        int max= result.length;
        for (int i = 2 ; i <= maxRepeat ; i++) {
            for (int r = 0 ; r < localR ; r++) {
                int pos = (i-1)* globalR + translation[nonRepeat + r] ;
                if (pos >= max)
                    return;
                if (e.hasMoreElements() ==false)
                    return;
                element= (SnmpVarBind) e.nextElement();
                result[pos]= element;
            }
        }

    }
  
    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }
    
    // PROTECTED VARIABLES
    //------------------

    /**
     * Specific to the sub request
     */
    protected int nonRepeat=0;
  
    protected int maxRepeat=0;
  
    /**
     * R as defined in RCF 1902 for the global request the sub-request is associated to.
     */
    protected int globalR=0;

    protected int size=0;
}
