/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;

class SnmpTimerServer
extends Thread {
    boolean isBeingDestroyed = false;
    String dbgTag = "SnmpTimerServer";
    SnmpQManager snmpq = null;
    private SnmpRequest req = null;

    public SnmpTimerServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpTimerServer");
        this.setName(this.dbgTag);
        this.snmpq = snmpQManager;
        this.start();
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (this.isTraceOn()) {
            this.trace("run", "Timer Thread started");
        }
        while (true) {
            try {
                do {
                    if (this.isTraceOn()) {
                        this.trace("run", "Blocking for requests");
                    }
                    if (this.req == null) {
                        this.req = this.snmpq.getTimeoutRequests();
                    }
                    if (this.req == null || !this.req.inProgress()) continue;
                    if (this.isTraceOn()) {
                        this.trace("run", "Handle Timeout Request " + this.req.getRequestId());
                    }
                    this.req.action();
                    this.req = null;
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", exception.getMessage());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Timer server unexpectedly shutting down");
                    this.debug("run", threadDeath);
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isDebugOn()) {
                    this.debug("run", "Received OutOfMemory");
                }
                Thread.yield();
                continue;
            }
            catch (Error error) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Received Internal error");
                this.debug("run", error);
                continue;
            }
            break;
        }
    }

    public synchronized void stopTimerServer() {
        block2: {
            if (!this.isAlive()) break block2;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

