/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

class ActualDiscovery
extends DiscoveryCommon {
    private boolean PointToPointResponse = true;
    private int RETURN_PORT_MIN_VAL = 1024;
    private int RETURN_PORT_MAX_VAL = this.RETURN_PORT_MIN_VAL * 10;
    private int ttl = 1;
    private int defaultTtl = 1;
    private int timeOut = 1000;
    private String timeStamp = null;
    public Vector returnValue = new Vector();

    public ActualDiscovery(String string, int n) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualDiscovery";
        if (this.isTraceOn()) {
            this.trace("constructor", "group = " + string + ", " + "port  = " + n);
        }
    }

    static /* synthetic */ String access$0(ActualDiscovery actualDiscovery) {
        return actualDiscovery.timeStamp;
    }

    public Vector findCommunicators(boolean bl, String string) throws IOException {
        return this.getObject(bl, string);
    }

    private void formatPdu(DiscoveryPDU discoveryPDU, boolean bl, String string, int n) {
        String string2;
        String string3 = new Long(new Date().getTime()).toString();
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "localHost";
        }
        this.timeStamp = String.valueOf(string2) + ":" + string3;
        discoveryPDU.setTimeStamp(String.valueOf(string2) + ":" + string3);
        discoveryPDU.setEmittedGroup(this.multicastGroup);
        if (this.getPointToPointResponse()) {
            if (this.isTraceOn()) {
                this.trace("formatPdu", "set return addr to " + this.localHost + ":" + n);
            }
            discoveryPDU.setReturnaddr(this.localHost, n);
        }
        discoveryPDU.setHost(string);
        discoveryPDU.setTimeOut(this.getTimeOut());
        discoveryPDU.setTimeToLive(this.getTimeToLive());
        discoveryPDU.setObjectRequired(bl);
    }

    private Vector getObject(boolean bl, String string) throws IOException {
        Thread thread;
        ReceivedMsgObj receivedMsgObj;
        block20: {
            this.returnValue = new Vector();
            DatagramSocket datagramSocket = null;
            int n = this.RETURN_PORT_MIN_VAL;
            InetAddress inetAddress = this.getLocalHostAddr();
            if (this.getPointToPointResponse()) {
                if (this.isTraceOn()) {
                    this.trace("getObject", " Create datagram socket for response");
                }
                while (n < this.RETURN_PORT_MAX_VAL) {
                    try {
                        datagramSocket = new DatagramSocket(n, inetAddress);
                        datagramSocket.setSoTimeout(this.getTimeOut());
                        break;
                    }
                    catch (BindException bindException) {
                        if (this.isDebugOn()) {
                            this.debug("getObject", " try port " + n);
                        }
                        ++n;
                    }
                }
                if (n == this.RETURN_PORT_MAX_VAL) {
                    throw new IOException("Address already in use");
                }
            } else {
                if (this.isTraceOn()) {
                    this.trace("getObject", "Use multicast socket for response");
                }
                datagramSocket = this;
            }
            if (this.isTraceOn()) {
                this.trace("getObject", "Format msg");
            }
            DiscoveryPDU discoveryPDU = new DiscoveryPDU();
            this.formatPdu(discoveryPDU, bl, string, n);
            if (this.isTraceOn()) {
                this.trace("getObject", "Create a thread to get responses");
            }
            receivedMsgObj = new ReceivedMsgObj(datagramSocket, this);
            thread = new Thread(receivedMsgObj);
            if (this.isTraceOn()) {
                this.trace("getObject", "Send the multicast query");
            }
            this.sendMsg(discoveryPDU, this.multicastGroup, this.multicastPort);
            thread.start();
            if (this.isTraceOn()) {
                this.trace("getObject", "Sleep before receiving");
            }
            try {
                Thread.sleep(this.getTimeOut());
            }
            catch (InterruptedException interruptedException) {
                if (!this.isDebugOn()) break block20;
                this.debug("getObject", interruptedException);
            }
        }
        if (this.isTraceOn()) {
            this.trace("getObject", "Stop receiving");
        }
        receivedMsgObj.stopRequested = true;
        Boolean bl2 = receivedMsgObj.interrupted;
        synchronized (bl2) {
            if (!receivedMsgObj.interrupted.booleanValue()) {
                thread.interrupt();
            }
        }
        return this.returnValue;
    }

    public boolean getPointToPointResponse() {
        return this.PointToPointResponse;
    }

    public int getTimeOut() {
        if (this.isTraceOn()) {
            this.trace("getTimeOut", "Value = " + this.timeOut);
        }
        return this.timeOut;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public void setPointToPointResponse(boolean bl) {
        if (this.isTraceOn()) {
            this.trace("setPointToPointResponse", "setPointToPointResponse to " + bl);
        }
        this.PointToPointResponse = bl;
    }

    public void setTimeOut(int n) throws IOException {
        if (this.isTraceOn()) {
            this.trace("setTimeOut", "set to " + n);
        }
        this.setSoTimeout(n);
        this.timeOut = n;
    }

    public void setTimeToLive(int n) throws IOException {
        try {
            super.setTimeToLive(n);
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("setTimeToLive", "Unable to set Time-to-live to " + n);
            }
            throw iOException;
        }
        if (this.isTraceOn()) {
            this.trace("Time-to-live", "Set Time-to-live to " + n);
        }
        this.ttl = n;
    }

    class ReceivedMsgObj
    implements Runnable {
        public Vector result = new Vector();
        public volatile boolean stopRequested = false;
        public Boolean interrupted = new Boolean(false);
        private ActualDiscovery discovery;
        private DatagramSocket socket;

        ReceivedMsgObj(DatagramSocket datagramSocket, ActualDiscovery actualDiscovery2) {
            this.socket = datagramSocket;
            this.discovery = actualDiscovery2;
        }

        private DiscoveryResponse TranslatePDU(ResponsePDU responsePDU) {
            DiscoveryResponse discoveryResponse = new DiscoveryResponse();
            discoveryResponse.host = responsePDU.getHost();
            discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
            discoveryResponse.specificationName = responsePDU.getSpecificationName();
            discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
            discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
            discoveryResponse.implementationName = responsePDU.getImplementationName();
            discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
            discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
            discoveryResponse.userData = responsePDU.getUserData();
            discoveryResponse.objectList = responsePDU.getObjectList();
            return discoveryResponse;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run() {
            block24: {
                var3_1 = 0;
                block13: while (true) {
                    while (!this.stopRequested) {
                        try {
                            var6_4 /* !! */  = ActualDiscovery.this.receiveMsg(this.socket);
                            if (var6_4 /* !! */  == null) {
                                if (!ActualDiscovery.this.isTraceOn()) continue block13;
                                ActualDiscovery.this.trace("receivedMsg", "Null msg - continue - ");
                                continue block13;
                            }
                            var1_2 = (ResponsePDU)var6_4 /* !! */ ;
                            if (ActualDiscovery.access$0(this.discovery).compareTo(var1_2.getTimeStamp()) != 0) {
                                if (!ActualDiscovery.this.isTraceOn()) continue block13;
                                ActualDiscovery.this.trace("receivedMsg", "Msg is not for us : local timeStamp = " + ActualDiscovery.access$0(this.discovery) + " ; receiced timeStamp =  " + var1_2.getTimeStamp());
                                continue block13;
                            }
                            var2_3 = this.TranslatePDU(var1_2);
                            this.discovery.returnValue.addElement(var2_3);
                            ++var3_1;
                            continue block13;
                        }
                        catch (InterruptedIOException v0) {
                            this.stopRequested = true;
                            if (!ActualDiscovery.this.isTraceOn()) continue block13;
                            ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                            ActualDiscovery.this.trace("receivedMsg", "Got " + var3_1 + " responses");
                            continue block13;
                        }
                        catch (InvalidClassException var6_5) {
                            if (!ActualDiscovery.this.isDebugOn()) continue block13;
                            ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                            ActualDiscovery.this.debug("receivedMsg", var6_5);
                            continue block13;
                        }
                        catch (ClassCastException var6_6) {
                            if (!ActualDiscovery.this.isDebugOn()) continue block13;
                            ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                            ActualDiscovery.this.debug("receivedMsg", var6_6);
                            continue block13;
                        }
                        catch (ClassNotFoundException var6_7) {
                            if (!ActualDiscovery.this.isDebugOn()) continue block13;
                            ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                            ActualDiscovery.this.debug("receivedMsg", var6_7);
                            continue block13;
                        }
                        catch (IOException var6_8) {
                            if (ActualDiscovery.this.isDebugOn()) ** break;
                            continue block13;
                            ActualDiscovery.this.debug("receivedMsg", "Not a response msg - continue ");
                            ActualDiscovery.this.debug("receivedMsg", var6_8);
                        }
                    }
                    break;
                }
                var5_10 = null;
                var6_4 /* !! */  = this.interrupted;
                synchronized (var6_4 /* !! */ ) {
                    this.interrupted = new Boolean(true);
                    Thread.currentThread();
                    Thread.interrupted();
                }
                if (ActualDiscovery.this.isTraceOn()) {
                    ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.trace("receivedMsg", "Got " + var3_1 + " responses");
                }
                if (this.discovery.getPointToPointResponse()) {
                    if (ActualDiscovery.this.isTraceOn()) {
                        ActualDiscovery.this.trace("receivedMsg", "Close datagram socket");
                    }
                    this.socket.close();
                }
                break block24;
                catch (Throwable var4_12) {
                    var5_11 = null;
                    var6_9 = this.interrupted;
                    synchronized (var6_9) {
                        this.interrupted = new Boolean(true);
                        Thread.currentThread();
                        Thread.interrupted();
                    }
                    if (ActualDiscovery.this.isTraceOn()) {
                        ActualDiscovery.this.trace("receivedMsg", "timeOut expiration");
                        ActualDiscovery.this.trace("receivedMsg", "Got " + var3_1 + " responses");
                    }
                    if (this.discovery.getPointToPointResponse()) {
                        if (ActualDiscovery.this.isTraceOn()) {
                            ActualDiscovery.this.trace("receivedMsg", "Close datagram socket");
                        }
                        this.socket.close();
                    }
                    throw var4_12;
                }
            }
        }
    }
}

