/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RemoteNotification;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class ServerNotificationDispatcher {
    public static final int NEW_CLIENT = 0;
    public static final int REMOTE_TERMINATE = 1;
    public static final int REGISTER_TO_MBEAN = 2;
    public static final int UNREGISTER_FROM_MBEAN = 3;
    public static final int GET_NOTIFICATIONS = 4;
    public static final int CLEAR_NOTIFICATIONS = 5;
    public static final int SET_PUSH_MODE = 6;
    public static final int SET_OVERFLOW_MODE = 7;
    public static final int GET_OVERFLOW_MODE = 8;
    public static final int SET_CACHE_SIZE = 9;
    public static final int GET_CACHE_SIZE = 10;
    public static final int SET_OVERFLOW_COUNT = 11;
    public static final int GET_OVERFLOW_COUNT = 12;
    private static String localClassName = "ServerNotificationDispatcher";
    private MBeanServer mbServer;
    private ServerNotificationHandlerInternal connector;
    private PushNotification pushNotif;
    private HashMap clientList = new HashMap();
    private static long localCounter = 0L;
    private boolean isTerminated = false;

    public ServerNotificationDispatcher(ServerNotificationHandlerInternal serverNotificationHandlerInternal, MBeanServer mBeanServer) throws IllegalArgumentException {
        if (serverNotificationHandlerInternal == null) {
            throw new IllegalArgumentException("It should specify a connector.");
        }
        if (mBeanServer == null) {
            throw new IllegalArgumentException("It should specify a MBeanServer.");
        }
        this.connector = serverNotificationHandlerInternal;
        this.mbServer = mBeanServer;
        this.pushNotif = new PushNotification();
        if (this.isTraceOn()) {
            this.trace("Constructor", "create a ServerNotificationDispatcher object.");
        }
    }

    protected Object[] clearNotifications(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("clearNotifications", "clear the notification cache.");
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) != null) {
            List list = clientInfo.notifLog;
            synchronized (list) {
                clientInfo.notifLog.clear();
            }
        }
        return new Object[0];
    }

    private void debug(String string, Exception exception) {
        Trace.send(2, 128, localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 128, localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, 128, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 128, string, string2, string3);
    }

    protected Object[] getCacheSize(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("getCacheSize", "Get the cache size of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.cache_size)};
        return objectArray2;
    }

    private static Long getID() {
        if (localCounter == Long.MAX_VALUE) {
            localCounter = 0L;
        }
        return new Long(localCounter++);
    }

    protected RemoteNotification[] getNotifications(Long l) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("getNotifications", "Send back all saved notification to the client " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        return clientInfo.getAllNotifs();
    }

    protected Object[] getOverflowCount(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("getOverflowCount", "Get the overflow count of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.overflow_count)};
        return objectArray2;
    }

    protected Object[] getOverflowMode(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("getOverflowMode", "Get the overflow mode of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.discard_mode)};
        return objectArray2;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 128);
    }

    private void isTerminated() {
        if (this.isTerminated) {
            throw new JMRuntimeException("This ServerNotificationDispatcher object has been terminated and is waiting to be destroyed.");
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 128);
    }

    protected Object[] newClientNotificationDispatcher(Object[] objectArray) {
        this.isTerminated();
        Long l = ServerNotificationDispatcher.getID();
        if (this.isTraceOn()) {
            this.trace("newClientNotificationDispatcher", "New client is coming, its id is " + l);
        }
        Object[] objectArray2 = this.clientList;
        synchronized (objectArray2) {
            this.clientList.put(l, new ClientInfo(l, (Integer)objectArray[0], (Integer)objectArray[1]));
        }
        objectArray2 = new Object[]{l};
        return objectArray2;
    }

    protected Object[] registerToMBean(Long l, ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException {
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("registerToMBean", "Add a remote listener from the client " + l + " to the mbean " + objectName.toString());
        }
        Object[] objectArray = new Object[1];
        ClientInfo clientInfo = (ClientInfo)this.clientList.get(l);
        if (clientInfo == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        objectArray[0] = clientInfo.addListener(objectName, notificationFilter);
        return objectArray;
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                objectArray2 = this.newClientNotificationDispatcher(objectArray);
                break;
            }
            case 1: {
                objectArray2 = this.remoteTerminate((Long)objectArray[0]);
                break;
            }
            case 2: {
                objectArray2 = this.registerToMBean((Long)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2]);
                break;
            }
            case 3: {
                objectArray2 = this.unregisterFromMBean((Long)objectArray[0], (Long)objectArray[1]);
                break;
            }
            case 4: {
                objectArray2 = this.getNotifications((Long)objectArray[0]);
                break;
            }
            case 5: {
                objectArray2 = this.clearNotifications(objectArray);
                break;
            }
            case 6: {
                objectArray2 = this.setPushMode((Long)objectArray[0], (Integer)objectArray[1], (ConnectorAddress)objectArray[2]);
                break;
            }
            case 7: {
                objectArray2 = this.setOverflowMode(objectArray);
                break;
            }
            case 8: {
                objectArray2 = this.getOverflowMode(objectArray);
                break;
            }
            case 9: {
                objectArray2 = this.setCacheSize(objectArray);
                break;
            }
            case 10: {
                objectArray2 = this.getCacheSize(objectArray);
                break;
            }
            case 11: {
                objectArray2 = this.setOverflowCount(objectArray);
                break;
            }
            case 12: {
                objectArray2 = this.getOverflowCount(objectArray);
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return objectArray2;
    }

    protected Object[] remoteTerminate(Long l) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("newClientNotificationDispatcher", "A client is leaving, its id is " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.remove(l)) != null) {
            clientInfo.terminate();
        }
        return new Object[0];
    }

    protected Object[] setCacheSize(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("setCacheSize", "Set the cache size of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        int n = (Integer)objectArray[1];
        Object[] objectArray2 = clientInfo.notifLog;
        synchronized (objectArray2) {
            if (clientInfo.notifLog.size() > n) {
                if (((Boolean)objectArray[2]).booleanValue()) {
                    clientInfo.overflow_count += clientInfo.notifLog.size() - n;
                    if (clientInfo.discard_mode == 10) {
                        int n2 = 0;
                        while (n2 < clientInfo.notifLog.size() - n) {
                            clientInfo.notifLog.remove(0);
                            ++n2;
                        }
                    } else if (clientInfo.discard_mode == 11) {
                        int n3 = clientInfo.notifLog.size() - 1;
                        while (n3 >= n) {
                            clientInfo.notifLog.remove(n3);
                            --n3;
                        }
                    }
                    clientInfo.cache_size = (Integer)objectArray[1];
                }
            } else {
                clientInfo.cache_size = (Integer)objectArray[1];
            }
        }
        objectArray2 = new Object[]{new Integer(clientInfo.cache_size)};
        return objectArray2;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mbServer = mBeanServer;
    }

    protected Object[] setOverflowCount(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("setOverflowCount", "Set the overflow count of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.overflow_count = (Integer)objectArray[1];
        return new Object[0];
    }

    protected Object[] setOverflowMode(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("setOverflowMode", "Set the overflow mode to " + (Integer)objectArray[1] + " for the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.discard_mode = (Integer)objectArray[1];
        return new Object[0];
    }

    protected Object[] setPushMode(Long l, Integer n, ConnectorAddress connectorAddress) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("setPushMode", "The client " + l + " asks to change push mode to " + n);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ClientInfo clientInfo2 = clientInfo;
        synchronized (clientInfo2) {
            int n2 = n;
            if (clientInfo.forwardMode != n2) {
                if (n2 == 0) {
                    clientInfo.backConnector = this.connector.startPush(connectorAddress);
                    clientInfo.forwardMode = 0;
                    this.pushNotif.newNotif(clientInfo);
                } else if (n2 == 1) {
                    this.connector.stopPush(clientInfo.backConnector);
                    clientInfo.backConnector = null;
                }
                clientInfo.forwardMode = n2;
            }
        }
        return new Object[0];
    }

    public void terminate() {
        if (this.isTraceOn()) {
            this.trace("terminate", "the object is being terminated.");
        }
        this.clientList.clear();
        this.isTerminated = true;
    }

    private void trace(String string, Exception exception) {
        Trace.send(1, 128, localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 128, localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, 128, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, string3);
    }

    protected Object[] unregisterFromMBean(Long l, Long l2) throws InstanceNotFoundException, ListenerNotFoundException {
        ClientInfo clientInfo;
        this.isTerminated();
        if (this.isTraceOn()) {
            this.trace("unregisterFromMBean", "Remove a remote listener " + l2 + " from the client " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.removeListener(l2);
        return new Object[0];
    }

    private class ClientInfo {
        public Long clientID;
        public int forwardMode = 1;
        public NotificationBackConnector backConnector;
        public List notifLog = Collections.synchronizedList(new ArrayList());
        public int cache_size;
        public int discard_mode;
        public int overflow_count = 0;
        private HashMap rliList = new HashMap();

        public ClientInfo(Long l, int n, int n2) {
            this.clientID = l;
            this.discard_mode = n;
            this.cache_size = n2;
        }

        public Long addListener(ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException {
            Long l = ServerNotificationDispatcher.getID();
            RemoteListenerInfo remoteListenerInfo = new RemoteListenerInfo(objectName, notificationFilter, l, this);
            ServerNotificationDispatcher.this.mbServer.addNotificationListener(objectName, remoteListenerInfo, notificationFilter, null);
            this.rliList.put(l, remoteListenerInfo);
            return l;
        }

        public synchronized RemoteNotification[] getAllNotifs() {
            ArrayList arrayList = new ArrayList(this.notifLog.size());
            while (!this.notifLog.isEmpty()) {
                arrayList.add(this.notifLog.remove(0));
            }
            RemoteNotification[] remoteNotificationArray = new RemoteNotification[arrayList.size()];
            arrayList.toArray(remoteNotificationArray);
            return remoteNotificationArray;
        }

        public synchronized void removeListener(Long l) throws InstanceNotFoundException, ListenerNotFoundException {
            RemoteListenerInfo remoteListenerInfo = (RemoteListenerInfo)this.rliList.remove(l);
            if (remoteListenerInfo == null) {
                throw new ListenerNotFoundException("The listener does not find.");
            }
            ServerNotificationDispatcher.this.mbServer.removeNotificationListener(remoteListenerInfo.mbean, remoteListenerInfo);
        }

        public void terminate() {
            block9: {
                if (this.forwardMode == 0) {
                    try {
                        ServerNotificationDispatcher.this.connector.stopPush(this.backConnector);
                    }
                    catch (Exception exception) {
                        if (!ServerNotificationDispatcher.this.isDebugOn()) break block9;
                        ServerNotificationDispatcher.this.debug("ClientInfo", "terminate", exception);
                    }
                }
            }
            this.backConnector = null;
            HashMap hashMap = this.rliList;
            synchronized (hashMap) {
                Iterator iterator = this.rliList.values().iterator();
                while (iterator.hasNext()) {
                    RemoteListenerInfo remoteListenerInfo = (RemoteListenerInfo)iterator.next();
                    try {
                        ServerNotificationDispatcher.this.mbServer.removeNotificationListener(remoteListenerInfo.mbean, remoteListenerInfo);
                    }
                    catch (Exception exception) {
                        if (!ServerNotificationDispatcher.this.isDebugOn()) continue;
                        ServerNotificationDispatcher.this.debug("ClientInfo", "terminate", exception);
                    }
                }
            }
            this.notifLog.clear();
            this.rliList.clear();
        }
    }

    private class RemoteListenerInfo
    implements NotificationListener {
        public ObjectName mbean;
        public NotificationFilter filter;
        public Long listenerID;
        private ClientInfo client;

        public RemoteListenerInfo(ObjectName objectName, NotificationFilter notificationFilter, Long l, ClientInfo clientInfo) {
            this.mbean = objectName;
            this.filter = notificationFilter;
            this.listenerID = l;
            this.client = clientInfo;
        }

        public void handleNotification(Notification notification, Object object) {
            Object object2;
            if (ServerNotificationDispatcher.this.isDebugOn()) {
                object2 = "Receive a notification for remote listener " + this.listenerID + " of the client " + this.client.clientID;
                ServerNotificationDispatcher.this.debug("RemoteListenerInfo", "handleNotification", (String)object2);
            }
            object2 = this.client.notifLog;
            synchronized (object2) {
                if (this.client.forwardMode == 1 && this.client.cache_size >= 0) {
                    if (this.client.notifLog.size() < this.client.cache_size) {
                        this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                    } else {
                        if (this.client.discard_mode == 10 && this.client.cache_size > 0) {
                            this.client.notifLog.remove(0);
                            this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                        }
                        ++this.client.overflow_count;
                    }
                } else {
                    this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                }
            }
            if (this.client.forwardMode == 0) {
                ServerNotificationDispatcher.this.pushNotif.newNotif(this.client);
            }
        }
    }

    private class PushNotification {
        private List waitingClientList = Collections.synchronizedList(new ArrayList());
        private TaskThread taskThread = null;
        private boolean tobeTerminated = false;

        public synchronized void newNotif(ClientInfo clientInfo) {
            if (!this.waitingClientList.contains(clientInfo)) {
                this.waitingClientList.add(clientInfo);
            }
            if (this.taskThread == null || !this.taskThread.isAlive()) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            boolean bl = true;
            this.taskThread = null;
        }

        private class TaskThread
        extends Thread {
            public TaskThread() {
                super("taskThread");
            }

            public void run() {
                while (!PushNotification.this.tobeTerminated) {
                    ClientInfo clientInfo = null;
                    Object[] objectArray = PushNotification.this.waitingClientList;
                    synchronized (objectArray) {
                        if (PushNotification.this.waitingClientList.isEmpty()) {
                            Object var3_4 = null;
                            break;
                        }
                        clientInfo = (ClientInfo)PushNotification.this.waitingClientList.remove(0);
                    }
                    try {
                        objectArray = clientInfo.getAllNotifs();
                        clientInfo.backConnector.remoteRequest(0, objectArray);
                    }
                    catch (Exception exception) {
                        if (!ServerNotificationDispatcher.this.isDebugOn()) continue;
                        ServerNotificationDispatcher.this.debug("TaskThread", "run", exception);
                    }
                }
            }
        }
    }
}

