/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.HttpSendInputStream;
import com.sun.jdmk.comm.HttpSendOutputStream;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

class HttpSendSocket
extends Socket {
    protected String host;
    protected int port;
    protected URL url;
    protected GenericHttpConnectorClient connector;
    protected URLConnection conn = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;

    public HttpSendSocket(String string, int n) throws IOException {
        this(string, n, new URL("http", string, n, "/"), null);
    }

    public HttpSendSocket(String string, int n, URL uRL, GenericHttpConnectorClient genericHttpConnectorClient) throws IOException {
        super((SocketImpl)null);
        this.host = string;
        this.port = n;
        this.url = uRL;
        this.connector = genericHttpConnectorClient;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress.getHostName(), n);
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getLocalPort() {
        return -1;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    public int getPort() {
        return this.port;
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public synchronized InputStream readNotify() throws IOException {
        int n;
        AuthSchemeInfo authSchemeInfo;
        this.outNotifier.deactivate();
        this.out.close();
        this.out = null;
        try {
            this.in = this.conn.getInputStream();
        }
        catch (IOException iOException) {
            throw new IOException("HTTP request failed");
        }
        String string = this.conn.getContentType();
        if (string == null || !this.conn.getContentType().equals("application/octet-stream")) {
            throw new IOException("HTTP request failed");
        }
        String string2 = this.conn.getHeaderField("WWW-Authenticate");
        if (string2 != null && this.connector.authSchemeInfoList != null && (authSchemeInfo = (AuthSchemeInfo)this.connector.authSchemeInfoList.get(Thread.currentThread())) != null) {
            authSchemeInfo.setChallenge(string2);
        }
        if ((n = ((HttpURLConnection)this.conn).getResponseCode()) == 401) {
            throw new UnauthorizedSecurityException("Unauthorized");
        }
        return this.in;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }

    public synchronized OutputStream writeNotify() throws IOException {
        String string;
        AuthSchemeInfo authSchemeInfo;
        if (this.conn != null) {
            throw new IOException("Attempt to write on HttpSendSocket after request has been sent");
        }
        this.conn = this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Accept", "application/octet-stream");
        this.conn.setRequestProperty("User-Agent", "JDMK4.2/Java2");
        this.conn.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.connector.authSchemeInfoList != null && (authSchemeInfo = (AuthSchemeInfo)this.connector.authSchemeInfoList.get(Thread.currentThread())) != null && (string = authSchemeInfo.getResponse()) != null) {
            this.conn.setRequestProperty("Authorization", string);
            authSchemeInfo.setResponse(null);
        }
        this.inNotifier.deactivate();
        this.in = null;
        this.out = this.conn.getOutputStream();
        return this.out;
    }
}

