/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.Timestamp;
import javax.management.snmp.manager.ReqRedirectSrv;
import javax.management.snmp.manager.RequestCounter;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpPollRequest;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequestHandler;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpSocket;
import javax.management.snmp.manager.SnmpTooBig;
import javax.management.snmp.manager.SnmpVarbindList;

public class SnmpRequest
implements Serializable,
SnmpDefinitions {
    private static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private static RequestCounter requestCounter = new RequestCounter();
    private SnmpPeer thePeer;
    private SnmpSession session;
    private SnmpRequestHandler callback = null;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    private ReqRedirectSrv proxy;
    private SnmpPduPacket requestPdu;
    private SnmpPduRequest responsePdu;
    private SnmpVarBind[] internalVarBind = null;
    private String reason = null;
    private int options = 7;
    private static final int CREATED_BY_USER = 1;
    private static final int CREATED_INTERNALLY = 2;
    private int mode = 1;
    private int numTries = 0;
    private int timeout = 5000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;
    SnmpVarBindList varBindList = null;
    Timestamp responseTimestamp = null;
    int errorStatus = 0;
    int errorIndex = 0;
    int command = 0;
    String dbgTag = "SnmpRequest";

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, int n) throws SnmpStatusException {
        this.session = snmpSession;
        this.thePeer = snmpPeer;
        this.callback = snmpRequestHandler;
        switch (n) {
            case 160: 
            case 161: 
            case 163: 
            case 165: 
            case 166: {
                this.command = n;
                break;
            }
            case 253: {
                this.command = 161;
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command. " + n);
            }
        }
        this.session.addRequest(this);
        this.setTimeout(this.thePeer.getTimeout());
    }

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, int n, int n2) throws SnmpStatusException {
        this(snmpSession, snmpPeer, snmpRequestHandler, 165);
        this.nonRepeaters = n;
        this.maxRepetitions = n2;
    }

    void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.numTries == 0) {
                    this.invokeOnReady();
                } else if (this.numTries < this.getMaxTries()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++this.numTries;
                if (this.isDebugOn()) {
                    this.debug("action", "Request hit out of memory situation...");
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public final boolean allowMultiplex() {
        return (this.options & 1) == 1;
    }

    public final void cancelRequest() {
        if (this.proxy != null) {
            ReqRedirectSrv reqRedirectSrv = this.proxy;
            this.proxy = null;
            reqRedirectSrv.cancel(this);
        }
        this.errorStatus = 225;
        this.stopRequest();
        this.deleteRequest();
        this.notifyClient();
    }

    private final synchronized SnmpPduPacket constructPduPacket() {
        SnmpPduPacket snmpPduPacket = null;
        Exception exception = null;
        try {
            if (this.command == 165) {
                SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                snmpPduBulk.nonRepeaters = this.nonRepeaters;
                snmpPduBulk.maxRepetitions = this.maxRepetitions;
                snmpPduPacket = snmpPduBulk;
            } else {
                SnmpPduRequest snmpPduRequest;
                snmpPduPacket = snmpPduRequest = new SnmpPduRequest();
                snmpPduPacket.type = this.command;
            }
            snmpPduPacket.version = this.command == 166 ? 1 : this.getParam().getProtocolVersion();
            snmpPduPacket.community = this.getParam().encodeAuthentication(this.command);
            snmpPduPacket.requestId = this.getRequestId();
            snmpPduPacket.varBindList = this.internalVarBind;
            if (this.isTraceOn()) {
                this.trace("constructPduPacket", "Packet built");
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            exception = snmpStatusException;
            this.errorStatus = 227;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception2) {
            exception = exception2;
            this.errorStatus = 242;
            this.reason = exception2.getMessage();
        }
        if (exception != null) {
            if (this.isDebugOn()) {
                this.debug("constructPduPacket", exception);
            }
            snmpPduPacket = null;
            this.queueResponse();
        }
        return snmpPduPacket;
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    final synchronized void deleteRequest() {
        this.session.deleteRequest(this);
    }

    public void finalize() {
        this.callback = null;
        this.varBindList = null;
        this.session = null;
        this.thePeer = null;
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
    }

    public boolean fixPduOnError() {
        return (this.options & 2) == 2 && this.command != 165;
    }

    public boolean fixTooBigError() {
        return (this.options & 4) == 4 && this.command != 165;
    }

    final synchronized boolean fixVarBindList(SnmpVarBind[] snmpVarBindArray, int n) {
        int n2 = n;
        SnmpVarBind snmpVarBind = null;
        if (this.isTraceOn()) {
            this.trace("fixVarBindList", "Fix Pdu at index " + n);
        }
        int n3 = 0;
        while (n3 < snmpVarBindArray.length) {
            if (snmpVarBindArray[n3] != null && --n < 0) break;
            ++n3;
        }
        if (n3 >= snmpVarBindArray.length) {
            this.reason = "Can't find variable binding with idx = " + n2;
            if (this.isDebugOn()) {
                this.debug("fixVarBindList", this.reason);
            }
            return false;
        }
        snmpVarBind = snmpVarBindArray[n3];
        snmpVarBindArray[n3] = null;
        switch (this.getCommand()) {
            case 160: {
                snmpVarBind.status = 4;
                break;
            }
            case 161: {
                snmpVarBind.status = 5;
                break;
            }
        }
        return true;
    }

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public final int getCommand() {
        return this.command;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final int getMaxRetry() {
        return this.getMaxTries();
    }

    public final int getMaxTries() {
        if (this.command == 163) {
            return 1;
        }
        return this.getPeer().getMaxTries();
    }

    public final synchronized int getNumTries() {
        return this.numTries;
    }

    public final int getOptions() {
        return this.options;
    }

    public final SnmpParameters getParam() {
        return this.thePeer.getSnmpParam();
    }

    public final SnmpPeer getPeer() {
        return this.thePeer;
    }

    public final synchronized long getPollTimestamp() {
        return this.prevPollTime;
    }

    final synchronized String getRequestCreationType() {
        switch (this.mode) {
            case 1: {
                return "UserCreated.";
            }
            case 2: {
                return "Internal_" + this.callback.getClass().getName();
            }
        }
        return "UnknownRequest????";
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    public final synchronized SnmpVarBindList getRequestVarBindList() {
        return this.varBindList;
    }

    public final synchronized SnmpVarbindList getRequestVbList() {
        return new SnmpVarbindList(this.varBindList);
    }

    public final synchronized SnmpVarBindList getResponseVarBindList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varBindList;
    }

    public final synchronized SnmpVarbindList getResponseVbList() {
        if (this.inProgress()) {
            return null;
        }
        return new SnmpVarbindList(this.varBindList);
    }

    public final synchronized int getRetryCount() {
        return this.getNumTries();
    }

    public final SnmpSession getSnmpSession() {
        return this.session;
    }

    final synchronized SnmpVarBindList getVarBindList() {
        return this.varBindList;
    }

    private void handleError(String string) {
        this.setRequestStatus(128);
        if (this.isDebugOn()) {
            this.debug("handleError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking error user defined callback...\n" + this.getVarBindList().varBindListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleError", "Exception generated by user callback");
                this.debug("handleError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleError", "OutOfMemory Error generated by user callback");
                this.debug("handleError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void handleInternalError(String string) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = string;
        }
        if (this.isDebugOn()) {
            this.debug("handleInternalError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarBindList().varBindListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "Exception generated by user callback");
                this.debug("handleInternalError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "OutOfMemory Error generated by user callback");
                this.debug("handleInternalError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void handleSuccess() {
        this.setRequestStatus(128);
        if (this.isTraceOn()) {
            this.trace("handleSuccess", "Invoking user defined callback...");
        }
        if (!(this instanceof SnmpPollRequest)) {
            this.deleteRequest();
        }
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "Exception generated by user callback");
                this.debug("handleSuccess", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "OutOfMemory Error generated by user callback");
                this.debug("handleSuccess", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleTimeout() {
        this.setRequestStatus(32);
        if (this.isDebugOn()) {
            this.debug("handleTimeout", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking timeout user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "Exception generated by user callback");
                this.debug("handleTimeout", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "OutOfMemory Error generated by user callback");
                this.debug("handleTimeout", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private boolean handleTooBigError() {
        if (!this.fixTooBigError()) {
            return false;
        }
        if (this.varBindList.size() < 2) {
            this.setErrorStatusAndIndex(232, 0);
            return false;
        }
        try {
            if (this.isTraceOn()) {
                this.trace("handleTooBigError", "Handling Too big error");
            }
            this.proxy = new SnmpTooBig(this, this.getVarBindList());
            return true;
        }
        catch (Exception exception) {
            this.reason = exception.getMessage();
            this.setErrorStatusAndIndex(240, 0);
            return false;
        }
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    private synchronized void initializeAndFire(long l) {
        this.responsePdu = null;
        this.requestPdu = null;
        this.reason = null;
        this.proxy = null;
        if (l == 0L) {
            this.startRequest(System.currentTimeMillis());
        } else {
            this.startRequest(l);
        }
        this.setErrorStatusAndIndex(0, 0);
    }

    private final void invokeOnReady() {
        if (this.requestPdu == null) {
            if (this.varBindList.size() > this.getPeer().getVarBindLimit()) {
                if (this.isDebugOn()) {
                    this.debug("invokeOnReady", "Attempt too big. varBindList exceeds max allowed for peer. Actual = " + this.varBindList.size() + " Allowed = " + this.getPeer().getVarBindLimit());
                }
                this.setErrorStatusAndIndex(231, 0);
                if (!this.handleTooBigError()) {
                    this.queueResponse();
                }
                return;
            }
            this.requestPdu = this.constructPduPacket();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    final void invokeOnResponse(Object object) {
        if (object != null) {
            if (object instanceof SnmpPduRequest) {
                this.responsePdu = (SnmpPduRequest)object;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    private final void invokeOnRetry() {
        this.invokeOnReady();
    }

    private final void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    public boolean isInternalRequest() {
        return this.mode == 2;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    private final synchronized void parsePduPacket(SnmpPduRequest snmpPduRequest) throws SnmpStatusException {
        if (snmpPduRequest == null) {
            return;
        }
        this.errorStatus = snmpPduRequest.errorStatus;
        this.errorIndex = snmpPduRequest.errorIndex;
        if (this.errorStatus == 0) {
            if (this.command == 165) {
                this.updateVarBindList(snmpPduRequest.varBindList);
            } else {
                this.updateInternalVarBindWithResult(this.command, snmpPduRequest.varBindList, snmpPduRequest.version);
            }
            this.responseTimestamp = new Timestamp();
            this.getVarBindList().setTimestamp(this.responseTimestamp);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        switch (this.errorStatus) {
            case 2: {
                if (!this.fixPduOnError()) break;
                if (this.fixVarBindList(this.internalVarBind, this.errorIndex)) {
                    if (this.getVarBindList().checkForUnspecifiedValue()) {
                        this.setErrorStatusAndIndex(230, 0);
                        break;
                    }
                    this.setErrorStatusAndIndex(0, 0);
                    break;
                }
                this.setErrorStatusAndIndex(240, 0);
                break;
            }
            case 1: {
                if (!this.fixTooBigError() || this.varBindList.size() <= 1) break;
                this.setErrorStatusAndIndex(231, 0);
                break;
            }
        }
        if (this.isTraceOn()) {
            this.trace("parsePduPacket", "received response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    final void processResponse() throws SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("processResponse", "errstatus = " + this.errorStatus);
        }
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            this.responsePdu = null;
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    if (this.handleTooBigError()) {
                        return;
                    }
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire(0L);
                    return;
                }
            }
            if (this.command != 163 && this.command != 165) {
                this.translateErrorIndex();
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = 226;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("processResponse", exception);
            }
            this.reason = exception.getMessage();
        }
        this.handleInternalError(this.reason);
    }

    private final void queueResponse() {
        this.getSnmpSession().addResponse(this);
    }

    private void schedulePoll() {
        this.numTries = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        SnmpQManager.getTheInstance().addRequest(this);
    }

    private boolean sendPdu() {
        try {
            this.responseTimestamp = null;
            this.responsePdu = null;
            SnmpPduFactory snmpPduFactory = this.thePeer.getPduFactory();
            SnmpMessage snmpMessage = snmpPduFactory.encodePdu(this.requestPdu, this.thePeer.getMaxSnmpPktSize());
            if (snmpMessage == null) {
                if (this.isDebugOn()) {
                    this.debug("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            int n = this.thePeer.getMaxSnmpPktSize();
            byte[] byArray = new byte[n];
            int n2 = snmpMessage.encodeMessage(byArray);
            if (this.isTraceOn()) {
                this.trace("sendPdu", "Dump : \n" + snmpMessage.printMessage());
            }
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (this.isDebugOn()) {
                this.debug("sendPdu", "Packet Overflow while building Request");
            }
            return this.handleTooBigError();
        }
        catch (IOException iOException) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", exception);
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = exception.getMessage();
        }
        return false;
    }

    final void sendPduPacket(byte[] byArray, int n) throws IOException {
        SnmpSocket snmpSocket;
        if (this.isTraceOn()) {
            this.trace("sendPduPacket", "Send to peer. " + this.thePeer.toString() + "Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
        }
        SnmpSocket snmpSocket2 = snmpSocket = this.getSnmpSession().getSocket();
        synchronized (snmpSocket2) {
            snmpSocket.sendPacket(byArray, n, this.thePeer.getDestAddr(), this.thePeer.getDestPort());
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final synchronized void setErrorStatusAndIndex(int n, int n2) {
        this.errorStatus = n;
        this.errorIndex = n2;
    }

    final void setInternalRequest() {
        this.mode = 2;
    }

    public final synchronized void setOptions(int n) {
        if (!this.inProgress()) {
            this.options = n;
            if (!this.fixPduOnError() || !this.fixTooBigError()) {
                this.options &= 0xFFFFFFFE;
            }
        }
    }

    final synchronized void setPreviousPollTimestamp(long l) {
        this.prevPollTime = l;
    }

    final void setProxyObject(ReqRedirectSrv reqRedirectSrv) {
        this.proxy = reqRedirectSrv;
    }

    final void setRequestSentTime(long l) {
        ++this.numTries;
        this.setPreviousPollTimestamp(l);
        this.waitTimeForResponse = this.prevPollTime + (long)this.timeout;
        this.setRequestStatus(5);
        if (this.isTraceOn()) {
            this.trace("setRequestSentTime", "Request Successfully sent");
        }
        SnmpQManager.getTheInstance().addWaiting(this);
    }

    final synchronized void setRequestStatus(int n) {
        this.reqState = n;
    }

    final synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    final synchronized void setVarBindList(SnmpVarBindList snmpVarBindList) {
        this.varBindList = snmpVarBindList;
        if (this.internalVarBind == null || this.internalVarBind.length != this.varBindList.size()) {
            this.internalVarBind = new SnmpVarBind[this.varBindList.size()];
        }
        this.varBindList.copyInto(this.internalVarBind);
    }

    public static String snmpErrorToString(int n) {
        switch (n) {
            case 0: {
                return "noError";
            }
            case 1: {
                return "tooBig";
            }
            case 2: {
                return "noSuchName";
            }
            case 3: {
                return "badValue";
            }
            case 4: {
                return "readOnly";
            }
            case 5: {
                return "genErr";
            }
            case 6: {
                return "noAccess";
            }
            case 7: {
                return "wrongType";
            }
            case 8: {
                return "wrongLength";
            }
            case 9: {
                return "wrongEncoding";
            }
            case 10: {
                return "wrongValue";
            }
            case 11: {
                return "noCreation";
            }
            case 12: {
                return "inconsistentValue";
            }
            case 13: {
                return "resourceUnavailable";
            }
            case 14: {
                return "commitFailed";
            }
            case 15: {
                return "undoFailed";
            }
            case 16: {
                return "authorizationError";
            }
            case 17: {
                return "notWritable";
            }
            case 18: {
                return "inconsistentName";
            }
            case 224: {
                return "reqTimeout";
            }
            case 225: {
                return "reqAborted";
            }
            case 226: {
                return "rspDecodingError";
            }
            case 227: {
                return "reqEncodingError";
            }
            case 228: {
                return "reqPacketOverflow";
            }
            case 229: {
                return "rspEndOfTable";
            }
            case 230: {
                return "reqRefireAfterVbFix";
            }
            case 231: {
                return "reqHandleTooBig";
            }
            case 232: {
                return "reqTooBigImpossible";
            }
            case 240: {
                return "reqInternalError";
            }
            case 241: {
                return "reqSocketIOError";
            }
            case 242: {
                return "reqUnknownError";
            }
            case 243: {
                return "wrongSnmpVersion";
            }
        }
        return "Unknown Error = " + n;
    }

    synchronized void start(SnmpVarBindList snmpVarBindList, long l) throws SnmpStatusException {
        this.start(snmpVarBindList, true, l);
    }

    synchronized void start(SnmpVarBindList snmpVarBindList, boolean bl, long l) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Request already in progress.");
        }
        switch (this.getCommand()) {
            case 163: {
                if (this.getParam().getProtocolVersion() == 1) {
                    this.options = 0;
                }
                if (bl) {
                    this.setVarBindList((SnmpVarBindList)snmpVarBindList.clone());
                    break;
                }
                this.setVarBindList(snmpVarBindList);
                break;
            }
            case 160: 
            case 161: 
            case 165: {
                if (bl) {
                    this.setVarBindList(snmpVarBindList.cloneWithoutValue());
                    break;
                }
                this.setVarBindList(snmpVarBindList);
                break;
            }
            case 166: {
                this.setVarBindList(snmpVarBindList);
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command.  Should never happen. ??!! " + this.getCommand());
            }
        }
        this.initializeAndFire(l);
    }

    private synchronized void startRequest(long l) {
        this.nextPollTime = l;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    static final String statusDescription(int n) {
        switch (n) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occured.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Request in createAndWait state";
            }
        }
        return "Unknown Request state.";
    }

    void stopRequest() {
        SnmpRequest snmpRequest = this;
        synchronized (snmpRequest) {
            this.setRequestStatus(16);
        }
        SnmpQManager.getTheInstance().removeRequest(this);
        snmpRequest = this;
        synchronized (snmpRequest) {
            this.requestId = 0;
        }
    }

    long timeRemainingForAction(long l) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - l;
            }
            case 5: {
                return this.waitTimeForResponse - l;
            }
        }
        return -1L;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(String.valueOf(this.tostring()) + " " + this.getRequestCreationType());
        if (this.isTraceOn()) {
            stringBuffer.append("\n" + this.thePeer.toString());
        }
        stringBuffer.append(" SnmpCmd = " + SnmpPduPacket.pduTypeToString(this.command));
        stringBuffer.append("  RequestOptions = " + this.options);
        return stringBuffer.toString();
    }

    private synchronized String tostring() {
        StringBuffer stringBuffer = new StringBuffer("RequestId = " + this.requestId);
        stringBuffer.append("   Status = " + SnmpRequest.statusDescription(this.reqState));
        stringBuffer.append("  Timeout/MaxTries/NumTries = " + this.timeout * this.numTries + "/" + this.getMaxTries() + "/" + this.numTries);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            stringBuffer.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            stringBuffer.append("\nNeverPolled");
        }
        stringBuffer.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return stringBuffer.toString();
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    final void translateErrorIndex() {
        if (!this.fixPduOnError()) {
            return;
        }
        SnmpVarBindList snmpVarBindList = this.getVarBindList();
        int n = snmpVarBindList.size();
        int n2 = 0;
        while (n2 < n) {
            if (!snmpVarBindList.getVarBindAt(n2).hasVarBindException()) {
                --this.errorIndex;
                if (this.errorIndex == 0) {
                    this.errorIndex = n2;
                    return;
                }
            }
            ++n2;
        }
    }

    private void updateInternalVarBindWithResult(int n, SnmpVarBind[] snmpVarBindArray, int n2) {
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return;
        }
        int n3 = 0;
        switch (n) {
            case 160: 
            case 163: 
            case 166: {
                int n4 = 0;
                while (n4 < this.internalVarBind.length && n3 < snmpVarBindArray.length) {
                    SnmpVarBind snmpVarBind = this.internalVarBind[n4];
                    if (snmpVarBind != null) {
                        SnmpVarBind snmpVarBind2 = snmpVarBindArray[n3];
                        snmpVarBind.setSnmpValue(snmpVarBind2.value);
                        if (n2 == 1) {
                            if (snmpVarBind.value.isNoSuchObjectValue()) {
                                snmpVarBind.status = 3;
                            } else if (snmpVarBind.value.isNoSuchInstanceValue()) {
                                snmpVarBind.status = 4;
                            } else if (snmpVarBind.value.isEndOfMibViewValue()) {
                                snmpVarBind.status = 5;
                            }
                        }
                        ++n3;
                    }
                    ++n4;
                }
                break;
            }
            case 161: {
                int n5 = 0;
                while (n5 < this.internalVarBind.length && n3 < snmpVarBindArray.length) {
                    SnmpVarBind snmpVarBind = this.internalVarBind[n5];
                    if (snmpVarBind != null) {
                        SnmpVarBind snmpVarBind3 = snmpVarBindArray[n3];
                        snmpVarBind.setSnmpValue(snmpVarBind3.value);
                        snmpVarBind.oid = snmpVarBind3.oid;
                        if (n2 == 1) {
                            if (snmpVarBind.value.isNoSuchObjectValue()) {
                                snmpVarBind.status = 3;
                            } else if (snmpVarBind.value.isNoSuchInstanceValue()) {
                                snmpVarBind.status = 4;
                            } else if (snmpVarBind.value.isEndOfMibViewValue()) {
                                snmpVarBind.status = 5;
                            }
                        }
                        ++n3;
                    }
                    ++n5;
                }
                break;
            }
        }
    }

    private void updateVarBindList(SnmpVarBind[] snmpVarBindArray) {
        this.varBindList = new SnmpVarBindList();
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[n];
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value);
            this.varBindList.addVarBind(snmpVarBind2);
            ++n;
        }
    }

    public final boolean waitForCompletion(long l) throws SnmpStatusException {
        if (!this.inProgress()) {
            return true;
        }
        if (this instanceof SnmpPollRequest) {
            throw new SnmpStatusException("Not supported for SnmpPollRequest objects");
        }
        if (this.session.thisSessionContext()) {
            SnmpRequestHandler snmpRequestHandler = this.callback;
            this.callback = null;
            this.session.waitForResponse(this, l);
            this.callback = snmpRequestHandler;
        } else {
            SnmpRequest snmpRequest = this;
            synchronized (snmpRequest) {
                SnmpRequestHandler snmpRequestHandler = this.callback;
                try {
                    this.callback = null;
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
                this.callback = snmpRequestHandler;
            }
        }
        return this.inProgress() ^ true;
    }
}

