/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.jdmk.comm.SnmpSubRequestHandler;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduBulk snmpPduBulk, int n, int n2) {
        super(snmpMibAgent, snmpPduBulk);
        this.nonRepeat = 0;
        this.maxRepeat = n;
        this.globalR = n2;
    }

    protected SnmpSubBulkRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduBulk snmpPduBulk, int n, int n2, int n3, boolean bl) {
        super(snmpMibAgent, snmpPduBulk, true);
        this.nonRepeat = n;
        this.maxRepeat = n2;
        this.globalR = n3;
    }

    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }

    public void run() {
        block9: {
            this.size = this.varBind.size();
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                }
                finally {
                    Object var3_3 = null;
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!this.isDebugOn()) break block9;
                this.debug("run", "[" + Thread.currentThread() + "]:an generic error occured during the operation");
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequestNonRepeater(SnmpVarBind snmpVarBind, int n) {
        this.updateRequest(snmpVarBind, n);
        ++this.nonRepeat;
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        SnmpVarBind snmpVarBind;
        Enumeration enumeration = this.varBind.elements();
        int n = 0;
        while (n < this.size) {
            if (!enumeration.hasMoreElements()) {
                return;
            }
            snmpVarBindArray[this.translation[n]] = snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            ++n;
        }
        int n2 = this.size - this.nonRepeat;
        int n3 = snmpVarBindArray.length;
        int n4 = 2;
        while (n4 <= this.maxRepeat) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = (n4 - 1) * this.globalR + this.translation[this.nonRepeat + n5];
                if (n6 >= n3) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                snmpVarBindArray[n6] = snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                ++n5;
            }
            ++n4;
        }
    }
}

