/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.OperationContext;
import com.sun.jdmk.Proxy;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocketFactory;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class GenericHttpConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler,
Serializable {
    private OperationContext operationContext = null;
    transient Hashtable authSchemeInfoList = null;
    transient GenericHttpConnectorAddress httpConnAddr = null;
    transient GenericHttpSocketFactory factory = null;
    private transient boolean connected = false;
    private transient boolean supportsOperationContext = false;
    private String mbeanServerId = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private transient ClassLoader classloader = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private GenericHttpNotificationReceiver notificationReceiver = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;

    public GenericHttpConnectorClient() {
        this.factory = this.getSocketFactory();
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) {
        var3_3 = 64;
        var4_4 = null;
        try {
            var4_4 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException v0) {}
        if (var2_2.length > 64) {
            var2_2 = var4_4.digest(var2_2);
        }
        var5_5 = new byte[64];
        var6_6 = new byte[64];
        var8_7 = 0;
        ** GOTO lbl21
        {
            var5_5[var8_7] = var2_2[var8_7];
            var6_6[var8_7] = var2_2[var8_7];
            ++var8_7;
            do {
                if (var8_7 < var2_2.length) continue block2;
                var5_5[var8_7] = 0;
                var6_6[var8_7] = 0;
                ++var8_7;
lbl21:
                // 2 sources

            } while (var8_7 < 64);
        }
        var8_7 = 0;
        while (var8_7 < 64) {
            v1 = var8_7;
            var5_5[v1] = (byte)(var5_5[v1] ^ 54);
            v2 = var8_7++;
            var6_6[v2] = (byte)(var6_6[v2] ^ 92);
        }
        var4_4.update(var5_5);
        var4_4.update(var1_1);
        var7_8 = var4_4.digest();
        var4_4.update(var6_6);
        var4_4.update(var7_8);
        var7_8 = var4_4.digest();
        var9_9 = new StringBuffer();
        var8_7 = 0;
        while (var8_7 < var7_8.length) {
            if ((var7_8[var8_7] & 255) < 16) {
                var9_9.append("0" + Integer.toHexString(var7_8[var8_7] & 255));
            } else {
                var9_9.append(Integer.toHexString(var7_8[var8_7] & 255));
            }
            ++var8_7;
        }
        return var9_9.toString();
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (this.isTraceOn()) {
            this.trace("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "addNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addProxy(Proxy proxy) {
        if (this.isTraceOn()) {
            this.trace("addProxy", "addProxy");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot add null proxy reference to this ConnectorClient");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.put(objectName, proxy);
        } else {
            this.proxyHandles.put(objectName, proxy);
        }
        try {
            proxy.setServer(this);
        }
        catch (AbstractMethodError abstractMethodError) {
            proxy.setRemoteMBeanServer(this);
        }
    }

    public void clearCache() {
        if (this.isTraceOn()) {
            this.trace("clearCache", "clearCache");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.clearCache();
    }

    public String connect(ConnectorAddress connectorAddress) {
        if (this.isTraceOn()) {
            this.trace("connect", "connect");
        }
        if (connectorAddress == null) {
            throw new IllegalArgumentException("mbeanServerAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("mbeanServerAddress must be an instance of GenericHttpConnectorAddress");
        }
        if (this.connected) {
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.httpConnAddr = (GenericHttpConnectorAddress)((GenericHttpConnectorAddress)connectorAddress).clone();
        AuthInfo authInfo = this.httpConnAddr.getAuthInfo();
        if (authInfo != null) {
            if (authInfo.getLogin() == null || authInfo.getPassword() == null) {
                throw new IllegalArgumentException("Login/Password cannot be null");
            }
            this.authSchemeInfoList = new Hashtable();
        }
        this.supportsOperationContext = this.supports("OperationContext");
        String string = null;
        try {
            string = this.getMBeanServerId2();
        }
        catch (UnauthorizedSecurityException unauthorizedSecurityException) {
            throw unauthorizedSecurityException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception, "Connection failed");
        }
        if (this.mbeanServerId != null) {
            if (!this.mbeanServerId.equals(string)) {
                throw new IllegalArgumentException("ConnectorClient trying to connect to a different RemoteMBeanServer");
            }
        } else {
            this.mbeanServerId = string;
        }
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        this.connected = true;
        return this.mbeanServerId;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray = new Object[]{"createMBean", string, objectName};
        return this.createMBeanWithoutLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray = new Object[]{"createMBeanLoader", string, objectName, objectName2};
        return this.createMBeanWithLoader(objectArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] objectArray2 = new Object[]{"createMBeanLoaderParams", string, objectName, objectName2, objectArray, stringArray};
        return this.createMBeanWithLoader(objectArray2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] objectArray2 = new Object[]{"createMBeanParams", string, objectName, objectArray, stringArray};
        return this.createMBeanWithoutLoader(objectArray2);
    }

    private ObjectInstance createMBeanWithLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private ObjectInstance createMBeanWithoutLoader(Object[] objectArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(objectArray);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private void debug(String string, String string2) {
        Trace.send(2, 3856, "GenericHttpConnectorClient", string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 3856, string, string2, string3);
    }

    public void disconnect() {
        if (this.isTraceOn()) {
            this.trace("disconnect", "disconnect");
        }
        if (this.connected) {
            this.notificationClientHandler.stopListening();
            this.heartbeatClientHandler.stopPinging(-1);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.httpConnAddr = null;
            this.authSchemeInfoList = null;
            this.connected = false;
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttribute", objectName, string};
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getAttributes", objectName, stringArray};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public int getCacheSize() {
        if (this.isTraceOn()) {
            this.trace("getCacheSize", "getCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getCacheSize();
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getClassForProxyMBean", "getClassForProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    public ClassLoader getClassLoader() {
        if (this.isTraceOn()) {
            this.trace("getClassLoader", "getClassLoader");
        }
        return this.classloader;
    }

    public String getDefaultDomain() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getDefaultDomain"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Set getGenericProxies(Set set) {
        if (this.isTraceOn()) {
            this.trace("getGenericProxies", "getGenericProxies");
        }
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        HashSet<GenericProxy> hashSet = new HashSet<GenericProxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getGenericProxy(objectInstance));
        }
        return hashSet;
    }

    public GenericProxy getGenericProxy(ObjectInstance objectInstance) {
        if (this.isTraceOn()) {
            this.trace("getGenericProxy", "getGenericProxy");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        GenericProxy genericProxy = (GenericProxy)this.genericHandles.get(objectInstance.getObjectName());
        if (genericProxy != null) {
            return genericProxy;
        }
        genericProxy = new GenericProxy(objectInstance);
        genericProxy.bind(this);
        return genericProxy;
    }

    public int getHeartBeatPeriod() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public int getHeartBeatRetries() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public Integer getMBeanCount() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanCount"};
        return (Integer)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getMBeanInfo", objectName};
        try {
            return (MBeanInfo)this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public ConnectorAddress getMBeanServerAddress() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerAddress", "getMBeanServerAddress");
        }
        if (!this.connected) {
            return null;
        }
        return this.httpConnAddr;
    }

    public String getMBeanServerId() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerId", "getMBeanServerId");
        }
        return this.mbeanServerId;
    }

    private String getMBeanServerId2() {
        Object[] objectArray = new Object[]{"getMBeanServerId"};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Mapper getMapper() {
        if (this.isTraceOn()) {
            this.trace("getMapper", "getMapper");
        }
        if (this.mapper == this.defaultMapper) {
            return null;
        }
        return this.mapper;
    }

    public int getMode() {
        if (this.isTraceOn()) {
            this.trace("getMode", "getMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getMode();
    }

    abstract GenericHttpNotificationReceiver getNotificationReceiver(GenericHttpConnectorClient var1, ClientNotificationDispatcher var2);

    public void getNotifications() {
        if (this.isTraceOn()) {
            this.trace("getNotifications", "getNotifications");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.getNotifications();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"getObjectInstance", objectName};
        return (ObjectInstance)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public int getOverflowCount() {
        if (this.isTraceOn()) {
            this.trace("getOverflowCount", "getOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowCount();
    }

    public int getOverflowMode() {
        if (this.isTraceOn()) {
            this.trace("getOverflowMode", "getOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowMode();
    }

    public int getPeriod() {
        if (this.isTraceOn()) {
            this.trace("getPeriod", "getPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getPeriod();
    }

    public Proxy getProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getProxyMBean", "getProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        Proxy proxy = (Proxy)this.proxyHandles.get(objectInstance.getObjectName());
        if (proxy != null) {
            return proxy;
        }
        String string = this.getClassForProxyMBean(objectInstance);
        Class<?> clazz = null;
        try {
            clazz = this.classloader == null ? Class.forName(string) : this.classloader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProxyMBeanInstantiationException(classNotFoundException);
        }
        try {
            Class[] classArray = new Class[]{objectInstance.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{objectInstance};
            proxy = (Proxy)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ProxyMBeanInstantiationException(exception, "Cannot create object " + clazz.toString());
        }
        proxy.bind(this);
        return proxy;
    }

    public Set getProxyMBeans(Set set) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getProxyMBeans", "getProxyMBeans");
        }
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        HashSet<Proxy> hashSet = new HashSet<Proxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getProxyMBean(objectInstance));
        }
        return hashSet;
    }

    abstract GenericHttpSocketFactory getSocketFactory();

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"invoke", objectName, string, objectArray, stringArray};
        try {
            return this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private Object invokeRemoteOperation(Object[] objectArray) throws Exception {
        Object object;
        Object object2;
        if (this.isTraceOn()) {
            object2 = (String)objectArray[0];
            this.trace("invokeRemoteOperation", (String)object2);
        }
        object2 = this.sendHttp(objectArray, false);
        try {
            object = this.readObjectValue((InputStream)object2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)object2).close();
            throw throwable;
        }
        ((InputStream)object2).close();
        return object;
    }

    private Object invokeRemoteOperationNoExceptions(Object[] objectArray) {
        try {
            return this.invokeRemoteOperationOnInstance(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new CommunicationException(instanceNotFoundException);
        }
    }

    private Object invokeRemoteOperationOnInstance(Object[] objectArray) throws InstanceNotFoundException {
        try {
            return this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public boolean isConnected() {
        if (this.isTraceOn()) {
            this.trace("isConnected", "isConnected");
        }
        return this.connected;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 3856);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isInstanceOf", objectName, string};
        Boolean bl = (Boolean)this.invokeRemoteOperationOnInstance(objectArray);
        return bl;
    }

    public boolean isRegistered(ObjectName objectName) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"isRegistered", objectName};
        Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
        return bl;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 3856);
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        Object[] objectArray = new Object[]{"pingHeartBeatServer", string, new Integer(n), new Integer(n2), l};
        return (String)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryMBeans", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"queryNames", objectName, queryExp};
        return (Set)this.invokeRemoteOperationNoExceptions(objectArray);
    }

    private Object readObjectValue(InputStream inputStream) throws Exception {
        Object object;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String string = (String)objectInputStream.readObject();
        if (this.isDebugOn()) {
            this.debug("readObjectValue", "Received object of type " + string);
        }
        if ((object = objectInputStream.readObject()) instanceof Exception && string.equals("Exception")) {
            throw (Exception)object;
        }
        return object;
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray2 = new Object[]{"remoteRequest", new Integer(n), objectArray};
        try {
            return (Object[])this.invokeRemoteOperation(objectArray2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (this.isTraceOn()) {
            this.trace("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isTraceOn()) {
            this.trace("removeNotificationListener", "removeNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    public void removeProxy(Proxy proxy) {
        if (this.isTraceOn()) {
            this.trace("removeProxy", "removeProxy");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot remove null proxy reference from this ConnectorClient");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.remove(objectName);
        } else {
            this.proxyHandles.remove(objectName);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private InputStream sendHttp(Object[] var1_1, boolean var2_2) throws Exception {
        if (this.authSchemeInfoList != null) {
            if (this.authSchemeInfoList.get(Thread.currentThread()) == null) {
                this.authSchemeInfoList.put(Thread.currentThread(), new AuthSchemeInfo("CRAM-MD5"));
            }
            if ((var3_3 = (AuthSchemeInfo)this.authSchemeInfoList.get(Thread.currentThread())) != null && (var4_4 = var3_3.getChallenge()) != null) {
                var5_5 = new String();
                try {
                    var4_4 = var4_4.substring((String.valueOf(var3_3.getAuthScheme()) + " ").length());
                    var6_7 = new BASE64Decoder().decodeBuffer((String)var4_4);
                    var7_8 = this.httpConnAddr.getAuthInfo().getLogin();
                    var8_11 = this.httpConnAddr.getAuthInfo().getPassword().getBytes();
                    var9_12 = this.HMAC_MD5(var6_7, (byte[])var8_11);
                    var10_13 = String.valueOf(var7_8) + " " + (String)var9_12;
                    var11_15 = 57;
                    var12_17 = null;
                    var13_19 = var10_13.length() / 57;
                    var14_20 = var10_13.length() % 57;
                    var15_21 = 0;
                    while (true) {
                        if (var15_21 >= var13_19) {
                            if (var14_20 > 0) {
                                var12_17 = var10_13.substring(var13_19 * 57);
                                var5_5 = String.valueOf(var5_5) + new BASE64Encoder().encode(var12_17.getBytes());
                            }
                            break;
                        }
                        var12_17 = var10_13.substring(var15_21 * 57, (var15_21 + 1) * 57);
                        var5_5 = String.valueOf(var5_5) + new BASE64Encoder().encode(var12_17.getBytes());
                        ++var15_21;
                    }
                }
                catch (IOException v0) {}
                var3_3.setResponse(String.valueOf(var3_3.getAuthScheme()) + " " + var5_5);
                var3_3.setChallenge(null);
            }
        }
        var3_3 = null;
        try {
            try {
                var3_3 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                var7_8 = var3_3.getOutputStream();
                var8_11 = new ByteArrayOutputStream();
                var9_12 = new ObjectOutputStream((OutputStream)var7_8);
                if (this.operationContext != null && this.supportsOperationContext) {
                    var9_12.writeObject(this.operationContext);
                }
                var10_14 = 0;
                while (true) {
                    if (var10_14 >= var1_1.length) {
                        var9_12.flush();
                        var7_8.flush();
                        var11_16 = new PushbackInputStream(var3_3.getInputStream());
                        var12_18 = var11_16.read();
                        if (var12_18 >= 0) {
                            var11_16.unread(var12_18);
                        }
                        var4_4 = var11_16;
                        var6_7 = null;
                        if (var3_3 == null) return var4_4;
                        ** break;
                    }
                    var9_12.writeObject(var1_1[var10_14]);
                    ++var10_14;
                }
            }
            catch (UnauthorizedSecurityException var7_9) {
                block27: {
                    if (this.authSchemeInfoList == null) throw var7_9;
                    if (var2_2) {
                        throw var7_9;
                    }
                    var4_4 = this.sendHttp(var1_1, true);
                    var6_7 = null;
                    if (var3_3 == null) return var4_4;
                    try {}
                    catch (Throwable var7_10) {
                        var8_11 = null;
                        var3_3 = null;
                        throw var7_10;
                    }
                    ** try [egrp 4[TRYBLOCK] [3 : 581->588)] { 
lbl74:
                    // 1 sources

                    var3_3.close();
                    break block27;
lbl76:
                    // 1 sources

                    catch (IOException v1) {
                    }
                }
                var8_11 = null;
                return var4_4;
            }
lbl81:
            // 1 sources

            try {
                try {
                    var3_3.close();
                }
                catch (IOException v2) {
                }
                var8_11 = null;
                return var4_4;
            }
            catch (Throwable var7_8) {
                var8_11 = null;
                var3_3 = null;
                throw var7_8;
            }
        }
        catch (Throwable var5_6) {
            block28: {
                var6_7 = null;
                if (var3_3 == null) throw var5_6;
                try {}
                catch (Throwable var7_8) {
                    var8_11 = null;
                    var3_3 = null;
                    throw var7_8;
                }
                ** try [egrp 4[TRYBLOCK] [3 : 581->588)] { 
lbl106:
                // 1 sources

                var3_3.close();
                break block28;
lbl108:
                // 1 sources

                catch (IOException v3) {
                }
            }
            var8_11 = null;
            var3_3 = null;
            throw var5_6;
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttribute", objectName, attribute};
        try {
            this.invokeRemoteOperation(objectArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"setAttributes", objectName, attributeList};
        return (AttributeList)this.invokeRemoteOperationOnInstance(objectArray);
    }

    public int setCacheSize(int n, boolean bl) throws JMRuntimeException {
        if (this.isTraceOn()) {
            this.trace("setCacheSize", "setCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.isTraceOn()) {
            this.trace("setClassLoader", "setClassLoader");
        }
        this.classloader = classLoader;
    }

    public void setHeartBeatPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public void setHeartBeatRetries(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void setMapper(Mapper mapper) {
        if (this.isTraceOn()) {
            this.trace("setMapper", "setMapper");
        }
        if (mapper == null) {
            mapper = this.defaultMapper;
        } else {
            this.mapper = mapper;
        }
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setMode", "setMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setMode(n);
    }

    public void setOperationContext(OperationContext operationContext) {
        try {
            if (operationContext != null) {
                operationContext = (OperationContext)operationContext.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CommunicationException(cloneNotSupportedException);
        }
        this.operationContext = operationContext;
    }

    public void setOverflowCount(int n) {
        if (this.isTraceOn()) {
            this.trace("setOverflowCount", "setOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowCount(n);
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setOverflowMode", "setOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowMode(n);
    }

    public void setPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setPeriod", "setPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setPeriod(n);
    }

    ConnectorAddress startPush() {
        if (this.isTraceOn()) {
            this.trace("startPush", "startPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("startPush", "Create new NotificationReceiver");
                }
                this.notificationReceiver = this.getNotificationReceiver(this, this.notificationClientHandler);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (Exception exception) {
                throw new CommunicationException(exception);
            }
        }
        if (this.isDebugOn()) {
            this.debug("startPush", "Start receiving events");
        }
        this.notificationReceiver.startListening();
        return this.notificationReceiver.getConnectorAddress();
    }

    void stopPush() {
        if (this.isTraceOn()) {
            this.trace("stopPush", "stopPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver != null) {
            this.notificationReceiver.stopListening();
        }
    }

    public boolean supports(String string) {
        Object[] objectArray = new Object[]{"supports", string};
        try {
            Boolean bl = (Boolean)this.invokeRemoteOperationNoExceptions(objectArray);
            return bl;
        }
        catch (CommunicationException communicationException) {
            return false;
        }
    }

    private void trace(String string, String string2) {
        Trace.send(1, 3856, "GenericHttpConnectorClient", string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 3856, string, string2, string3);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] objectArray = new Object[]{"unregisterMBean", objectName};
        try {
            this.invokeRemoteOperation(objectArray);
            this.proxyHandles.remove(objectName);
            this.genericHandles.remove(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private GenericHttpConnectorClient connector;

        public NotificationHandlerInternal(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private GenericHttpConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }
}

