/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientNotificationHandler;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.RemoteNotification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

class ClientNotificationDispatcher
implements ClientNotificationHandler {
    public static final int HANDLE_NOTIFICATION = 0;
    public static final int CONNECTOR_TEST = 1;
    private static String localClassName = "ClientNotificationDispatcher";
    private static int DEFAULT_TIME = 1000;
    private ClientNotificationHandlerInternal connector;
    private ConnectorAddress clientAddress = null;
    private Long remoteID;
    private int forwardPeriod = DEFAULT_TIME;
    private HashMap listenerList = new HashMap();
    private JobOfGetNotif jobOfGet = null;
    private ForwardNotifs forwardNotifs = new ForwardNotifs();
    private int forwardMode = 0;
    private int discardMode = 10;
    private int cacheSize = -1;
    private boolean isConnected = false;

    public ClientNotificationDispatcher(ClientNotificationHandlerInternal clientNotificationHandlerInternal) throws IllegalArgumentException {
        if (clientNotificationHandlerInternal == null) {
            throw new IllegalArgumentException("A connector should be specified.");
        }
        if (this.isTraceOn()) {
            this.trace("Constructor", "Create a new ClientNotificationDispatcher object.");
        }
        this.connector = clientNotificationHandlerInternal;
        this.setMode(0);
    }

    static /* synthetic */ int access$4() {
        return DEFAULT_TIME;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        this.connect();
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "Ask the server to add a listener.");
        }
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[]{this.remoteID, objectName, notificationFilter};
        try {
            objectArray = this.connector.remoteRequest(2, objectArray2);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw runtimeOperationsException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (JMRuntimeException jMRuntimeException) {
            throw jMRuntimeException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Long l = (Long)objectArray[0];
        this.listenerList.put(l, new ListenerInfo(objectName, notificationListener, notificationFilter, object, l));
    }

    protected Object[] backConnectorTest() {
        return new Object[0];
    }

    public void clearCache() {
        block4: {
            if (this.isTraceOn()) {
                this.trace("clearCache", "Ask the server to clear the notification cache.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            Object[] objectArray = new Object[]{this.remoteID};
            try {
                this.connector.remoteRequest(5, objectArray);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block4;
                this.debug("clearNotifications", exception);
            }
        }
    }

    protected synchronized void connect() {
        block7: {
            if (this.isConnected) {
                return;
            }
            if (this.isTraceOn()) {
                this.trace("connect", "Connecting to the server ...");
            }
            Object[] objectArray = new Object[]{new Integer(this.discardMode), new Integer(this.cacheSize)};
            Object[] objectArray2 = null;
            try {
                objectArray2 = this.connector.remoteRequest(0, objectArray);
                this.remoteID = (Long)objectArray2[0];
                if (this.isDebugOn()) {
                    this.debug("ClientNotificationDispatcher", "connect", "Id=" + this.remoteID);
                }
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block7;
                this.debug("ClientNotificationDispatcher", "connect", exception);
            }
        }
        this.internalSetMode(this.forwardMode);
        this.isConnected = true;
    }

    private void debug(String string, Exception exception) {
        Trace.send(2, 128, localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 128, localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, 128, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 128, string, string2, string3);
    }

    protected synchronized void disconnect() {
        block7: {
            if (!this.isConnected) {
                return;
            }
            if (this.isTraceOn()) {
                this.trace("disconnect", "Disconnecting with the server...");
            }
            Object[] objectArray = new Object[]{this.remoteID};
            try {
                this.connector.remoteRequest(1, objectArray);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block7;
                this.debug("disconnect", exception);
            }
        }
        if (this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {}
        this.listenerList.clear();
        this.isConnected = false;
    }

    protected void finalize() throws Throwable {
        this.listenerList.clear();
        this.disconnect();
        this.listenerList = null;
        super.finalize();
    }

    private ListenerInfo findListenerInfo(ObjectName objectName, NotificationListener notificationListener) {
        ListenerInfo listenerInfo = null;
        Iterator iterator = this.listenerList.values().iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo2 = (ListenerInfo)iterator.next();
            if (!objectName.equals(listenerInfo2.mbean) || notificationListener != listenerInfo2.listener) continue;
            listenerInfo = listenerInfo2;
            break;
        }
        return listenerInfo;
    }

    public int getCacheSize() {
        if (this.isTraceOn()) {
            this.trace("getCacheSize", "Ask the server to return the size of the cache.");
        }
        return this.cacheSize;
    }

    public int getMode() {
        return this.forwardMode;
    }

    public Long getNotificationClientId() {
        if (this.isConnected) {
            return this.remoteID;
        }
        return null;
    }

    public void getNotifications() {
        Object[] objectArray;
        block14: {
            if (this.isTraceOn()) {
                this.trace("getNotification", "A user asks to get all notifications.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            objectArray = null;
            try {
                Object[] objectArray2 = new Object[]{this.remoteID};
                objectArray = this.connector.remoteRequest(4, objectArray2);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block14;
                this.debug("getNotifications", exception);
            }
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                RemoteNotification remoteNotification = (RemoteNotification)objectArray[n];
                HashMap hashMap = this.listenerList;
                synchronized (hashMap) {
                    ListenerInfo listenerInfo = (ListenerInfo)this.listenerList.get(remoteNotification.id);
                    if (listenerInfo != null) {
                        try {
                            listenerInfo.listener.handleNotification(remoteNotification.notif, listenerInfo.handback);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                ++n;
            }
        }
    }

    public int getOverflowCount() {
        if (this.isTraceOn()) {
            this.trace("getOverflowCount", "Get the overflow count.");
        }
        int n = 0;
        if (this.isConnected) {
            Object[] objectArray;
            block6: {
                Object[] objectArray2 = new Object[]{this.remoteID};
                objectArray = null;
                try {
                    objectArray = this.connector.remoteRequest(12, objectArray2);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("getOverflowCount", exception);
                }
            }
            n = (Integer)objectArray[0];
        }
        return n;
    }

    public int getOverflowMode() {
        if (this.isTraceOn()) {
            this.trace("getOverflowMode", "Get the overflow mode.");
        }
        return this.discardMode;
    }

    public int getPeriod() {
        return this.forwardPeriod;
    }

    protected synchronized void internalSetMode(int n) {
        block12: {
            Object[] objectArray;
            Object[] objectArray2 = null;
            if (n == 0) {
                this.clientAddress = this.connector.startPush();
                objectArray2 = objectArray = new Object[]{this.remoteID, new Integer(0), this.clientAddress};
            } else if (n == 1) {
                objectArray2 = objectArray = new Object[]{this.remoteID, new Integer(1), null};
            }
            try {
                this.connector.remoteRequest(6, objectArray2);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block12;
                this.debug("internalSetMode", exception);
            }
        }
        if (n == 1 && this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        if (n == 0) {
            try {
                this.jobOfGet.terminate();
                this.jobOfGet = null;
            }
            catch (Exception exception) {}
        }
        if (!(n != 1 || this.forwardPeriod <= 0 || this.jobOfGet != null && this.jobOfGet.isAlive())) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
        this.forwardMode = n;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 128);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 128);
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                this.forwardNotifs.addNotifs(objectArray);
                objectArray2 = new Object[]{};
                break;
            }
            case 1: {
                objectArray2 = this.backConnectorTest();
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return objectArray2;
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        block12: {
            if (this.isTraceOn()) {
                this.trace("removeNotificationListener", "Ask the server to remove a listener.");
            }
            if (objectName == null) {
                throw new InstanceNotFoundException("The MBean name doesn't correspond to a registered MBean.");
            }
            boolean bl = false;
            while (true) {
                ListenerInfo listenerInfo;
                if ((listenerInfo = this.findListenerInfo(objectName, notificationListener)) == null) {
                    if (bl) break;
                    throw new ListenerNotFoundException("Do not know your listener.");
                }
                bl = true;
                this.listenerList.remove(listenerInfo.id);
                if (!this.isConnected) continue;
                Object[] objectArray = new Object[]{this.remoteID, listenerInfo.id};
                Object[] objectArray2 = null;
                try {
                    objectArray2 = this.connector.remoteRequest(3, objectArray);
                }
                catch (Exception exception) {
                    if (exception instanceof InstanceNotFoundException) {
                        throw (InstanceNotFoundException)exception;
                    }
                    if (exception instanceof ListenerNotFoundException) {
                        throw (ListenerNotFoundException)exception;
                    }
                    if (exception instanceof CommunicationException) {
                        throw (CommunicationException)exception;
                    }
                    if (exception instanceof JMRuntimeException) {
                        throw (JMRuntimeException)exception;
                    }
                    if (!this.isDebugOn()) continue;
                    this.debug("removeNotificationListener", exception);
                }
            }
            if (this.listenerList.size() != 0) break block12;
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block12;
                this.debug("removeNotificationListener", exception);
            }
        }
    }

    public int setCacheSize(int n, boolean bl) {
        if (this.isTraceOn()) {
            this.trace("setCacheSize", "Ask the server to set size of the cache.");
        }
        if (this.isConnected) {
            Object[] objectArray;
            block7: {
                Object[] objectArray2 = new Object[]{this.remoteID, new Integer(n), new Boolean(bl)};
                objectArray = null;
                try {
                    objectArray = this.connector.remoteRequest(9, objectArray2);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block7;
                    this.debug("setCacheSize", exception);
                }
            }
            this.cacheSize = (Integer)objectArray[0];
        } else {
            this.cacheSize = n;
        }
        return this.cacheSize;
    }

    public synchronized void setMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The mode is illegal.");
        }
        if (this.isTraceOn()) {
            this.trace("setMode", "A user asks to set mode to " + n);
        }
        if (this.forwardMode != n) {
            this.forwardMode = n;
            if (this.isConnected) {
                this.internalSetMode(this.forwardMode);
            }
        }
    }

    public void setOverflowCount(int n) {
        block6: {
            if (this.isTraceOn()) {
                this.trace("setOverflowCount", "Set the overflow count.");
            }
            if (this.isConnected) {
                Object[] objectArray = new Object[]{this.remoteID, new Integer(n)};
                try {
                    this.connector.remoteRequest(11, objectArray);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("setOverflowCount", exception);
                }
            }
        }
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        block7: {
            if (this.isTraceOn()) {
                this.trace("setOverflowMode", "Set overflow mode.");
            }
            if (n != 11 && n != 10) {
                throw new IllegalArgumentException("Illegal overflow mode.");
            }
            if (this.isConnected) {
                Object[] objectArray = new Object[]{this.remoteID, new Integer(n)};
                try {
                    this.connector.remoteRequest(7, objectArray);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block7;
                    this.debug("setOverflowMode", exception);
                }
            }
        }
        this.discardMode = n;
    }

    public void setPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setPullPeriod", "A user asks to set pull period to " + n);
        }
        this.forwardPeriod = n;
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {}
        if (n > 0 && this.isConnected && this.forwardMode == 1) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
    }

    public synchronized void stopListening() {
        if (this.isTraceOn()) {
            this.trace("stopListening", "This object is stopping listening...");
        }
        this.listenerList.clear();
        try {
            this.disconnect();
        }
        catch (Exception exception) {}
    }

    private void trace(String string, Exception exception) {
        Trace.send(1, 128, localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 128, localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, 128, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, string3);
    }

    private class ForwardNotifs {
        private TaskThread taskThread = null;
        private List notifList = Collections.synchronizedList(new ArrayList());

        static /* synthetic */ TaskThread access$2(ForwardNotifs forwardNotifs) {
            return forwardNotifs.taskThread;
        }

        public synchronized void addNotifs(Object[] objectArray) {
            this.notifList.add((RemoteNotification[])objectArray);
            if (this.taskThread == null) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            if (this.taskThread != null) {
                this.taskThread.toBeTerminated = true;
            }
        }

        private class TaskThread
        extends Thread {
            boolean toBeTerminated = false;

            public TaskThread() {
                super("taskThread");
                this.setDaemon(true);
            }

            public void run() {
                while (!this.toBeTerminated) {
                    RemoteNotification[] remoteNotificationArray = null;
                    Object object = ForwardNotifs.this.notifList;
                    synchronized (object) {
                        if (ForwardNotifs.this.notifList.isEmpty()) {
                            Object var3_6 = null;
                            break;
                        }
                        remoteNotificationArray = (RemoteNotification[])ForwardNotifs.this.notifList.remove(0);
                    }
                    if (remoteNotificationArray == null) continue;
                    object = ClientNotificationDispatcher.this.listenerList;
                    synchronized (object) {
                        int n = 0;
                        while (n < remoteNotificationArray.length) {
                            block14: {
                                ListenerInfo listenerInfo = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(remoteNotificationArray[n].id);
                                if (listenerInfo == null) {
                                    if (ClientNotificationDispatcher.this.isDebugOn()) {
                                        ClientNotificationDispatcher.this.debug("forwardNotif", "Receive a notification not waited.");
                                    }
                                } else {
                                    try {
                                        listenerInfo.listener.handleNotification(remoteNotificationArray[n].notif, listenerInfo.handback);
                                    }
                                    catch (Exception exception) {
                                        if (!ClientNotificationDispatcher.this.isDebugOn()) break block14;
                                        ClientNotificationDispatcher.this.debug("forwardNotif", exception);
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                }
                ForwardNotifs.this.taskThread = null;
            }
        }
    }

    private class ListenerInfo {
        public ObjectName mbean;
        public NotificationListener listener = null;
        public NotificationFilter filter;
        public Object handback;
        public int time = ClientNotificationDispatcher.access$4();
        public Long id;

        public ListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Long l) {
            this.mbean = objectName;
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
            this.id = l;
        }
    }

    private class JobOfGetNotif
    extends Thread {
        boolean tobeTerminated = false;

        public JobOfGetNotif() {
            this.setDaemon(true);
        }

        public void run() {
            if (ClientNotificationDispatcher.this.isTraceOn()) {
                ClientNotificationDispatcher.this.trace("JobOfGetNotif", "run", "Start pulling...");
            }
            while (!this.tobeTerminated && ClientNotificationDispatcher.this.forwardPeriod > 0) {
                RemoteNotification[] remoteNotificationArray = null;
                try {
                    Thread.sleep(ClientNotificationDispatcher.this.forwardPeriod);
                    if (this.tobeTerminated || ClientNotificationDispatcher.this.forwardPeriod <= 0) break;
                    Object[] objectArray = new Object[]{ClientNotificationDispatcher.this.remoteID};
                    remoteNotificationArray = (RemoteNotification[])ClientNotificationDispatcher.this.connector.remoteRequest(4, objectArray);
                }
                catch (Exception exception) {
                    if (this.tobeTerminated) {
                        if (!ClientNotificationDispatcher.this.isDebugOn()) break;
                        ClientNotificationDispatcher.this.debug("JobOfGetNotif", "run", "Disconnected");
                        break;
                    }
                    if (!ClientNotificationDispatcher.this.isDebugOn()) continue;
                    ClientNotificationDispatcher.this.debug("JobOfGetNotif", "run", exception);
                    continue;
                }
                if (remoteNotificationArray == null) continue;
                int n = 0;
                while (n < remoteNotificationArray.length) {
                    RemoteNotification remoteNotification = remoteNotificationArray[n];
                    HashMap hashMap = ClientNotificationDispatcher.this.listenerList;
                    synchronized (hashMap) {
                        block11: {
                            try {
                                ListenerInfo listenerInfo = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(remoteNotification.id);
                                listenerInfo.listener.handleNotification(remoteNotification.notif, listenerInfo.handback);
                            }
                            catch (Exception exception) {
                                if (!ClientNotificationDispatcher.this.isDebugOn()) break block11;
                                ClientNotificationDispatcher.this.debug("JobOfGetNotif", "run", exception);
                            }
                        }
                    }
                    ++n;
                }
            }
        }

        public void terminate() {
            if (ClientNotificationDispatcher.this.isTraceOn()) {
                ClientNotificationDispatcher.this.trace("JobOfGetNotif", "terminate", "Stop pulling...");
            }
            this.tobeTerminated = true;
        }
    }
}

