#pragma ident "@(#)ftiuser.h	1.27 08/07/02 SMI"
/*
	Copyright 08/07/02 Sun Microsystems, Inc. All Rights Reserved

	(c) Copyright 1991 Marben Produit.    All rights reserved
*/

#ifndef	_FTIUSER_H
#define	_FTIUSER_H

#ifdef  __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------**
**			General Constants			**
**--------------------------------------------------------------*/

#include	<sys/param.h>	/* used for MAXPATHLEN		*/
#define FTIMXDIR  MAXPATHLEN	/* MaXimum DIRectory Length    	*/
#define FTIMXSTR 128		/* MaX General Purpose Length	*/
#define FTIMXDAT 20		/* MaXimum Date and Time Length	*/
#define FTIMXDFD 128		/* MaXimum FTAM Diagnostic 	*/

/*--------------------------------------------------------------**
**			Remote Host Database Constants		**
**	should not be changed!					**
**--------------------------------------------------------------*/

#define FTIMXRHN  9  	/* MaXimum Host Name Length            	*/
#define FTIMXPSL 33 	/* MaXimum Presentation Selector Length	*/
#define FTIMXSSL 33 	/* MaXimum Session Selector Length    	*/
#define FTIMXTSL 33 	/* MaXimum Transport Selector Length   	*/
#define FTIMXNAL 41 	/* MaXimum Network Address Length      	*/
#define FTIMXATL 35     /* MaXimum AET Length                   */
#define FTIMXSBN 32 	/* MaXimum SuBnet Number               	*/


/*--------------------------------------------------------------**
**			Document Types 				**
**--------------------------------------------------------------*/

#define FTMDTUNO  0 		/* Document Type - UNknOwn	*/
#define FTMDTFT1  1 		/* FTAM_1  Document Type	*/
#define FTMDTFT2  2 		/* FTAM_1  Document Type	*/
#define FTMDTFT3  3 		/* FTAM_1  Document Type	*/
#define FTMDTNB9  9 		/* NBS_9   Document Type	*/
#define FTMDTIN1 10 		/* INTAP_1 Document Type	*/

/*--------------------------------------------------------------**
**			Override Parameters			**
**--------------------------------------------------------------*/

#define FTMOVNOC 0		/* NO Creation, Create Failure	*/
#define FTMOVSOF 1		/* Select Old File		*/
#define FTMOVDOA 2		/* Deleted and created OLD attr.*/
#define FTMOVDNA 3		/* Deleted and created NEW attr.*/

/*--------------------------------------------------------------**
**			Processing Mode				**
**--------------------------------------------------------------*/

#define FTMTMREP 0x20		/* REPLACE mode			*/
#define FTMTMEXT 0x10		/* EXTEND mode			*/

/*--------------------------------------------------------------**
**			Permitted Actions			**
**--------------------------------------------------------------*/

#define FTMPAREA 0x80		/* READ 			*/
#define FTMPAINS 0x40		/* INSERT			*/
#define FTMPAREP 0x20		/* REPLACE			*/
#define FTMPAEXT 0x10		/* EXTEND			*/
#define FTMPAERA 0x08		/* ERASE			*/
#define FTMPARAT 0x04		/* READ-ATTRIBUTE		*/
#define FTMPACAT 0x02		/* CHANGE ATTRIBUTE		*/
#define FTMPADEL 0x01		/* DELETE file			*/

/*--------------------------------------------------------------**
**			Universal Class Numbers			**
**--------------------------------------------------------------*/

#define FTMUCOCT 04  		/* OctetString    		*/
#define FTMUCPRT 19  		/* PrintableString		*/
#define FTMUCTXT 20  		/* TeletexString 		*/
#define FTMUCVXT 21  		/* VideotexString		*/
#define FTMUCIA5 22  		/* IA5String    		*/
#define FTMUCGRP 25  		/* GraphicString		*/
#define FTMUCVIS 26  		/* VisibleString		*/
#define FTMUCGEN 27  		/* GeneralString		*/

/*--------------------------------------------------------------**
**			String Significance			**
**--------------------------------------------------------------*/

#define FTMPDVAR  0  		/* variable 		        */
#define FTMPDFIX  1		/* fixed			*/
#define FTMPDNOT  2		/* not significant		*/

/*--------------------------------------------------------------**
**			Passwords Types				**
**--------------------------------------------------------------*/

#define FTIGraStr 0x00		/* Graphic String		*/
#define FTIOctStr 0x01		/* Octet String			*/

/*--------------------------------------------------------------**
**			Requested Attributes			**
**--------------------------------------------------------------*/

#define FTMAFNAME 0x80		/* read-filename		*/
#define FTMAPERAC 0x40		/*  " permitted-actions		*/
#define FTMACOTYP 0x20		/*  " contents_type		*/
#define FTMASTACC 0x10		/*  " storage-account		*/
#define FTMADTCRE 0x08		/*  " date and time of creation */
#define FTMADTLMO 0x04		/*  " date and time of last     *
			    	 *	modification		*/
#define FTMADTLRA 0x02		/*  " date and time of last 	*
				 *	read access		*/
#define FTMADTLAM 0x01		/*  " date and time of last	*
				 *	attribute modification	*/
#define FTMAIDLCR 0x80		/*  " identity of last creator	*/
#define FTMAIDLMO 0x40		/*  " identity of last modifier	*/
#define FTMAIDLRE 0x20		/*  " identity of last reader	*/
#define FTMAIDLAM 0x10		/*  " identity of last 		*
				 *	attribute modifier	*/
#define FTMAFAVAI 0x08		/*  " file availability		*/
#define FTMAFSIZE 0x04		/*  " filesize			*/
#define FTMAFFSIZ 0x02		/*  " future file size		*/
#define FTMAACCTL 0x01		/*  " access-control		*/
#define FTMALQUAL 0x80          /*  " legal qualifications      */

/*--------------------------------------------------------------**
**			Kernel Group Attributes (Masks)		**
**--------------------------------------------------------------*/

#define FTMAGKER0 (unsigned char)0xe0	/* kernel group byte 0	*/
#define FTMAGKER1 (unsigned char)0x04	/* 	        byte 1	*/
#define FTMAGKER2 (unsigned char)0x00	/* 		byte 2	*/

/*--------------------------------------------------------------**
**			Storage Group Attributes (Masks)	**
**--------------------------------------------------------------*/

#define FTMAGSTG0 (unsigned char)0xff	/* storage group byte 0	*/
#define FTMAGSTG1 (unsigned char)0xfe	/* 		byte 1	*/
#define FTMAGSTG2 (unsigned char)0x00	/* 		byte 2	*/

/*--------------------------------------------------------------**
**			File Availability			**
**--------------------------------------------------------------*/

#define FTMFAIMM  0x00		/* IMMEDIATE availability	*/

/*--------------------------------------------------------------**
**			Execution Mode				**
**--------------------------------------------------------------*/

#define FTIEXNBL 0		/* Execution mode: NON Blocking */
#define FTIEXBLK 1		/* Execution mode: BLOCKING     */

/*--------------------------------------------------------------**
**			Host State				**
**--------------------------------------------------------------*/

#define FTIHSOPE 1		/* Host State: OPEN		*/
#define FTIHSCLO 0		/* Host State: CLOSED		*/

/*--------------------------------------------------------------**
**			Recovery Mode				**
**--------------------------------------------------------------*/

#define FTIRMRON 1		/* Recovery Mode: Recovery ON	*/
#define FTIRMNOR 0		/* Recovery Mode: NO Recovery	*/

/*--------------------------------------------------------------**
**			Recovery Availability			**
**--------------------------------------------------------------*/

#define FTIRCAVA 1		/* Recovery AVAILABLE		*/
#define FTIRCNAV 0		/* Recovery NOT Available	*/

/*--------------------------------------------------------------**
**			More Indicator				**
**--------------------------------------------------------------*/

#define FTINOMO  0		/* NO MORE			*/
#define FTIMORE  1		/* MORE   			*/

/*--------------------------------------------------------------**
**			API Event Codes (multi-connections)	**
**--------------------------------------------------------------*/

#define FTINOEVT 0		/* NO EVENT received		*/
#define FTIEVABO 1		/* Event code: Abort		*/
#define FTIEVOPE 2		/* EVent code: Open		*/
#define FTIEVCLO 3		/* EVent code: Close		*/
#define FTIEVPUT 4		/* EVent code: Put		*/
#define FTIEVGET 5		/* EVent code: Get		*/
#define FTIEVCRE 6		/* EVent code: Create		*/
#define FTIEVDEL 7		/* EVent code: Delete		*/
#define FTIEVREN 8		/* EVent code: Rename		*/
#define FTIEVRAT 9		/* EVent code: Read Attribute	*/

/*--------------------------------------------------------------**
**			Execution Status			**
**--------------------------------------------------------------*/

#define FTISTNER 0		/* NO Error			*/
#define FTISTLOC 1		/* LOCAL or user error		*/
#define FTISTSYS 2		/* local SYSTEM error		*/
#define FTISTFTM 3		/* FTAM service or protocol err	*/
#define FTISTUFE 4		/* Unexpected FtAM event	*/
#define FTISTWAR 5		/* local WARNING		*/

/*--------------------------------------------------------------**
**			Error Types				**
**--------------------------------------------------------------*/

#define FTITYNRC 0		/* NOT Recoverable error	*/
#define FTITYRCO 1		/* RECOVERABLE     error	*/

/*--------------------------------------------------------------**
**			Error Connexion Status			**
**--------------------------------------------------------------*/

#define FTICNXON 1		/* CoNneXion ON			*/
#define FTICNXOF 0		/* CoNneXion OFF		*/

/*--------------------------------------------------------------**
**			Error Codes 				**
**--------------------------------------------------------------*/

#define FTIERIEV 1  /* FTI ERror, Incorrect Environment Variable */
#define FTIERNSU 2  /* FTI ERror, function Not SUpported         */
                    /*            on local host                  */
#define FTIERIPA 3  /* FTI ERror, Invalid PArameter              */
/*               4     not used                                  */
#define FTIERCNE 5  /* FTI ERror, Connection Not Established     */
#define FTIERCAE 6  /* FTI ERror, Connection Already Established */
#define FTIERLFR 7  /* FTI ERror, Local file name required       */
#define FTIERRFR 8  /* FTI ERror, Remote file name required      */
/*		 9     not used					 *
 *		 10    not used					 */
#define FTIERUHN 11 /* FTI ERror, Unknown host name              */
#define FTIEROLF 12 /* FTI ERror, Opening Local File             */
#define FTIERORF 13 /* FTI ERror, Opening Remote File            */
#define FTIERFCH 14 /* FTI ERror, Failed to Connect to remote    */
                    /*            host. Error connecting to host */
#define FTIERCLF 15 /* FTI ERror, Closing Local File             */
#define FTIERCRF 16 /* FTI ERror, Closing Remote File            */
#define FTIERSLF 17 /* FTI ERror, Sending Local File             */
#define FTIERRRF 18 /* FTI ERror, Receiving Remote File          */
#define FTIERFNA 19 /* FTI ERror, Function Not Available         */
                    /*            on remote host                 */
/*		 20    not used					 *
 *		 21    not used					 *
 *		 22    not used					 */
#define FTIERCRH 23 /* FTI ERror, Closing Remote Host            */
#define FTIERWHI 24 /* FTI ERror, Writing Host Information       */
#define FTIERRSF 25 /* FTI ERror, Reading Shadow File            */
#define FTIERRDS 26 /* FTI ERror, Reading Default Shadow File    */
/*		 27    not used					 *
 *		 28    not used					 */
#define FTIERIPN 29 /* FTI ERror, Invalid Path Name              */
#define FTIERRHI 30 /* FTI ERror, Reading Host Information       */
#define FTIERRLF 31 /* FTI ERror, Reading Local File             */
#define FTIERWLF 32 /* FTI ERror, Writing Local File             */
#define FTIERWSF 33 /* FTI ERror, Writing Shadow File            */
/*		 34    not used				         */
#define FTIERDRF 35 /* FTI ERror, Deleting Remote File           */
#define FTIERCTF 36 /* FTI ERror, Creating Remote File           */
#define FTIERRNF 37 /* FTI ERror, Renaming Remote File           */
#define FTIERRRA 38 /* FTI ERror, Reading Remote File Attributes */
/*		 39    not used				         */
#define FTIERIDT 40 /* FTI ERror, Invalid Document Type          */
/*		 41    not used				         */
#define FTIERHNR 42 /* FTI ERror, Host name required             */
/*		 43 - 50 not used				 */
#define FTIERUDH 51 /* FTI ERror, Unable to Delete Host          */
/*		 52    not used					 *
 *		 53    not used					 *
 *		 54    not used					 */
#define FTIERHIC 55 /* FTI ERror, Host is closed                 */
/*		 56 - 62 not used				 */
#define FTIERRDF 63 /* FTI ERror, Reading Remote File            */
/*		 64    not used					 *
 *		 65    not used					 */
#define FTIERSRF 66 /* FTI ERror, Selecting Remote File          */
#define FTIERDSF 67 /* FTI ERror, Deselecting Remote File        */
#define FTIERGID 68 /* FTI ERror, Getting transfer IDentifier    */
#define FTIERRTR 69 /* FTI ERror, Recovering TRansfer            */
#define FTIERCDK 70 /* FTI ERRor, Creating DocKet                */
#define FTIERWDK 71 /* FTI ERRor, Writing  DocKet                */
#define FTIERRDK 72 /* FTI ERror, Reading  Docket                */
#define FTIERDDK 73 /* FTI ERror, Deleting Docket                */

/*--------------------------------------------------------------**
**			Local (non-Unix) Errors			**
**--------------------------------------------------------------*/

#define ERRDTYP		1 /* Illegal document type parameters	*/
#define ERRMODE		2 /* Invalid mode in F-Open-ind		*/
#define ERRSUBSQ	3 /* Subsequent error			*/
#define ERRFNAME	4 /* No file name in F-Create-ind	*/
#define ERRCFNAME	5 /* No file name in F-ChAtt-ind	*/
#define ERRDTPABS       6 /* No composite attributes in		*
			   *		F-Create-ind		*/
#define ERRIOI          7 /* Unknown user (F-Init-ind)		*/
#define ERRUID          8 /* No user identity or cannot set	*
			   *	group id. or user id. or	*
			   *	cannot change directory		*/
#define ERRSRC          9 /* Invalid service class in F-Init-ind*/
#define ERRPSWD        10 /* Invalid password in F-Init-ind	*/
#define ERRDTTYP       11 /* Invalid Data Element type		*/
#define ERRDTINV       12 /* Invalid Universal Class		*/
#define ERRDTSZ        13 /* Invalid Data Element size		*/
#define ERRTIMEOUT     14 /* Time-out				*/
#define ERRRECLG       15 /* Invalid INTAP_1 record length	*/
#define ERRRDEOF       16 /* Cannot read at end of file		*/
#define ERRFADUI       17 /* FADU id. error in F-Read-ind 	*/
#define ERRLFADU       18 /* Cannot locate FADU          	*/
#define ERRTRFIL       19 /* Cannot truncate file       	*/
#define ERRSFNLG       20 /* File name too long          	*/
#define ERRDCTYP       21 /* Invalid document type       	*/
#define ERROVERW       22 /* Invalid overwrite parameter 	*/
#define ERRNODTY       23 /* No document type in F-Open-cnf	*/
#define ERRFTYPE       24 /* Unsupported Special local file type*/
#define ERRSTRLG       25 /* Invalid FTAM_1 or FTAM_2		*
			   *		string length		*/
#define ERRCHECK       26 /* Recovery error - Bad checkpoint	*/
#define ERRDOCK        27 /* Recovery error - Corrupted docket	*/
#define ERRNODOCK      28 /* Recovery error - No docket		*/
#define ERRRECPT       29 /* Recovery error - No recovery point */
#define ERRCONTYP      30 /* Recovery error - Content type	*
			   *		       inconsistent	*/
#define ERRUNSPEC      31 /* Recovery error - Unspecific	*/

/*--------------------------------------------------------------**
**			Warning Codes				**
**--------------------------------------------------------------*/

#define FTIWRINI         1 /* WaRning on INItialisation        	*/
#define FTIWRTRL        30 /* WaRning on Transfer List         	*/

/* local warnings */
/* Initialisation warnings */
#define WARINID 0x00000001 /* Init directory			*/
#define WARLOGD 0x00000002 /* Log  directory                   	*/
#define WARSHFD 0x00000004 /* Shf  directory                   	*/
#define WARRDBD 0x00000008 /* Rdb  directory                   	*/
#define WARTRFD 0x00000010 /* Trf  directory                   	*/
#define WARINIF 0x00000020 /* Init file                        	*/
#define WARTRFF 0x00000040 /* Transfer identifiers file        	*/
/* Tranfer List warnings */
#define WARNODA 0x00000001 /* NO Docket Available              	*/



/* GP RFE 4237506 19/04/99 begin */

/*--------------------------------------------------------------**
**			        Time-out state 	                **
**--------------------------------------------------------------*/

#define FTITIMEOUT 1  /* FTI inactivity time-out during transfer      */
#define FTINTIMEOUT 0 /* FTI not inactivity time-out during transfer */
#define FTIUSERAB 2   /* FTI abort transfer on user request */ 

typedef int (*ftiCallbackTp) (long,long,long,int);

/* GP RFE 4237506 19/04/99 end */


/*--------------------------------------------------------------**
**			Administrative Variables Structure	**
**--------------------------------------------------------------*/

typedef struct
{
  unsigned char	ftiinid[FTIMXDIR];	/* INIT Directory	*/
  unsigned char	ftilogd[FTIMXDIR];	/* LOG Files Directory	*/
  unsigned char	ftishfd[FTIMXDIR];	/* SHADOW Files Database*/
  unsigned char	ftirdbd[FTIMXDIR];	/* REMOTE HOSTS Database*/
  unsigned char	ftitrfd[FTIMXDIR];	/* Transfers Database	*/
  long		logid;        		/* Log File Identifier	*/
} ftiadmT, *ftiadmTp;

/*--------------------------------------------------------------**
**			Local Association Identifier Type 	**
**--------------------------------------------------------------*/

typedef long ftilaiT;
typedef ftilaiT *ftilaiTp;

/*--------------------------------------------------------------**
**			Execution Status Report Structure	**
**--------------------------------------------------------------*/

typedef struct
{
  int		status;			/* Execution Status	*/
  int		errcode;		/* Error Code		*/
  int		errtype;		/* Error Type		*/
  int		errcnxs;		/* Err Connexion Status */
  int		diag;			/* Diagnostic Code	*/
  unsigned char	ftamdfd[FTIMXDFD];	/* FTAM Diagnostic:	*
					 * 	Further Details */
} ftiesrT, *ftiesrTp;

/*--------------------------------------------------------------**
**			Document Type Parameters Structure	**
**--------------------------------------------------------------*/

typedef struct
{
  unsigned char	choice;			/* Qualifier             */
  short		class;			/* Universal Class Number*/
  long		length1;		/* Maximum String Length */
  long		length2;		/* String Length Signific*/
} ftidtpT, *ftidtpTp;

typedef ftidtpT dtparmT;		/* for upward compatib.	*/
typedef ftidtpTp dtparmTp;		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			Shadow Files Structure			**
**--------------------------------------------------------------*/

typedef struct 
{
  int		doctyp ;		/* document type number	*/
  unsigned char	peract[2] ;		/* permitted actions	*/
  long		keypos ;		/* key position (NBS6/7)*/
  ftidtpT	parm ;			/* document type param.	*/
} ftishfT, *ftishfTp ;

typedef ftishfT shfT;      		/* for upward compatib.	*/
typedef ftishfTp shfTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			Remote Host DataBase Structure		**
**--------------------------------------------------------------*/

typedef struct
{
  unsigned char	hostname[FTIMXRHN];	/* Remote host name	*/
  int		pstlen;			/* Pres. sel. length    */
  unsigned char pstsel[FTIMXPSL];	/* Pres. sel. value     */
  int		seslen;			/* Session sel. length  */
  unsigned char	sessel[FTIMXSSL];	/* Session sel. value	*/
  int		trslen;			/* Transport sel. length*/
  unsigned char	trssel[FTIMXTSL];	/* Transport sel. value	*/
  int		netlen;			/* Network addr. length	*/
  unsigned char netadd[FTIMXNAL];	/* Network addr. value	*/
  int		aetlen;			/* Appl.Ent.Title length*/
  unsigned char aetitle[FTIMXATL];	/* Appl.Ent.Title value */
  unsigned char subnet;			/* Subnet number	*/
  unsigned char state;			/* Remote host state	*/
} ftirdbT, *ftirdbTp;

typedef ftirdbT rdbT;      		/* for upward compatib.	*/
typedef ftirdbTp rdbTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			Bind (Connection) Structure		**
**--------------------------------------------------------------*/

typedef struct
{
  unsigned char hostname[FTIMXRHN];	/* Remote Host Name	*/
  unsigned char username[FTIMXSTR];	/* User Name		*
					 * (on remote host)	*/
  unsigned char password[FTIMXSTR];	/* User Password	*
					 * (on remote host)	*/
  unsigned char account[FTIMXSTR];	/* Account to be charged* 
					 * (on remote host)	*/
} ftibndT, *ftibndTp;

typedef ftibndT bndT;      		/* for upward compatib.	*/
typedef ftibndTp bndTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			File Transfer Structure			**
**--------------------------------------------------------------*/

typedef struct
{
  int		doctyp;			/* Document Type        */
  int		override;		/* Creation Override    */
  int		mode;			/* Transfer Mode        */
  unsigned char	accnt[FTIMXSTR];	/* Account Name         */
  unsigned char	locname[FTIMXDIR];	/* Local File Name      */
  unsigned char	remname[FTIMXDIR];	/* Remote File Name     */
  unsigned char	filpssd[FTIMXSTR];	/* File Password        */
  unsigned char	reqattri[3];		/* Requested Attributes	*/
                         		/* docparm of NBS_9     */
  unsigned char	dform;        		/* display format	*
					 * (temporary for NBS-9)*/
  int		frfadu;        		/* Start from FADU no.	*
						 (FTAM-2) */
  int		tofadu;        		/* Ending at FADU no.	*
					 *	 (FTAM-2)	*/
  unsigned char	fadui;         		/* FADU Id.		*/
  int		fadun;         		/* FADU No.		*/
  unsigned char	acsctx;        		/* Access Context	*/
  long		result;        		/* No. of bytes 	*
   					 * ( sent/received )	*/
  double	elapse;        		/* Elapsed Time		*/
  double	speed;         		/* Speed		*/
  int		recmode;       		/* Recovery Mode	*/
  int		trfid;        		/* Transfer Identifier	*/
  long		filsize;		/* Future file size	*/
} ftitrfT, *ftitrfTp;

/*--------------------------------------------------------------**
**			Create Structure			**
**--------------------------------------------------------------*/

typedef struct
{
 long		filsize;		/* Future file size	*/
 int		override;		/* Override parameter	*/ 
 int		doctyp;			/* Document type	*/
 int		avail;			/* File availability	*/
 unsigned char	peract[2];		/* Permitted actions (2)*/
 unsigned char	accnt[FTIMXSTR];	/* Account Name		*/
 unsigned char	filname[FTIMXDIR];	/* Remote File Name	*/
 unsigned char	filpssd[FTIMXSTR];	/* Create password	*/
 unsigned char	acctrl[FTIMXSTR];	/* Access ctrl elt. attr*/
 unsigned char	shfname[FTIMXDIR];	/* Create Shadow File	*/
} fticreT, *fticreTp;

typedef fticreT creT;      		/* for upward compatib.	*/
typedef fticreTp creTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			Delete Structure			**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	accnt[FTIMXSTR];	/* Account		*/
 unsigned char	filname[FTIMXDIR];	/* File name		*/
 unsigned char	filpssd[FTIMXSTR];	/* Delete password	*/
} ftidelT, *ftidelTp ;

typedef ftidelT delT;      		/* for upward compatib.	*/
typedef ftidelTp delTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			Rename Structure			**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	accnt[FTIMXSTR];	/* Account              */
 unsigned char	filname[FTIMXDIR];	/* File name            */
 unsigned char	filpssd[FTIMXSTR];	/* Change attr. password*/
 unsigned char	newname[FTIMXDIR];	/* New File name 	*/
} ftirenT, *ftirenTp ;

typedef ftirenT renT;      		/* for upward compatib.	*/
typedef ftirenTp renTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			File Read Attribute Structure		**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	accnt[FTIMXSTR];        /* Account		*/
 unsigned char	filname[FTIMXDIR];      /* File name		*/
 unsigned char	filpssd[FTIMXSTR];      /* Read attr. password	*/
 unsigned char	reqattri[3];            /* Requested attributes	*/
} ftiratT, *ftiratTp ;

typedef ftiratT ratT;      		/* for upward compatib.	*/
typedef ftiratTp ratTp;    		/* for upward compatib.	*/

/*--------------------------------------------------------------**
**			File Read Attribute Response Structure	**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	filname[FTIMXDIR];	/* File name		*/
 unsigned char	peract[2];		/* Permitted actions (2)*/
 int		doctyp;			/* Document type	*/
 ftidtpT	parmdoc;		/* Document type param.	*/
 unsigned char	accnt[FTIMXSTR];	/* Storage account	*/
 unsigned char	dtcreat[FTIMXDAT];	/* Date and Time of 	*
					 *	CREATION	*/
 unsigned char	dtlmodi[FTIMXDAT];	/* of LAST MODIFICATION */
 unsigned char	dtlracc[FTIMXDAT];	/* of LAST READ ACCESS	*/
 unsigned char	dtlatmo[FTIMXDAT];	/* of LAST ATTR. MODIF.	*/
 unsigned char	idcreat[FTIMXSTR];	/* Identity of CREATOR	*/
 unsigned char	idlmodi[FTIMXSTR];	/* of LAST MODIFIER	*/
 unsigned char	idlread[FTIMXSTR];	/* of LAST READER	*/
 unsigned char	idlatmo[FTIMXSTR];	/* of LAST ATTR.MODIFIER*/
 int		avail;			/* File availability    */
 long		filsize;		/* File size            */
 long		futfsize;		/* Future file size     */
 unsigned char	acctrl[FTIMXSTR];	/* Access ctrl elt.attr.*/
 unsigned char	legqua[FTIMXSTR];	/* Legal Qualification	*/
 unsigned char	priuse[FTIMXSTR];	/* Private use 		*/
} ftirasT, *ftirasTp ;

/*--------------------------------------------------------------**
**			Change Local Directory Name Structure	**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	dirname[FTIMXDIR];	/* directory to change to 
						(input)		*/
} ftilcdT, *ftilcdTp ;

/*--------------------------------------------------------------**
**			Change Remote Directory Name Structure	**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	dirname[FTIMXDIR];	/* directory to change to*/
} ftircdT, *ftircdTp ;

/*--------------------------------------------------------------**
**			Get Remote Directory Name Structure	**
**--------------------------------------------------------------*/

typedef struct
{
 unsigned char	dirname[FTIMXDIR];	/* directory name (OUT)	*/
} ftipwdT, *ftipwdTp ;

/*--------------------------------------------------------------**
**			Docket Structure (Recovery)		**
**--------------------------------------------------------------*/

typedef struct 
{					/* Structure docket	*/
 unsigned char	ir ;			/* 'i' / 'r'		*/
 int		id ;			/* Unique id		*/
 unsigned char	username[FTIMXSTR];	/* User name 		*
					 * ( on remote host )	*/
 unsigned char	locname[FTIMXDIR] ;	/* Local File Name	*/
 unsigned char	hostname[FTIMXRHN];	/* Remote host	name	*/
 long		cpi ;        		/* Last NOT ack checkpt	*/
 long		acpi ;			/* Last ack checkpt	*/
 unsigned char	act_state ;		/* Activity state :	*
					 * starting, in progress*
                       			 * data transfer end,	*
					 *	finished        */
 unsigned char	doctyp ;		/* Document type	*/
 long		result;			/* No. of bytes 	*
					 * ( sent / received )	*/
 double		elapse;			/* Elapsed Time		*/
 double		speed;			/* Speed		*/
} ftidockT, *ftidockTp ; 

#ifdef  __cplusplus
}
#endif

#endif	/* _FTIUSER_H */
