/*
	Copyright 03/04/03 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef	_WCHAR_ISO_SUNWCC_H
#define	_WCHAR_ISO_SUNWCC_H

#pragma ident "@(#)wchar_iso_SUNWCC.h	1.9  03/04/03 C++5.0"

#if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
  #ifndef _MBSTATET_H
    #define _MBSTATET_H
    typedef struct __mbstate_t {
      #if defined(_LP64)
        long    __filler[4];
      #else
        int     __filler[6];
      #endif
    } __mbstate_t;
  #endif  /* __MBSTATET_H */

  namespace std {
    typedef __mbstate_t     mbstate_t;
  }

#endif

#if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
  #include <stdio.h>
  #include <ctype.h>
  #include <stddef.h>
  #include <time.h>
#else
  #include <sys/isa_defs.h>
  #include <stdio_tag.h>
  #include <wchar_impl.h>
  #include <time.h>
  #include <sys/va_list.h>
#endif

extern "C" {

#ifndef NULL
  #if defined(_LP64)
    #define	NULL	0L
  #else
    #define	NULL	0
  #endif
#endif

#ifndef	WEOF
  #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
    #define	WEOF	(-1)
  #else
    #define	WEOF	((wint_t) (-1))
  #endif
#endif

#if (!(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4)))
  #ifndef	WCHAR_MAX
    #define	WCHAR_MAX	2147483647
  #endif
  #ifndef	WCHAR_MIN
    #define	WCHAR_MIN	(-2147483647-1)
  #endif
#endif


namespace std {

#if defined(_LP64)
  typedef	int	wint_t;
#else
  typedef	long	wint_t;
#endif

#if defined(_LP64) || defined(_I32LPx)
  typedef	unsigned long	size_t;
#else
  typedef	unsigned int	size_t;
#endif

#if defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 >= 4) && !defined(_FILEDEFED)
#define	_FILEDEFED
  typedef __FILE FILE;
#endif

#if !defined(__SunOS_5_5_1)
  #if defined(__SunOS_5_6)
    wint_t   fgetwc(FILE *);
    wchar_t* fgetws(wchar_t *, int, FILE *);
    wint_t   fputwc(wint_t, FILE *);
    int      fputws(const wchar_t *, FILE *);
    wint_t   ungetwc(wint_t, FILE *);
    wint_t   getwc(FILE *);
    wint_t   putwc(wint_t, FILE *);
  #else
    wint_t   fgetwc(__FILE *);
    wchar_t* fgetws(wchar_t *, int, __FILE *);
    wint_t   fputwc(wint_t, __FILE *);
    int      fputws(const wchar_t *, __FILE *);
    wint_t   ungetwc(wint_t, __FILE *);
    wint_t   getwc(__FILE *);
    wint_t   putwc(wint_t, __FILE *);
  #endif
#endif

#if !defined(__SunOS_5_5_1)
  wint_t getwchar(void);
  wint_t putwchar(wint_t);
#endif

double   wcstod(const wchar_t *, wchar_t **);
long     wcstol(const wchar_t *, wchar_t **, int);
unsigned long wcstoul(const wchar_t *, wchar_t **, int);
wchar_t* wcscat(wchar_t *, const wchar_t *);
const wchar_t* wcschr(const wchar_t*, wchar_t);
int      wcscmp(const wchar_t *, const wchar_t *);
int      wcscoll(const wchar_t *, const wchar_t *);
wchar_t* wcscpy(wchar_t *, const wchar_t *);
size_t   wcscspn(const wchar_t *, const wchar_t *);
size_t   wcslen(const wchar_t *);
wchar_t* wcsncat(wchar_t *, const wchar_t *, size_t);
int      wcsncmp(const wchar_t *, const wchar_t *, size_t);
wchar_t* wcsncpy(wchar_t *, const wchar_t *, size_t);
const wchar_t* wcspbrk(const wchar_t*, const wchar_t*);
const wchar_t* wcsrchr(const wchar_t*, wchar_t);
size_t   wcsspn(const wchar_t *, const wchar_t *);

int      wcswidth(const wchar_t *, size_t);
size_t   wcsxfrm(wchar_t *, const wchar_t *, size_t);
int      wcwidth(const wchar_t);

#if (!defined(_MSE_INT_H) && !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6))
  #if (defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4))
    wchar_t *wcstok(wchar_t *, const wchar_t *);
    size_t   wcsftime(wchar_t *, size_t, const char *, const struct tm *);
  #else
    #ifdef __PRAGMA_REDEFINE_EXTNAME
      wchar_t* wcstok(wchar_t *, const wchar_t *, wchar_t **);
      size_t   wcsftime(wchar_t *, size_t, const wchar_t *, const struct tm *);
      #pragma redefine_extname wcstok	__wcstok_xpg5
      #pragma redefine_extname wcsftime	__wcsftime_xpg5
    #else
      wchar_t* __wcstok_xpg5(wchar_t *, const wchar_t *, wchar_t **);
      size_t   __wcsftime_xpg5(wchar_t *, size_t, const wchar_t *,
			       const struct tm *);
      #define wcstok	 __wcstok_xpg5
      #define wcsftime __wcsftime_xpg5
    #endif
  #endif
#endif

#if (!defined(__SunOS_5_5_1) && !defined(__SunOS_5_6))
  wint_t   btowc(int);
  int	   fwprintf(__FILE *, const wchar_t *, ...);
  int	   fwscanf(__FILE *, const wchar_t *, ...);
  int	   fwide(__FILE *, int);
  int	   mbsinit(const mbstate_t *);
  size_t   mbrlen(const char *, size_t, mbstate_t *);
  size_t   mbrtowc(wchar_t *, const char *, size_t, mbstate_t *);
  size_t   mbsrtowcs(wchar_t *, const char **, size_t, mbstate_t *);
  int	   swprintf(wchar_t *, size_t, const wchar_t *, ...);
  int	   swscanf(const wchar_t *, const wchar_t *, ...);
  int	   vfwprintf(__FILE *, const wchar_t *, __va_list);
  int	   vwprintf(const wchar_t *, __va_list);
  int	   vswprintf(wchar_t *, size_t, const wchar_t *, __va_list);
  size_t   wcrtomb(char *, wchar_t, mbstate_t *);
  size_t   wcsrtombs(char *, const wchar_t **, size_t, mbstate_t *);
  const wchar_t* wcsstr(const wchar_t*, const wchar_t*);
  int	   wctob(wint_t);
  const wchar_t* wmemchr(const wchar_t*, wchar_t, size_t);
  int	   wmemcmp(const wchar_t *, const wchar_t *, size_t);
  wchar_t* wmemcpy(wchar_t *, const wchar_t *, size_t);
  wchar_t* wmemmove(wchar_t *, const wchar_t *, size_t);
  wchar_t* wmemset(wchar_t *, wchar_t, size_t);
  int	   wprintf(const wchar_t *, ...);
  int	   wscanf(const wchar_t *, ...);
#endif

/* non-const version of C functions */
extern "C++" {
  inline wchar_t* wcschr( wchar_t* _s, wchar_t _c ) {
      return (wchar_t*) wcschr( (const wchar_t*)_s, _c );
  }
  inline wchar_t* wcspbrk( wchar_t* _s1, const wchar_t* _s2 ) {
      return (wchar_t*) wcspbrk( (const wchar_t*)_s1, _s2 );
  }
  inline wchar_t* wcsrchr( wchar_t* _s, wchar_t _c ) {
      return (wchar_t*) wcsrchr( (const wchar_t*) _s, _c );
  }
#if (!defined(__SunOS_5_5_1) && !defined(__SunOS_5_6))
  inline wchar_t* wcsstr( wchar_t* _s1, const wchar_t* _s2 ) {
      return (wchar_t*) wcsstr( (const wchar_t*)_s1, _s2 );
  }
  inline wchar_t* wmemchr( wchar_t* _s, wchar_t _c, size_t _n ) {
      return (wchar_t*) wmemchr( (const wchar_t*)_s, _c, _n );
  }
#endif
} /* end of extern "C++" */

} /* end of namespace std */

#if (!defined(_MSE_INT_H)) && !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
  #if (!(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4)))
    #ifdef __PRAGMA_REDEFINE_EXTNAME
      #pragma redefine_extname fgetwc	__fgetwc_xpg5
      #pragma redefine_extname getwc	__getwc_xpg5
      #pragma redefine_extname getwchar	__getwchar_xpg5
      #pragma redefine_extname fputwc	__fputwc_xpg5
      #pragma redefine_extname putwc	__putwc_xpg5
      #pragma redefine_extname putwchar	__putwchar_xpg5
      #pragma redefine_extname fgetws	__fgetws_xpg5
      #pragma redefine_extname fputws	__fputws_xpg5
      #pragma redefine_extname ungetwc	__ungetwc_xpg5
    #else
      extern wint_t __fgetwc_xpg5(__FILE *);
      extern wint_t __getwc_xpg5(__FILE *);
      extern wint_t __getwchar_xpg5(void);
      extern wint_t __fputwc_xpg5(wint_t, __FILE *);
      extern wint_t __putwc_xpg5(wint_t, __FILE *);
      extern wint_t __putwchar_xpg5(wint_t);
      extern wchar_t *__fgetws_xpg5(wchar_t *, int, __FILE *);
      extern int    __fputws_xpg5(const wchar_t *, __FILE *);
      extern wint_t __ungetwc_xpg5(wint_t, __FILE *);
      #define	fgetwc	__fgetwc_xpg5
      #define	getwc	__getwc_xpg5
      #define	getwchar	__getwchar_xpg5
      #define	fputwc	__fputwc_xpg5
      #define	putwc	__putwc_xpg5
      #define	putwchar	__putwchar_xpg5
      #define	fgetws	__fgetws_xpg5
      #define	fputws	__fputws_xpg5
      #define	ungetwc	__ungetwc_xpg5
    #endif
  #endif
#endif

} /* end of extern "C" */

#endif	/* _WCHAR_ISO_SUNWCC_H */
