#!/bin/sh
#  @(#)f90.f77.ver.sh 1.11 (Sun Microsystems, Inc.) 01/12/29
#
#  Copyright (C) 2001 Sun Microsystems, Inc.
#  All rights reserved.
#
# Description:
#     This is a wrapper for running the f90 compiler
#     in f77 compatibility mode.
#
# This string is here for the 'version' command:
# It gets sed'ed in at build-time:
# @(#)RELEASE VERSION Forte Developer 7 Fortran 95 7.0 Patch 111714-02 2002/07/17
inv=0
inl=""
f90opt=""
f90ftr="-ftrap=%none"
for i in $*
do
  case $i in
     -errtags=INVOKE) inv=1;;
     -silent)         inv=1; f90opt="$f90opt $i" ;;
     -fast)           f90opt="$f90opt $i -ftrap=%none";f90ftr="";;
     -ftrap*)         f90opt="$f90opt $i";f90ftr="";;
     -*)              f90opt="$f90opt $i";;
      *)              inl="-lf77compat"; f90opt="$f90opt $i";;
  esac
done
[ $inv -eq 0 ] && \
    echo NOTICE: Invoking `/bin/dirname $0`/f90 -f77 $f90ftr $f90opt
exec `/bin/dirname $0`/f90 -f77 $f90ftr $f90opt $inl
