/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.AuthorizationException;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VDebug;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.VSecurityManager;
import com.sun.management.viperimpl.server.Registry;
import com.sun.management.viperimpl.server.ViperCommandClient;
import com.sun.management.viperimpl.server.ViperCommandServer;
import com.sun.management.viperimpl.server.ViperImpl;
import com.sun.management.viperimpl.servlet.ServletServer;
import com.sun.management.viperimpl.util.SimpleDebugger;
import com.sun.management.viperimpl.util.UnixFileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ViperServer {
    public static final String PN_VIPER_HOME = "viper.home";
    public static final String PN_VIPER_RTHOME = "viper.rthome";
    public static final String PN_VIPER_PORT = "viper.servlet.port";
    public static final String PN_VIPER_URL = "viper.server.url";
    static final String SERVER_RESOURCE = "com.sun.management.viperimpl.server.ViperServerResources";
    static final String SERVER_NAME = "LMS_ServerName";
    static final String VIPER_RMI_PREFIX = "Viper";
    static final String SERVER_TEMP_BASE = "/tmp/smc";
    static final int DEFAULT_SERVLET_PORT = 898;
    static final String SERVER_CONFIG_FILE1 = "/etc/smc/smcserver.config";
    static final String SERVER_CONFIG_FILE2 = "/policy/smcserver.config";
    static final VPermission PERMISSION_DEFAULTPORT = new VPermission("solaris.smc.server.defport");
    private static int ServletPort = 898;
    static String ServerTempDir = "/tmp/smc";
    private static String ServerRMIName = "Viper";
    private static String Viper_Home = "/usr/sadm/lib/smc";
    private static String Viper_RTHome = "/var/sadm/smc";
    private static ServletServer webserver = null;
    private static String WEB_DIR = "/htdocs";
    private static ViperImpl viper = null;
    public static Remote viperRemote = null;
    private static SecureRandom rand = null;
    private static ResourceBundle resource = null;
    static Date serverStartDate = null;
    private static OutputStream fifoStream = null;
    private static String msg = null;
    private static int debugLevel;

    static {
        ResourceManager.seed((boolean)false);
        try {
            resource = ResourceBundle.getBundle(SERVER_RESOURCE);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Can't load server resource.");
        }
    }

    public static void checkPermission(VIdentity vIdentity, VPermission vPermission) throws RemoteException, AuthorizationException {
        viper.checkPermission(vIdentity, vPermission);
    }

    private static void cleanTempDir() {
        ViperServer.recursiveDelete(new File(ServerTempDir), 2);
    }

    static void closeFIFO() {
        if (fifoStream == null) {
            return;
        }
        try {
            fifoStream.close();
        }
        catch (IOException iOException) {
            Debug.trace((String)"server", (int)1, (String)"Failed to close FIFO", (Throwable)iOException);
        }
        fifoStream = null;
    }

    static void exit(String string, Object[] objectArray, int n) {
        if (string != null) {
            System.out.println(ViperServer.getMessage(string, objectArray));
        }
        System.out.println(n);
        System.exit(n);
    }

    static void exitServer(VIdentity vIdentity, int n) throws VException {
        if (ServletPort == 898) {
            try {
                ViperServer.checkPermission(vIdentity, PERMISSION_DEFAULTPORT);
            }
            catch (RemoteException remoteException) {}
        }
        String[] stringArray = new String[]{Integer.toString(ServletPort)};
        ViperServer.writeLog("LMS_ServerShutdown", "LMD_ServerShutdown", stringArray, 100);
        viper.onExit();
        ViperServer.cleanTempDir();
        System.exit(n);
    }

    static String getMessage(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        try {
            string2 = resource.getString(string2);
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {}
        return string2;
    }

    public static SecureRandom getRandom() {
        if (rand == null) {
            rand = new SecureRandom();
        }
        return rand;
    }

    public static Date getServerStartDate() {
        return serverStartDate;
    }

    public static ConnectionInfo[] getUsageInfo() throws RemoteException, VException {
        return viper.getCurrentConnectionList();
    }

    public static void init(String[] stringArray) {
        Object object;
        CommandParser commandParser;
        ViperServer.stampMessage("starting up");
        serverStartDate = new Date();
        String string = System.getProperty("viper.argv0");
        if (string == null) {
            string = "smcserver";
        }
        VSCommandParser vSCommandParser = new VSCommandParser(string, ViperServer.getMessage("vservername", null), false, System.in, System.out);
        CommandOption commandOption = new CommandOption("debug", ViperServer.getMessage("debugoption", null), new String[]{"d", "debug"}, 2, true, false, null, false);
        commandOption.setHidden(true);
        CommandOption commandOption2 = new CommandOption("port", ViperServer.getMessage("portoption", null), new String[]{"p", "port"}, 2, true, false, null, false);
        CommandOption commandOption3 = new CommandOption("help", ViperServer.getMessage("helpoption", null), new String[]{"h", "help"}, 0, true, false, null, false);
        commandOption3.setPriority(true);
        CommandParser commandParser2 = new CommandParser("start", ViperServer.getMessage("startcmddesc", null), true, System.in, System.out);
        CommandParser commandParser3 = new CommandParser("stop", ViperServer.getMessage("stopcmddesc", null), true, System.in, System.out);
        CommandParser commandParser4 = new CommandParser("status", ViperServer.getMessage("statuscmddesc", null), true, System.in, System.out);
        vSCommandParser.addOption(commandOption);
        vSCommandParser.addOption(commandOption3);
        vSCommandParser.addOption(commandOption2);
        vSCommandParser.addSubCommand(commandParser4);
        vSCommandParser.addSubCommand(commandParser2);
        vSCommandParser.addSubCommand(commandParser3);
        if (vSCommandParser.parseArgs(stringArray)) {
            if (commandOption2.wasSet()) {
                System.setProperty(PN_VIPER_PORT, ((Integer)commandOption2.getValue()).toString());
            } else {
                System.setProperty(PN_VIPER_PORT, new Integer(898).toString());
            }
        } else {
            ViperServer.exit("argument_err", null, 1);
        }
        if (commandOption3.wasSet()) {
            vSCommandParser.printUsage(null);
            System.exit(0);
        }
        if (commandOption.wasSet()) {
            Debug.setDebugImpl((VDebug)new SimpleDebugger());
            debugLevel = (Integer)commandOption.getValue();
            Debug.setDebugLevel((int)debugLevel);
        }
        if ((commandParser = vSCommandParser.getSubCommand()) == null) {
            commandParser = commandParser2;
        }
        if (!commandParser.getName().equals("start")) {
            object = vSCommandParser.getSubCommandLine();
            ViperCommandClient.main((String[])object);
        } else {
            object = new Object[]{SMCVersion.getFullVersion()};
            System.out.println(ViperServer.getMessage("start_server", object));
        }
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new VSecurityManager());
            }
            catch (Exception exception) {
                ViperServer.exit("exit_nosecuritymanager", null, 1);
            }
        }
        if ((object = System.getProperty(PN_VIPER_HOME)) != null) {
            Viper_Home = object;
        } else {
            System.setProperty(PN_VIPER_HOME, Viper_Home);
        }
        object = System.getProperty(PN_VIPER_RTHOME);
        if (object != null) {
            Viper_RTHome = object;
        } else {
            System.setProperty(PN_VIPER_RTHOME, Viper_RTHome);
        }
        new File(Viper_RTHome).mkdir();
        Integer n = Integer.getInteger(PN_VIPER_PORT);
        if (n != null) {
            ServletPort = n;
        }
        ServerTempDir = SERVER_TEMP_BASE + ServletPort;
        ServerRMIName = VIPER_RMI_PREFIX + ServletPort;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string2 = inetAddress.getHostAddress();
            String string3 = "http://" + string2 + ":" + ServletPort + "/";
            System.setProperty(PN_VIPER_URL, string3);
            System.setProperty("java.rmi.server.codebase", String.valueOf(string3) + "vipercodebase/");
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            ViperServer.sendReadyAndTest(ServletPort);
            if (fifoStream == null) {
                ViperServer.cleanTempDir();
                if (!UnixFileUtilities.mkdir(ServerTempDir, 448)) {
                    Object[] objectArray = new String[]{ServerTempDir};
                    String string4 = ViperServer.getMessage("tmpdir_failed", objectArray);
                    throw new SecurityException(string4);
                }
            }
            File file = new File(String.valueOf(Viper_Home) + WEB_DIR);
            ViperServer.stampMessage("About to new ServletServer()");
            webserver = new ServletServer(ServletPort, file.toURL(), ServerTempDir);
            ViperServer.stampMessage("ServletServer created");
        }
        catch (UnknownHostException unknownHostException) {
            ViperServer.exit("exit_nocodebase", null, 1);
        }
        catch (MalformedURLException malformedURLException) {
            ViperServer.exit("exit_nowebdir", null, 1);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{Integer.toString(ServletPort), iOException.getLocalizedMessage()};
            ViperServer.exit("exit_noport", objectArray, 1);
        }
        catch (SecurityException securityException) {
            ViperServer.exit("exit_notemp", null, 1);
        }
        catch (CriticalStopException criticalStopException) {
            Debug.trace((String)"ViperServer", (int)Debug.ERROR, (String)"Http server cannot be started", (Throwable)criticalStopException);
            ViperServer.exit("exit_nowebserver", null, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ViperServer.exit("exit_badport", null, 1);
        }
        catch (Throwable throwable) {
            ViperServer.exit("exit_unknown", null, 1);
        }
    }

    public static void main(String[] stringArray) {
        ViperServer.init(stringArray);
        ViperServer.start();
    }

    static void openFIFO() {
        if (fifoStream != null) {
            return;
        }
        String string = System.getProperty("viper.fifo.path");
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            fifoStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            Debug.trace((String)"server", (int)1, (String)"Failed to open FIFO", (Throwable)iOException);
        }
    }

    private static void recursiveDelete(File file, int n) {
        if (file != null && file.exists()) {
            Object object;
            if (n > 0 && file.isDirectory() && (object = file.listFiles()) != null) {
                int n2 = 0;
                while (n2 < ((File[])object).length) {
                    ViperServer.recursiveDelete(object[n2], n - 1);
                    ++n2;
                }
            }
            if (!file.delete()) {
                object = ViperServer.getMessage("tmpdir_rmfailed", new Object[]{file});
                throw new SecurityException((String)object);
            }
        }
    }

    static void sendDone(int n) {
        if (fifoStream == null) {
            return;
        }
        try {
            Debug.trace((String)"server", (int)0, (String)("Sending DONE to parent (port " + n + ")"), null);
            String string = "DONE" + n;
            fifoStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            Debug.trace((String)"server", (int)1, (String)"Failed to write to FIFO", (Throwable)iOException);
        }
    }

    static void sendReadyAndTest(int n) throws IOException {
        if (fifoStream == null) {
            return;
        }
        try {
            Debug.trace((String)"server", (int)0, (String)("Sending READY to parent (port " + n + ")"), null);
            String string = "READY" + n;
            fifoStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            Debug.trace((String)"server", (int)1, (String)"Failed to write to FIFO", (Throwable)iOException);
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 250;
        while (!bl && n3 <= 60000) {
            try {
                ++n2;
                new ServerSocket(n).close();
                bl = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(n3);
                    n3 *= 2;
                }
                catch (Exception exception2) {}
            }
        }
        ViperServer.stampMessage("Tried socket " + n2 + " times.");
        new ServerSocket(n).close();
    }

    protected static void stampMessage(String string) {
        if (debugLevel > 1) {
            System.err.println("server " + ViperServer.timestamp() + ": " + string);
        }
    }

    public static void start() {
        Object[] objectArray;
        Object object;
        try {
            Registry.doEverything();
        }
        catch (Throwable throwable) {
            object = new Object[]{throwable.toString()};
            ViperServer.exit("exit_preregfailed", (Object[])object, 1);
        }
        Properties properties = null;
        try {
            object = "/etc/smc/smcserver.config";
            if (!new File((String)object).exists()) {
                object = String.valueOf(Viper_Home) + SERVER_CONFIG_FILE2;
            }
            objectArray = new FileInputStream((String)object);
            properties = new Properties();
            properties.load((InputStream)objectArray);
            objectArray.close();
        }
        catch (IOException iOException) {}
        try {
            viper = new ViperImpl(properties);
            viperRemote = RemoteObject.toStub(viper);
        }
        catch (VException vException) {
            ViperServer.cleanTempDir();
            objectArray = new Object[]{vException.getLocalizedMessage()};
            ViperServer.exit("exit_initfailed", objectArray, 1);
        }
        catch (RemoteException remoteException) {
            ViperServer.cleanTempDir();
            objectArray = new Object[]{remoteException.getMessage()};
            ViperServer.exit("exit_noremote", objectArray, 1);
        }
        ViperServer.sendDone(ServletPort);
        object = new ViperCommandServer(viper);
        ((Thread)object).start();
        objectArray = new String[]{Integer.toString(ServletPort)};
        ViperServer.writeLog("LMS_ServerStartup", "LMD_ServerStartup", (String[])objectArray, 100);
        ViperServer.stampMessage("SMC server is ready");
        System.out.println(ViperServer.getMessage("serverready", null));
        System.out.println("0");
        if (rand == null) {
            rand = new SecureRandom();
            rand.nextLong();
        }
    }

    public static String timestamp() {
        long l = System.currentTimeMillis();
        long l2 = (l - l % 1000L) / 1000L;
        long l3 = l % 1000L;
        return l2 + "." + (l3 < 10L ? "00" : (l3 < 100L ? "0" : "")) + l3 + "000";
    }

    public static void writeLog(String string, int n, String string2, String string3, String[] stringArray, String string4, String string5) {
        ViperImpl.writeBufferedLog(string, "system", n, string2, string3, stringArray, string4, string5);
    }

    private static void writeLog(String string, String string2, String[] stringArray, int n) {
        ViperImpl.writeBufferedLog(SERVER_NAME, "system", n, string, string2, stringArray, SERVER_RESOURCE, null);
    }

    static class VSCommandParser
    extends CommandParser {
        public VSCommandParser(String string, String string2, boolean bl, InputStream inputStream, PrintStream printStream) {
            super(string, string2, bl, inputStream, printStream);
        }

        public void printUsage(String string) {
            Object object;
            this.outStream.println(this.commandDesc);
            if (string != null) {
                this.outStream.println(CommandParser.getMessage((String)"Error: {0}", (Object[])new String[]{string}));
            }
            this.outStream.println(CommandParser.getMessage((String)"Usage: {0} [flags] command [flags]", (Object[])new String[]{this.commandName}));
            this.outStream.println("\n" + CommandParser.getMessage((String)"Common flags:"));
            int n = 0;
            while (n < this.commandOptions.size()) {
                object = (CommandOption)this.commandOptions.elementAt(n);
                if (object.getName() == "port") {
                    this.outStream.println("\t-p, --port PORT  " + object.getDescription());
                } else if (object.getName() == "help") {
                    this.outStream.println("\t-h, --help       " + object.getDescription());
                }
                ++n;
            }
            this.outStream.println("\n" + CommandParser.getMessage((String)"Commands:"));
            object = this.subCommands.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                String string3 = ((CommandParser)this.subCommands.get(string2)).getDescription();
                this.outStream.println("\t" + string2 + "\t         " + string3);
            }
        }
    }
}

