/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.MimeHeaderField;
import com.sun.web.util.MimeHeadersEnumerator;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class MimeHeaders {
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private byte[] buf;

    public MimeHeaders() {
        this(512);
    }

    public MimeHeaders(int n) {
        this.buf = new byte[n];
    }

    public void appendHeader(String string, String string2) {
        MimeHeaderField mimeHeaderField = this.putHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setValue(string2);
    }

    public void clear() {
        int n = 0;
        while (n < this.count) {
            this.headers[n].reset();
            ++n;
        }
        this.count = 0;
    }

    public boolean containsHeader(String string) {
        return this.find(string) != null;
    }

    public void dump(PrintStream printStream) {
        int n = 0;
        while (n < this.count) {
            printStream.println(this.headers[n]);
            ++n;
        }
    }

    protected MimeHeaderField find(String string) {
        int n = 0;
        while (n < this.count) {
            if (this.headers[n].nameEquals(string)) {
                return this.headers[n];
            }
            ++n;
        }
        return null;
    }

    public int getAll(byte[] byArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < this.count) {
            n += this.headers[n3].getBytes(byArray, n);
            ++n3;
        }
        return n - n2;
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getDateValue() : -1L;
    }

    public MimeHeaderField getField(int n) {
        return n >= 0 && n < this.count ? this.headers[n] : null;
    }

    public int getFieldCount(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.count) {
            if (this.headers[n2].nameEquals(string)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public String getHeader(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public String getHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getValue() : null;
    }

    public String getHeaderName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public String[] getHeaders(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        int n = 0;
        while (n < this.count) {
            if (this.headers[n].nameEquals(string)) {
                vector.addElement(this.headers[n].getValue());
            }
            ++n;
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getIntValue() : -1;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putDateHeader(String string) {
        this.putHeader(string).setDateValue();
    }

    public void putDateHeader(String string, long l) {
        this.putHeader(string).setDateValue(l);
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mimeHeaderField;
        int n = this.headers.length;
        if (this.count >= n) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, n);
            this.headers = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.count;
        return mimeHeaderField;
    }

    protected MimeHeaderField putHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField == null) {
            mimeHeaderField = this.putHeader();
            mimeHeaderField.setName(string);
        }
        return mimeHeaderField;
    }

    public void putHeader(String string, String string2) {
        this.putHeader(string).setValue(string2);
    }

    public void putIntHeader(String string, int n) {
        this.putHeader(string).setIntValue(n);
    }

    public void read(ServletInputStream servletInputStream) throws IOException {
        byte[] byArray = this.count == 0 ? this.buf : new byte[this.buf.length];
        int n = 0;
        while (true) {
            int n2 = n;
            while (true) {
                int n3;
                if ((n3 = byArray.length - n) > 0 && (n3 = servletInputStream.readLine(byArray, n, n3)) == -1) {
                    throw new IOException("Connection reset.");
                }
                if (n3 == 0 || byArray[(n += n3) - 1] == 10) break;
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            if (--n > n2 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == n2) break;
            this.putHeader().parse(byArray, n2, n - n2);
        }
    }

    public void removeHeader(String string) {
        int n = 0;
        while (n < this.count) {
            if (this.headers[n].nameEquals(string)) {
                MimeHeaderField mimeHeaderField = this.headers[n];
                mimeHeaderField.reset();
                this.headers[n] = this.headers[--this.count];
                this.headers[this.count] = mimeHeaderField;
                return;
            }
            ++n;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.count) {
            stringBuffer.append("{");
            stringBuffer.append(this.headers[n].toString());
            stringBuffer.append("}");
            if (n < this.count - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        int n = 0;
        while (n < this.count) {
            this.headers[n].write(servletOutputStream);
            ++n;
        }
        servletOutputStream.println();
    }
}

