/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.UnixDomainSocketInputStream;
import com.sun.management.viperimpl.util.UnixDomainSocketOutputStream;
import com.sun.management.viperimpl.util.UnixUtilities;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;

public class UnixDomainSocket {
    protected File file;
    protected FileDescriptor fd = new FileDescriptor();

    static {
        UnixUtilities.isLoaded();
    }

    public UnixDomainSocket() throws IOException {
        this.createSocket();
    }

    public UnixDomainSocket(File file) throws IOException {
        this();
        this.file = file;
    }

    public UnixDomainSocket accept() throws IOException {
        UnixDomainSocket unixDomainSocket = new UnixDomainSocket();
        unixDomainSocket.close();
        this.doAccept(unixDomainSocket);
        return unixDomainSocket;
    }

    public int available() throws IOException {
        return this.doAvailable();
    }

    public void bind() throws IOException {
        this.doBind();
    }

    public void close() throws IOException {
        this.doClose();
    }

    public void connect() throws IOException {
        this.doConnect();
    }

    private native void createSocket();

    private native void doAccept(UnixDomainSocket var1);

    private native int doAvailable();

    private native void doBind();

    private native void doClose();

    private native void doConnect();

    public FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    public InputStream getInputStream() throws IOException {
        return new UnixDomainSocketInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new UnixDomainSocketOutputStream(this);
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length < 1) {
            System.out.println("Require at least a filename argument.");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            boolean bl = false;
            object = new File(string);
            UnixDomainSocket unixDomainSocket = new UnixDomainSocket((File)object);
            unixDomainSocket.bind();
            System.out.println("Bound to file.  Becoming server.");
            boolean bl2 = false;
            while (!bl2) {
                UnixDomainSocket unixDomainSocket2 = unixDomainSocket.accept();
                InputStream inputStream = unixDomainSocket2.getInputStream();
                int n = 0;
                while ((n = inputStream.available()) <= 0) {
                }
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                String string2 = new String(byArray);
                if (string2.equals("quit")) {
                    System.out.println("Terminating server");
                    bl2 = true;
                } else {
                    System.out.println(new String(byArray));
                }
                unixDomainSocket2.close();
            }
            unixDomainSocket.close();
            ((File)object).delete();
            System.exit(0);
        }
        catch (BindException bindException) {
            System.out.println("Can't bind to file.  Becoming client.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        try {
            UnixDomainSocket unixDomainSocket = new UnixDomainSocket(new File(string));
            unixDomainSocket.connect();
            object = unixDomainSocket.getOutputStream();
            if (stringArray.length > 1) {
                ((OutputStream)object).write(stringArray[1].getBytes());
            } else {
                ((OutputStream)object).write("hello".getBytes());
            }
            unixDomainSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

