/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityContext;
import com.sun.management.viperimpl.services.authentication.SecurityToken;

public abstract class ClientSecurityContext
extends SecurityContext {
    SecurityToken secTok = null;
    String svrHost = null;
    String userPswd = null;

    public ClientSecurityContext(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        super(authenticationFlavor);
        this.setAuthState(0);
    }

    protected void copyAttrs(ClientSecurityContext clientSecurityContext) throws AuthenticationException {
        super.copyAttrs(clientSecurityContext);
        clientSecurityContext.setUserPassword(this.getUserPassword());
    }

    public abstract byte[] encryptPassword(String var1) throws AuthenticationException;

    public abstract MessageSecurityToken generateMessageToken(Object[] var1) throws AuthenticationException;

    public abstract RequestSecurityToken generateRequestToken() throws AuthenticationException;

    public AuthenticationPrincipal[] getRoleList() {
        if (this.secTok instanceof ConfirmSecurityToken) {
            return ((ConfirmSecurityToken)this.secTok).getRoleList();
        }
        return null;
    }

    public SecurityToken getSecurityToken() {
        return this.secTok;
    }

    public String getServerHostName() {
        return this.svrHost;
    }

    public String getUserPassword() {
        return AuthenticationUtil.unhashPassword(this.userPswd);
    }

    public abstract ClientSecurityContext newCopy() throws AuthenticationException;

    public void reset() {
        this.secTok = null;
        this.setSecurityId(0L);
        this.setAuthState(0);
        this.setHeartbeatPeriod(-1L);
    }

    protected void setSecurityToken(SecurityToken securityToken) {
        this.secTok = securityToken;
    }

    public void setServerHostName(String string) {
        this.svrHost = string;
    }

    public void setUserPassword(String string) {
        this.userPswd = AuthenticationUtil.hashPassword(string);
    }

    public abstract void verifyConfirmToken(ConfirmSecurityToken var1) throws AuthenticationException;

    public abstract void verifyMessageToken(MessageSecurityToken var1, Object var2) throws AuthenticationException;

    public abstract AuthenticatorSecurityToken verifyResponseToken(ResponseSecurityToken var1) throws AuthenticationException;
}

