/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityFactory;
import com.sun.management.viperimpl.services.authentication.client.HeartbeatTask;
import com.sun.management.viperimpl.util.Timer;
import com.sun.management.viperimpl.util.TimerTask;
import java.util.Hashtable;
import java.util.Properties;

public class AuthenticationClient {
    private static final String AUTH_PACKAGE = "com.sun.management.viperimpl.services.authentication.client";
    private static final String AUTH_FACTORY_CLASSNAME = "ClientSecurityFactory";
    private static boolean inited = false;
    private static int dfltType;
    private static Hashtable factTable;
    private static Timer heart;

    public static void authenticate(AuthenticationRequest authenticationRequest, ClientSecurityContext clientSecurityContext) throws AuthenticationException {
        ConfirmSecurityToken confirmSecurityToken;
        AuthenticatorSecurityToken authenticatorSecurityToken;
        ResponseSecurityToken responseSecurityToken;
        RequestSecurityToken requestSecurityToken;
        if (clientSecurityContext.getAuthState() != 0) {
            throw new AuthenticationException("EXM_PCF");
        }
        long l = System.currentTimeMillis();
        try {
            requestSecurityToken = clientSecurityContext.generateRequestToken();
        }
        catch (AuthenticationException authenticationException) {
            clientSecurityContext.reset();
            throw authenticationException;
        }
        try {
            responseSecurityToken = (ResponseSecurityToken)authenticationRequest.authRequest("negotiate", requestSecurityToken);
        }
        catch (AuthenticationException authenticationException) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Session authenticate: negotiate failed: " + authenticationException.getMessage()), (Throwable)authenticationException);
            clientSecurityContext.reset();
            throw authenticationException;
        }
        try {
            authenticatorSecurityToken = clientSecurityContext.verifyResponseToken(responseSecurityToken);
        }
        catch (AuthenticationException authenticationException) {
            clientSecurityContext.reset();
            throw authenticationException;
        }
        try {
            confirmSecurityToken = (ConfirmSecurityToken)authenticationRequest.authRequest("authenticate", authenticatorSecurityToken);
        }
        catch (AuthenticationException authenticationException) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Session authenticate: authenticate failed: " + authenticationException.getMessage()), null);
            clientSecurityContext.reset();
            throw authenticationException;
        }
        try {
            clientSecurityContext.verifyConfirmToken(confirmSecurityToken);
        }
        catch (AuthenticationException authenticationException) {
            clientSecurityContext.reset();
            throw authenticationException;
        }
        if (clientSecurityContext.getHeartbeatPeriod() > 0L) {
            heart.schedule((TimerTask)new HeartbeatTask(authenticationRequest, clientSecurityContext), clientSecurityContext.getHeartbeatPeriod(), clientSecurityContext.getHeartbeatPeriod());
        }
    }

    public static void close(AuthenticationRequest authenticationRequest, ClientSecurityContext clientSecurityContext) throws AuthenticationException {
        SecurityToken securityToken = clientSecurityContext.getSecurityToken();
        clientSecurityContext.reset();
        authenticationRequest.authRequest("close", securityToken);
    }

    private static synchronized ClientSecurityContext createSecurityContext(int n) throws AuthenticationException {
        ClientSecurityFactory clientSecurityFactory = (ClientSecurityFactory)factTable.get(new Integer(n));
        if (clientSecurityFactory == null) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Request to create security context for non-existent flavor" + n), null);
            throw new AuthenticationException("Request to create security context for non-existent authentication type ", (Object)new Integer(n));
        }
        ClientSecurityContext clientSecurityContext = clientSecurityFactory.getClientSecurityContext();
        return clientSecurityContext;
    }

    public static ClientSecurityContext getSecurityContext() throws AuthenticationException {
        return AuthenticationClient.createSecurityContext(dfltType);
    }

    public static ClientSecurityContext getSecurityContext(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        return AuthenticationClient.createSecurityContext(authenticationFlavor.getAuthType());
    }

    public static void init(Properties properties) throws AuthenticationException {
        String string;
        ClientSecurityFactory clientSecurityFactory;
        if (inited) {
            return;
        }
        String[] stringArray = AuthenticationFlavor.getAuthFlavors();
        if (stringArray.length < 1) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)"No authentication flavors configured", null);
            throw new AuthenticationException("No authentication flavors configured");
        }
        String string2 = "com.sun.management.viperimpl.services.authentication.client.";
        factTable = new Hashtable();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = String.valueOf(string2) + stringArray[n] + AUTH_FACTORY_CLASSNAME;
            try {
                Class<?> clazz = Class.forName(string3);
                clientSecurityFactory = (ClientSecurityFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Cannot create new instance of security factory " + string3), (Throwable)exception);
                throw new AuthenticationException("Cannot create new instance of security factory ", (Object)string3, exception);
            }
            clientSecurityFactory.init(properties);
            factTable.put(new Integer(n), clientSecurityFactory);
            ++n;
        }
        int n2 = -1;
        if (properties != null && (string = properties.getProperty("auth.flavor.default")) != null) {
            n2 = AuthenticationFlavor.checkAuthFlavor((String)string);
        }
        if (n2 < 0) {
            n2 = AuthenticationFlavor.getDefaultAuthType();
        }
        if ((clientSecurityFactory = (ClientSecurityFactory)factTable.get(new Integer(n2))) == null) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)"No default authentication flavor is configured", null);
            throw new AuthenticationException("No default authentication flavor is configured");
        }
        dfltType = n2;
        heart = new Timer(true);
        inited = true;
    }
}

