/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard;

import com.sun.management.viper.console.gui.wizard.VWizardCard;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ToolBoxURLSelection
extends VWizardCard
implements Runnable {
    private JLabel l1 = null;
    private JLabel l2 = null;
    private JLabel l3 = null;
    private JLabel l4 = null;
    private JLabel url_label = null;
    private JTextField urlField = null;
    private JList l5 = null;
    private JScrollPane l6 = null;
    private JTextArea l7 = null;
    private JScrollPane l8 = null;
    private String host = null;
    private String fullHostString = null;
    private Thread serverQueryThread = null;
    private Thread myWatchDog = null;
    protected static int netTimeOut = 20000;
    protected ErrMsgPanel hostNotFound = this.createHostNotFound();
    protected ErrMsgPanel serverDown = this.createServerDown();
    protected ErrMsgPanel hostUnreachable = this.createHostUnreachable();
    protected transient String selectionHelp = ContextHelpLoader.getContextHelp((String)this.selectionHelp, null);

    protected static URL cleanURL(URL uRL) {
        try {
            String string = uRL.toString();
            int n = string.indexOf("//");
            int n2 = string.indexOf(":", n + 2);
            if (n2 == -1) {
                n2 = string.indexOf("/", n + 2);
            }
            String string2 = string.substring(n + 2, n2);
            string2 = InetAddress.getByName(string2).getHostName();
            String string3 = String.valueOf(string.substring(0, n + 2)) + string2;
            string3 = String.valueOf(string3) + string.substring(n2, string.length());
            return new URL(string3);
        }
        catch (Throwable throwable) {
            return uRL;
        }
    }

    protected ErrMsgPanel createHostNotFound() {
        return new ErrMsgPanel(0);
    }

    protected ErrMsgPanel createHostUnreachable() {
        return new ErrMsgPanel(2);
    }

    protected ErrMsgPanel createServerDown() {
        return new ErrMsgPanel(1);
    }

    protected void handleTBListSelection() {
        try {
            if (this.l5.isSelectionEmpty()) {
                return;
            }
            VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)this.l5.getSelectedValue();
            this.urlField.setText(ConfigManagement.aliasifyURL(vConfigurationInfo.getURL()).toString());
            this.l7.setText(vConfigurationInfo.getDescription());
            this.updateStatus();
        }
        catch (Throwable throwable) {
            this.urlField.setText("");
            this.l5.setModel(new DefaultListModel());
            this.l7.setText("");
            this.updateStatus();
        }
    }

    public void init() {
        this.l1 = new JLabel("Step 3 - " + ImplResourceManager.getString("toolboxurl_lbl4"));
        this.l2 = new JLabel(ImplResourceManager.getString("toolboxurl_lbl5"));
        this.l3 = new JLabel(ImplResourceManager.getString("Toolboxes:"));
        this.l3.setDisplayedMnemonic(ImplResourceManager.getString("Toolboxes:_mnemonic").charAt(0));
        this.l4 = new JLabel(ImplResourceManager.getString("Description:"));
        this.l4.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        this.url_label = new JLabel(ImplResourceManager.getString("URL:"));
        this.url_label.setDisplayedMnemonic(ImplResourceManager.getString("URL:_mnemonic").charAt(0));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(4));
        JPanel jPanel2 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.l1);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.l2);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(this.l3);
        jPanel.add(jPanel4);
        this.l5 = new JList();
        this.l5.setCellRenderer(new TBRenderer());
        this.l5.setSelectionMode(0);
        this.l5.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ToolBoxURLSelection.this.handleTBListSelection();
            }
        });
        this.l3.setLabelFor(this.l5);
        this.l5.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    int n = ToolBoxURLSelection.this.l5.locationToIndex(mouseEvent.getPoint());
                    Object e = ToolBoxURLSelection.this.l5.getModel().getElementAt(n);
                    VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)e;
                    ToolBoxURLSelection.this.urlField.setText(ConfigManagement.aliasifyURL(vConfigurationInfo.getURL()).toString());
                    ToolBoxURLSelection.this.l7.setText(vConfigurationInfo.getDescription());
                }
                catch (Throwable throwable) {}
                ToolBoxURLSelection.this.updateStatus();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.l6 = new JScrollPane(this.l5, 22, 30);
        jPanel.add(this.l6);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel5 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.url_label);
        jPanel.add(jPanel5);
        this.urlField = new JTextField(50);
        this.url_label.setLabelFor(this.urlField);
        this.urlField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ToolBoxURLSelection.this.updateStatus();
            }
        });
        JPanel jPanel6 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(this.urlField);
        jPanel.add(jPanel6);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel7 = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(this.l4);
        jPanel.add(jPanel7);
        this.l7 = new JTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.l7.setLineWrap(true);
        this.l7.setWrapStyleWord(true);
        this.l7.setEditable(false);
        this.l8 = new JScrollPane(this.l7);
        this.l4.setLabelFor(this.l7);
        jPanel.add(this.l8);
        jPanel.add(Box.createVerticalGlue());
        ((Container)((Object)this)).add(jPanel, "Center");
        this.setHelpHTML(this.selectionHelp);
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    public void run() {
        block13: {
            try {
                Thread.currentThread();
                Thread.sleep(1500L);
                int n = ManagerUtility.parsePortFromString(this.host);
                if (n < 0) {
                    n = 898;
                }
                this.host = ManagerUtility.parseHostFromString(this.host);
                InetAddress inetAddress = InetAddress.getByName(this.host);
                Locale locale = ResourceManager.currentLocale;
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                URL uRL = new URL("http://" + this.host + ":" + n + "/toolboxes/");
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("Locale", locale.toString());
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                Object object = objectInputStream.readObject();
                VConfigurationInfo[] vConfigurationInfoArray = (VConfigurationInfo[])object;
                int n2 = 0;
                while (n2 < vConfigurationInfoArray.length) {
                    vConfigurationInfoArray[n2].setURL(ToolBoxURLSelection.cleanURL(vConfigurationInfoArray[n2].getURL()));
                    ++n2;
                }
                this.l6.setViewportView(this.l5);
                this.l5.setModel(new TBListModel(vConfigurationInfoArray));
                this.l7.setEnabled(true);
                if (vConfigurationInfoArray != null && vConfigurationInfoArray.length > 0) {
                    String string = (String)this.getProperty("OLDTOOLBOXURLTOOLBOX");
                    int n3 = 0;
                    while (n3 < vConfigurationInfoArray.length) {
                        String string2 = vConfigurationInfoArray[n3].getURL().toString();
                        if (string2.equals(string)) {
                            this.l5.setSelectedIndex(n3);
                            this.urlField.setText(ConfigManagement.aliasifyURL(vConfigurationInfoArray[n3].getURL()).toString());
                            this.l7.setText(vConfigurationInfoArray[n3].getDescription());
                            ((Container)((Object)this)).validate();
                            ((Component)((Object)this)).repaint();
                            break block13;
                        }
                        ++n3;
                    }
                    break block13;
                }
                this.urlField.setText("");
                this.l7.setText("");
            }
            catch (UnknownHostException unknownHostException) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unknown Host", (Throwable)unknownHostException);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.hostNotFound);
            }
            catch (IOException iOException) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Server Not Running", (Throwable)iOException);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.serverDown);
            }
            catch (Throwable throwable) {
                Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Query interrupt", (Throwable)throwable);
                this.l5.setModel(new DefaultListModel());
                this.urlField.setText("");
                this.l7.setText("");
                this.l7.setEnabled(false);
                this.l6.setViewportView(this.hostUnreachable);
            }
        }
        try {
            if (this.myWatchDog != null && this.myWatchDog.isAlive()) {
                this.myWatchDog.interrupt();
            }
        }
        catch (Throwable throwable) {}
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
    }

    protected void seedRemoteTBlist(String string) {
        try {
            if (string == null) {
                return;
            }
            this.urlField.setText("");
            this.l7.setText("");
            this.l5.setModel(new DefaultListModel());
            this.l6.setViewportView(this.l5);
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
            int n = string.indexOf("//");
            this.host = n > 0 ? string.substring(n + 2) : string;
            this.fullHostString = string;
            this.serverQueryThread = new Thread(this);
            this.serverQueryThread.start();
            this.myWatchDog = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(netTimeOut);
                        if (!ToolBoxURLSelection.this.serverQueryThread.isAlive()) {
                            return;
                        }
                        ToolBoxURLSelection.this.serverQueryThread.interrupt();
                        ToolBoxURLSelection.this.l5.setModel(new DefaultListModel());
                        ToolBoxURLSelection.this.urlField.setText("");
                        ToolBoxURLSelection.this.l7.setText("");
                    }
                    catch (Throwable throwable) {
                        Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Watchdog interrupt", (Throwable)throwable);
                    }
                }
            });
            this.myWatchDog.start();
        }
        catch (Throwable throwable) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)throwable);
        }
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        String string = (String)this.getProperty("TOOLBOXURLTOOLBOX");
        if (string == null || string.trim().length() <= 0) {
            this.seedRemoteTBlist((String)this.getProperty("TOOLBOXURLSERVER"));
        }
        this.updateStatus();
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        this.getManager().setPrevious("toolboxurl-namedescription", "toolboxurl-selection");
        if (bl) {
            String string = this.urlField.getText();
            if (string != null && string.trim().length() > 0) {
                this.setProperty("TOOLBOXURLTOOLBOX", string.trim());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), ImplResourceManager.getString("invalidtoolurl"), ImplResourceManager.getString("invalidtoolurltitle"), 0);
                return false;
            }
        }
        return true;
    }

    protected void updateStatus() {
        if (this.urlField.getText() != null && this.urlField.getText().trim().length() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    class ErrMsgPanel
    extends JPanel {
        protected JLabel title = null;
        protected JTextArea desc = null;
        protected ImageIcon errIcon = null;
        protected int type = 0;

        public ErrMsgPanel(int n) {
            if (n < 0 || n > 2) {
                n = 0;
            }
            this.type = n;
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            if (this.errIcon == null) {
                this.errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
            }
            jPanel.add(new JLabel(this.errIcon));
            jPanel.add(Box.createVerticalGlue());
            this.add((Component)jPanel, "West");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.title = new JLabel();
            jPanel2.add((Component)this.title, "North");
            this.desc = new JTextArea();
            jPanel2.add((Component)this.desc, "Center");
            this.desc.setEditable(false);
            this.desc.setOpaque(false);
            this.desc.setLineWrap(true);
            this.desc.setWrapStyleWord(true);
            this.add((Component)jPanel2, "Center");
            this.installStrings();
        }

        protected void installStrings() {
            if (this.type == 0) {
                this.title.setText(ImplResourceManager.getString("Host Not Found"));
                this.desc.setText(ImplResourceManager.getString("NoServerFound"));
            } else if (this.type == 1) {
                this.title.setText(ImplResourceManager.getString("Server Not Running"));
                this.desc.setText(ImplResourceManager.getString("NoServerOnHost"));
            } else if (this.type == 2) {
                this.title.setText(ImplResourceManager.getString("Connection Timeout"));
                this.desc.setText(ImplResourceManager.getString("ConnectionTimeout"));
            }
        }
    }

    protected class TBListModel
    implements ListModel {
        protected VConfigurationInfo[] infoList = null;

        public TBListModel(VConfigurationInfo[] vConfigurationInfoArray) {
            this.infoList = vConfigurationInfoArray;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public Object getElementAt(int n) {
            return this.infoList[n];
        }

        public int getSize() {
            return this.infoList.length;
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    protected class TBRenderer
    extends DefaultListCellRenderer {
        protected TBRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            VConfigurationInfo vConfigurationInfo = (VConfigurationInfo)object;
            this.setText(vConfigurationInfo.getName());
            this.setIcon(new ImageIcon(vConfigurationInfo.getSmallIcon()));
            return this;
        }
    }
}

