/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VConsole;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleManager;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.ThreadPool;
import com.sun.management.viperimpl.ToolInfrastructureImpl;
import com.sun.management.viperimpl.VDefaultToolContext;
import com.sun.management.viperimpl.client.ViperClient;
import com.sun.management.viperimpl.console.CSecurityManager;
import com.sun.management.viperimpl.console.ManagedCredentials;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.console.ToolPayload;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.services.authentication.client.AuthenticationClient;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class BaseConsoleManager
implements VConsoleManager {
    protected VConsole console;
    protected PrivilegeManager privilegeMgr;
    protected VConsoleModel dataModel;
    protected URL dataModelURL;
    protected ToolInfrastructure toolInf;
    protected Vector listeners;
    protected VConsoleProperties properties;
    private static boolean authenClientInited = false;
    protected Hashtable clientSet;
    protected Hashtable identitySet;
    protected Vector ignoreClientSet;
    protected static final String viperRMIloc = "Viper";
    protected Vector toolList;
    protected VBaseConfiguration currentConfig;
    protected boolean configHasChanged;
    protected static ThreadPool threadPool = null;
    protected int numToolsToLoad;
    protected int numToolsLoaded;
    protected static String localHost = null;
    protected static String baseCommand = null;
    protected static String toolContext = "TC_APPLICATION_NONGUI";
    protected ManagedCredentials initialAuthInfo;
    protected String initialHostName;
    protected String initialUserName;
    protected String initialPassword;
    protected String initialRoleName;
    protected String initialRolePassword;
    protected String initialToolBox;
    protected String initialTool;
    protected AdminMgmtScope initialScope;
    protected String[] initialToolOptions;
    protected boolean trusted;
    protected boolean yesToAll;
    protected boolean silent;
    protected InputStream inputS;
    protected PrintStream outputS;
    protected PrintStream errorS;
    protected static MessageFormat loadingToolbox = null;
    protected static MessageFormat loadingTool = null;
    protected static MessageFormat loginOK = null;
    protected static MessageFormat roleLoginOK = null;
    protected static MessageFormat toolLoadOK = null;
    protected static MessageFormat tbLoadOK = null;
    protected static MessageFormat loadMessage = null;
    protected static MessageFormat unknownError = null;
    protected static MessageFormat hostNotFound = null;
    protected static MessageFormat serverNotRunning = null;
    protected static MessageFormat toolNotFound = null;
    protected static MessageFormat locInfoNotFound = null;
    protected static MessageFormat invalidScope = null;
    protected static MessageFormat unsupportedScope = null;
    protected static MessageFormat unsupportedContext = null;
    protected static MessageFormat failedAuthentication = null;
    protected static MessageFormat failedInitialization = null;
    protected static MessageFormat canceledAuthentication = null;
    protected static MessageFormat tbLoadFailed = null;
    protected static MessageFormat tbRecursion = null;
    protected VScopeNode selNode;

    public BaseConsoleManager() {
        block9: {
            this.console = null;
            this.privilegeMgr = null;
            this.dataModel = null;
            this.dataModelURL = null;
            this.toolInf = null;
            this.listeners = null;
            this.properties = null;
            this.clientSet = null;
            this.identitySet = null;
            this.ignoreClientSet = null;
            this.toolList = null;
            this.currentConfig = null;
            this.configHasChanged = false;
            this.numToolsToLoad = 0;
            this.numToolsLoaded = 0;
            this.initialAuthInfo = null;
            this.initialHostName = null;
            this.initialUserName = null;
            this.initialPassword = null;
            this.initialRoleName = null;
            this.initialRolePassword = null;
            this.initialToolBox = null;
            this.initialTool = null;
            this.initialScope = null;
            this.initialToolOptions = null;
            this.trusted = false;
            this.yesToAll = false;
            this.silent = false;
            this.inputS = null;
            this.outputS = null;
            this.errorS = null;
            this.selNode = null;
            if (localHost == null) {
                try {
                    localHost = InetAddress.getLocalHost().getHostName();
                }
                catch (Throwable throwable) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unable to determine local host", (Throwable)throwable);
                }
            }
            if (threadPool == null) {
                threadPool = new ThreadPool(10, 25);
                Debug.trace((String)"BaseConsoleManager", (int)Debug.INFORMATION, (String)"ThreadPool initialized: 10 initial, 25 max", null);
                try {
                    loadingToolbox = new MessageFormat(ImplResourceManager.getString("Loading Toolbox: {0}"));
                    loadingTool = new MessageFormat(ImplResourceManager.getString("Loading Tool: {0} from {1}"));
                    loginOK = new MessageFormat(ImplResourceManager.getString("Login to {0} as user {1} was successful."));
                    roleLoginOK = new MessageFormat(ImplResourceManager.getString("Login to {0} as user {1}, role {2} was successful."));
                    toolLoadOK = new MessageFormat(ImplResourceManager.getString("Download of {0} from {1} was successful."));
                    tbLoadOK = new MessageFormat(ImplResourceManager.getString("Toolbox: {0} successfully loaded."));
                    tbRecursion = new MessageFormat(ImplResourceManager.getString("TBRecursion"));
                    baseCommand = System.getProperty("viper.argv0");
                    if (baseCommand == null) {
                        baseCommand = "smc";
                    }
                }
                catch (Throwable throwable) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Error in MessageFormatters", (Throwable)throwable);
                }
            }
            if (authenClientInited) break block9;
            try {
                AuthenticationClient.init(null);
                authenClientInited = true;
            }
            catch (AuthenticationException authenticationException) {
                Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Couldn't init auth client", (Throwable)authenticationException);
            }
        }
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (vConsoleActionListener != null) {
            this.listeners.addElement(vConsoleActionListener);
        }
    }

    protected abstract VScopeNode addToolStubToParent(ToolNode var1, VScopeNode var2, VLocalizedInfo var3);

    protected abstract VScopeNode addToolToParent(ToolNode var1, Tool var2, VScopeNode var3, VScopeNode var4);

    protected abstract void authenticationFailedForTool(String var1, VScopeNode var2, Throwable var3);

    protected VScopeNode buildConfiguration(VBaseConfiguration vBaseConfiguration, String string) {
        VScopeNode vScopeNode = null;
        try {
            VConfigurationInfo vConfigurationInfo = vBaseConfiguration.getInfo();
            URL uRL = ConfigManagement.aliasifyURL(vConfigurationInfo.getURL());
            VConfigurationNode vConfigurationNode = vBaseConfiguration.getRootNode();
            if (vConfigurationNode == null) {
                return null;
            }
            if (string != null) {
                vConfigurationNode.setScope(string);
            }
            vScopeNode = ManagerUtility.createScopeNodeFor(vConfigurationNode);
            vScopeNode.setPayload((Object)vConfigurationNode);
            vScopeNode.setUserObject(uRL);
            Enumeration enumeration = vConfigurationNode.children();
            while (enumeration.hasMoreElements()) {
                VConfigurationNode vConfigurationNode2 = (VConfigurationNode)enumeration.nextElement();
                this.processChildNode(vScopeNode, vConfigurationNode2);
            }
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error building model", (Throwable)throwable);
            return null;
        }
        return vScopeNode;
    }

    protected void cancelOpenConsole(String string, Throwable throwable) throws Exception {
        this.properties.setProperty("vconsole.working", "false");
        String string2 = this.properties.getProperty("vconsole.currenttoolbox");
        if (string2 == null || string2.equals("null")) {
            this.properties.setProperty("vconsole.currenttoolbox", "");
        } else {
            this.properties.setProperty("vconsole.currenttoolbox", string2);
        }
        if (string != null) {
            this.warnUserOfFailedToolbox(string, throwable);
        }
        throw new Exception("Could not load console.");
    }

    protected void closeAuthenticatedSessions() {
        if (this.clientSet == null) {
            return;
        }
        Hashtable hashtable = this.clientSet;
        synchronized (hashtable) {
            Enumeration enumeration = this.clientSet.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    ViperClient viperClient = (ViperClient)this.clientSet.get(string);
                    if (viperClient.getIdentity() == null) continue;
                    viperClient.logout();
                    this.clientSet.remove(string);
                }
                catch (Throwable throwable) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Problem in ViperClient.logout()", (Throwable)throwable);
                }
            }
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        try {
            VScopeNode vScopeNode;
            Object object;
            if (string.equals("vconsole.scopeselected")) {
                this.selNode = (VScopeNode)vConsoleEvent.getPayload();
                this.updateIdentity(this.selNode);
                if (this.selNode == null) {
                    return;
                }
                Object object2 = this.selNode.getPayload();
                if (object2 instanceof ToolPayload) {
                    this.loadToolForStub(this.selNode, true);
                }
            } else if (string.equals("vconsole.scopechildopened") && (object = (vScopeNode = (VScopeNode)vConsoleEvent.getPayload()).getPayload()) instanceof ToolPayload) {
                this.loadToolForStub(vScopeNode, true);
            }
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)throwable);
        }
    }

    public void destroy() {
        this.closeAuthenticatedSessions();
    }

    public abstract void editConsole();

    protected void establishConsoleModel() {
        if (baseCommand != null && this.dataModelURL != null) {
            this.establishWindowCommand(String.valueOf(baseCommand) + " -B " + this.dataModelURL.toString());
        }
        this.console.setModel(this.dataModel);
        this.ignoreClientSet = null;
        this.properties.setProperty("vconsole.working", "false");
        this.properties.setProperty("vconsole.saveconsoleenabled", "false");
        this.properties.setPropertyObject("vconsole.useridentity", new Object());
        this.configHasChanged = false;
    }

    protected abstract void establishWindowCommand(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ViperClient getAuthViperClient(String string) throws Exception {
        ViperClient viperClient;
        ViperClient viperClient2 = viperClient = this.getStubViperClient(string);
        synchronized (viperClient2) {
            boolean bl;
            if (viperClient.getIdentity() != null) {
                return viperClient;
            }
            if (this.ignoreClientSet != null && this.ignoreClientSet.contains(viperClient)) {
                return null;
            }
            int n = ManagerUtility.parsePortFromString(string);
            string = ManagerUtility.parseHostFromString(string);
            ManagedCredentials managedCredentials = null;
            if (this.initialAuthInfo == null) {
                if (this.initialUserName != null && this.initialPassword != null) {
                    bl = this.initialRoleName != null && this.initialRolePassword != null;
                    managedCredentials = new ManagedCredentials(string, n, this.initialUserName, this.initialPassword, this.initialRoleName, this.initialRolePassword, bl);
                } else {
                    managedCredentials = this.promptUserForAuthInfo(string, n, null, false);
                }
            } else {
                String string2 = this.properties.getProperty("vconsole.authpreference");
                managedCredentials = string2.equals("vconsole.alwaysuseinitial") ? new ManagedCredentials(string, n, this.initialAuthInfo.getName(), this.initialAuthInfo.getCredential(), this.initialAuthInfo.getRoleName(), this.initialAuthInfo.getRoleCredential(), this.initialAuthInfo.shouldAssumeRole()) : this.promptUserForAuthInfo(string, n, null, false);
            }
            if (managedCredentials == null) {
                if (this.ignoreClientSet == null) return null;
                this.ignoreClientSet.addElement(viperClient);
                return null;
            }
            bl = this.handleAuthentication(viperClient, managedCredentials);
            if (!bl) {
                if (this.ignoreClientSet == null) return null;
                this.ignoreClientSet.addElement(viperClient);
                return null;
            }
            if (this.initialAuthInfo == null && managedCredentials != null) {
                this.initialAuthInfo = managedCredentials;
            }
            VIdentity vIdentity = viperClient.getIdentity();
            VLogEvent vLogEvent = new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Authentication Successful"), null, ImplResourceManager.getString("AuthSuccess"), null, null);
            if (!vIdentity.isInRole()) {
                vLogEvent.setMessage(loginOK.format(new Object[]{vIdentity.getAuthenHost(), vIdentity.getName()}));
            } else {
                vLogEvent.setMessage(roleLoginOK.format(new Object[]{vIdentity.getAuthenHost(), vIdentity.getPrimaryName(), vIdentity.getName()}));
            }
            this.notifyLog(vLogEvent);
            return viperClient;
        }
    }

    protected ViperClient getStubViperClient(String string) throws UnknownHostException, RemoteException, VException {
        int n = ManagerUtility.parsePortFromString(string);
        string = ManagerUtility.parseHostFromString(string);
        if (n <= 0) {
            n = 898;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = String.valueOf(inetAddress.getHostAddress()) + ":" + n;
        Hashtable hashtable = this.clientSet;
        synchronized (hashtable) {
            if (this.clientSet.containsKey(string2)) {
                ViperClient viperClient = (ViperClient)this.clientSet.get(string2);
                Object var7_8 = null;
                return viperClient;
            }
            ViperClient viperClient = new ViperClient(string, n);
            this.clientSet.put(string2, viperClient);
            ViperClient viperClient2 = viperClient;
            Object var7_9 = null;
            return viperClient2;
        }
    }

    protected String getToolHost(ToolNode toolNode) {
        if (toolNode == null) {
            return null;
        }
        String string = toolNode.getServerName();
        int n = toolNode.getServerPort();
        if (string == null || string.length() == 0) {
            string = localHost;
        }
        if (n < 0) {
            n = 898;
        }
        return String.valueOf(string) + ":" + n;
    }

    protected boolean handleAuthentication(ViperClient viperClient, ManagedCredentials managedCredentials) throws Exception {
        boolean bl = this.handlePrimaryLogin(viperClient, managedCredentials);
        if (!bl) {
            return false;
        }
        return this.handleRoleLogin(viperClient, managedCredentials);
    }

    protected Tool handleLoadTool(String string, String string2, VScopeNode vScopeNode) throws Throwable {
        Tool tool = null;
        try {
            String string3 = string;
            if (vScopeNode != null) {
                string3 = vScopeNode.getText();
            }
            this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)loadingTool.format(new Object[]{string3, string2})));
            tool = this.openTool(string, string2);
        }
        catch (Throwable throwable) {
            this.authenticationFailedForTool(string2, vScopeNode, throwable);
            throw throwable;
        }
        if (tool == null) {
            this.userCanceledAuthenticationForTool(string2, vScopeNode);
            throw new Exception("User Cancelled");
        }
        this.notifyLog(new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Tool Download Successful"), toolLoadOK.format(new Object[]{string, string2}), ImplResourceManager.getString("DownloadSuccess"), null, null));
        return tool;
    }

    protected VLocalizedInfo handleLocalizedToolInfo(ViperClient viperClient, String string, ToolInfo toolInfo, ToolNode toolNode, VScopeNode vScopeNode) throws Throwable {
        VLocalizedInfo vLocalizedInfo = null;
        try {
            vLocalizedInfo = viperClient.getLocalizedInfo(toolInfo.getResourceBaseName(), ResourceManager.currentLocale);
            return vLocalizedInfo;
        }
        catch (Throwable throwable) {
            this.toolDoesNotHaveLocalizedInfo(string, toolNode, toolInfo, vScopeNode, throwable);
            throw throwable;
        }
    }

    protected AdminMgmtScope handleMgmtScope(String string, String string2, ToolNode toolNode, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode) throws Throwable {
        AdminMgmtScope adminMgmtScope = null;
        try {
            adminMgmtScope = string != null ? new AdminMgmtScope(null, string) : new AdminMgmtScope("file", null, string2, null);
            return adminMgmtScope;
        }
        catch (Throwable throwable) {
            this.invalidScopeForTool(toolNode, vLocalizedInfo, vScopeNode, string, throwable);
            throw throwable;
        }
    }

    protected boolean handlePrimaryLogin(ViperClient viperClient, ManagedCredentials managedCredentials) throws Exception {
        boolean bl = false;
        boolean bl2 = true;
        String string = this.properties.getProperty("vconsole.promptonfailure");
        bl = string.equals("true");
        int n = 5;
        int n2 = 0;
        while (bl2) {
            try {
                ++n2;
                viperClient.login(managedCredentials);
                bl2 = false;
            }
            catch (Exception exception) {
                if (!bl) {
                    throw exception;
                }
                bl2 = this.promptUserToRetryLogin(managedCredentials.getHostName(), n2 == n);
                if (n2 == n) {
                    throw exception;
                }
                if (!bl2) {
                    return false;
                }
                if ((managedCredentials = this.promptUserForAuthInfo(managedCredentials.getHostName(), managedCredentials.getPort(), null, true)) != null) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean handleRoleLogin(ViperClient viperClient, ManagedCredentials managedCredentials) throws Exception {
        if (managedCredentials.getRoleName() != null && managedCredentials.getRoleCredential() != null) {
            return true;
        }
        if (!managedCredentials.shouldAssumeRole()) {
            return true;
        }
        VIdentity[] vIdentityArray = viperClient.getRoles();
        if (vIdentityArray == null || vIdentityArray.length == 0) {
            return true;
        }
        if ((managedCredentials = this.promptUserForRoleInfo(managedCredentials, null, vIdentityArray, false)) == null) {
            return false;
        }
        if (managedCredentials.getRoleName() == null) {
            managedCredentials.setShouldAssumeRole(false);
            return true;
        }
        boolean bl = false;
        boolean bl2 = true;
        String string = this.properties.getProperty("vconsole.promptonfailure");
        bl = string.equals("true");
        int n = 5;
        int n2 = 0;
        while (bl2) {
            try {
                ++n2;
                viperClient.assumeRole(managedCredentials);
                bl2 = false;
            }
            catch (Exception exception) {
                if (!bl) {
                    throw exception;
                }
                bl2 = this.promptUserToRetryLogin(managedCredentials.getHostName(), n2 == n);
                if (n2 == n) {
                    throw exception;
                }
                if (!bl2) {
                    return false;
                }
                if ((managedCredentials = this.promptUserForRoleInfo(managedCredentials, null, vIdentityArray, true)) == null) {
                    return false;
                }
                if (managedCredentials.shouldAssumeRole()) continue;
                return true;
            }
        }
        return true;
    }

    protected ViperClient handleStubClient(String string, String string2, ToolNode toolNode, VScopeNode vScopeNode) throws Throwable {
        ViperClient viperClient = null;
        try {
            viperClient = this.getStubViperClient(string);
            return viperClient;
        }
        catch (UnknownHostException unknownHostException) {
            this.noServerFound(string2, string, toolNode, vScopeNode, unknownHostException);
            throw unknownHostException;
        }
        catch (RemoteException remoteException) {
            this.noServerRunningOnHost(string, toolNode, vScopeNode, remoteException);
            throw remoteException;
        }
        catch (Throwable throwable) {
            this.unexpectedException(string2, toolNode, vScopeNode, throwable);
            throw throwable;
        }
    }

    protected void handleSupportedContext(String string, ToolNode toolNode, ToolInfo toolInfo, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode, String string2) throws Throwable {
        if (!ManagerUtility.toolSupportsContext(toolInfo, string2)) {
            this.toolDoesNotSupportContext(string, toolNode, vLocalizedInfo, vScopeNode, string2, null);
            throw new Exception();
        }
    }

    protected void handleSupportedScope(String string, ToolNode toolNode, ToolInfo toolInfo, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode, AdminMgmtScope adminMgmtScope) throws Throwable {
        if (!ManagerUtility.toolSupportsScope(toolInfo, adminMgmtScope)) {
            this.toolDoesNotSupportScope(string, toolNode, vLocalizedInfo, vScopeNode, adminMgmtScope, null);
            throw new Exception();
        }
    }

    protected ToolInfo handleToolInfo(ViperClient viperClient, String string, ToolNode toolNode, VScopeNode vScopeNode) throws Throwable {
        ToolInfo toolInfo = null;
        try {
            toolInfo = viperClient.getToolInfo(string);
            return toolInfo;
        }
        catch (Throwable throwable) {
            this.toolNotFoundOnServer(string, toolNode, vScopeNode, throwable);
            throw throwable;
        }
    }

    protected void handleToolInitialization(Tool tool, ToolInfo toolInfo, AdminMgmtScope adminMgmtScope, Properties properties, ViperClient viperClient, String string, VScopeNode vScopeNode) throws Throwable {
        try {
            this.initializeTool(tool, toolInfo, adminMgmtScope, properties, viperClient);
        }
        catch (Throwable throwable) {
            this.toolInitializationFailed(string, vScopeNode, throwable);
            throw throwable;
        }
    }

    public void init(VConsole vConsole, ToolInfrastructure toolInfrastructure) {
        this.console = vConsole;
        this.toolInf = toolInfrastructure;
    }

    protected void initializeClientSet() {
        if (this.clientSet == null) {
            this.clientSet = new Hashtable();
        }
    }

    protected void initializeIdentitySet() {
        this.identitySet = new Hashtable();
    }

    protected void initializeIgnoreClientSet() {
        this.ignoreClientSet = new Vector();
    }

    protected void initializeTool(Tool tool, ToolInfo toolInfo, AdminMgmtScope adminMgmtScope, Properties properties, ViperClient viperClient) throws Exception {
        if (toolInfo == null || tool == null || adminMgmtScope == null || viperClient == null) {
            return;
        }
        VDefaultToolContext vDefaultToolContext = new VDefaultToolContext(toolContext, adminMgmtScope, properties, toolInfo.getProperties());
        tool.setToolContext((ToolContext)vDefaultToolContext);
        tool.setProperties(this.properties);
        tool.addConsoleActionListener((VConsoleActionListener)this.console);
        if (tool instanceof VConsoleActionListener && this.console != null) {
            this.console.addConsoleActionListener((VConsoleActionListener)tool);
        }
        tool.init((ToolInfrastructure)new ToolInfrastructureImpl(viperClient));
        if (this.toolList == null) {
            this.toolList = new Vector();
        }
        this.toolList.addElement(tool);
    }

    protected abstract void invalidScopeForTool(ToolNode var1, VLocalizedInfo var2, VScopeNode var3, String var4, Throwable var5);

    protected abstract void loadOnlineHelpForTool(Tool var1, ToolInfo var2);

    protected void loadToolAndReplaceStub(VScopeNode vScopeNode, VScopeNode vScopeNode2, boolean bl) {
        if (vScopeNode == null || vScopeNode2 == null) {
            throw new IllegalArgumentException("Null input to loadToolAndReplaceStub");
        }
        try {
            ToolPayload toolPayload = (ToolPayload)vScopeNode2.getPayload();
            ToolNode toolNode = toolPayload.getToolNode();
            VScopeNode vScopeNode3 = null;
            if (this.selNode != null) {
                vScopeNode3 = (VScopeNode)this.selNode.getParent();
            }
            Tool tool = this.handleLoadTool(toolNode.getClassName(), this.getToolHost(toolNode), vScopeNode2);
            this.handleToolInitialization(tool, toolPayload.getInfo(), toolPayload.getScope(), toolNode.getParameters(), toolPayload.getClient(), toolNode.getClassName(), vScopeNode2);
            VScopeNode vScopeNode4 = this.addToolToParent(toolNode, tool, vScopeNode, vScopeNode2);
            this.identitySet.put(vScopeNode4, toolPayload.getClient().getIdentity());
            if (vScopeNode4.getChildCount() > 0) {
                this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)vScopeNode4));
            }
            this.loadOnlineHelpForTool(tool, toolPayload.getInfo());
            if (bl) {
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)vScopeNode4);
                if (!vScopeNode4.isNodeRelated((DefaultMutableTreeNode)vScopeNode3)) {
                    vConsoleEvent.setID("vconsole.scopechildopened");
                }
                this.notifyListeners(vConsoleEvent);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void loadToolForStub(VScopeNode vScopeNode, boolean bl) {
        try {
            VScopeNode vScopeNode2 = (VScopeNode)vScopeNode.getParent();
            if (vScopeNode == null || vScopeNode2 == null) {
                this.properties.setProperty("vconsole.working", "true");
                return;
            }
            ClickLoader clickLoader = new ClickLoader(vScopeNode2, vScopeNode, bl);
            threadPool.run((Runnable)clickLoader);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Unexpected error loading tool", (Throwable)throwable);
        }
    }

    protected abstract void noServerFound(String var1, String var2, ToolNode var3, VScopeNode var4, Throwable var5);

    protected abstract void noServerRunningOnHost(String var1, ToolNode var2, VScopeNode var3, Throwable var4);

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            try {
                VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.listeners.elementAt(n);
                vConsoleActionListener.consoleAction(vConsoleEvent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    protected void notifyLog(VLogEvent vLogEvent) {
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
        this.notifyListeners(vConsoleEvent);
    }

    protected void notifyOfRecursion(VScopeNode vScopeNode, URL uRL) {
        if (vScopeNode == null || uRL == null) {
            return;
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Toolbox Recursion"), ImplResourceManager.getString("Toolbox previously loaded"), tbRecursion.format(new Object[]{uRL.toString(), vScopeNode.getText()}), null, null));
    }

    public void openConsole() throws Exception {
        this.openConsole(null);
    }

    public void openConsole(String string) throws Exception {
        this.properties.setProperty("vconsole.working", "true");
        URL uRL = null;
        boolean bl = false;
        if (string != null) {
            try {
                uRL = new URL(string);
                bl = true;
            }
            catch (Exception exception) {
                this.warnUserOfFailedToolbox(string, exception);
                this.cancelOpenConsole(string, exception);
            }
        } else {
            uRL = this.promptUserForToolbox();
            if (uRL == null) {
                this.cancelOpenConsole(null, null);
            }
        }
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)loadingToolbox.format(new Object[]{uRL.toString()})));
        VBaseConfiguration vBaseConfiguration = null;
        try {
            uRL = ConfigManagement.unaliasifyURL(uRL);
            vBaseConfiguration = VBaseConfiguration.createConfiguration(uRL, ResourceManager.currentLocale);
            uRL = ConfigManagement.aliasifyURL(uRL);
        }
        catch (Throwable throwable) {
            uRL = ConfigManagement.aliasifyURL(uRL);
            if (bl) {
                this.warnUserOfFailedToolbox(uRL.toString(), throwable);
            }
            Debug.trace((String)"GUI Console Manager", (int)Debug.WARNING, (String)"Problem in open console", (Throwable)throwable);
            this.cancelOpenConsole(uRL.toString(), throwable);
        }
        this.shutDown();
        this.destroy();
        this.initializeClientSet();
        this.initializeIgnoreClientSet();
        this.initializeIdentitySet();
        this.initialAuthInfo = null;
        this.dataModelURL = uRL;
        this.numToolsLoaded = 0;
        this.numToolsToLoad = 0;
        this.dataModel = new VConsoleModel(this.buildConfiguration(vBaseConfiguration, null));
        this.dataModel.setProperties(this.properties);
        this.properties.setProperty("vconsole.currenttoolbox", uRL.toString());
        this.properties.setProperty("vconsole.lasttoolbox", uRL.toString());
        this.notifyLog(new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Toolbox Load Successful"), tbLoadOK.format(new Object[]{uRL.toString()}), ImplResourceManager.getString("ToolboxSuccess"), null, null));
        if (this.numToolsToLoad == 0) {
            this.establishConsoleModel();
        }
        this.currentConfig = vBaseConfiguration;
    }

    public Tool openTool() throws Exception {
        return this.openTool(null, null);
    }

    public Tool openTool(String string, String string2) throws Exception {
        ViperClient viperClient;
        if (string2 == null) {
            string2 = this.initialHostName != null ? this.initialHostName : localHost;
        }
        if (string == null) {
            string = this.promptUserForTool(string2);
        }
        if ((viperClient = this.getAuthViperClient(string2)) == null) {
            return null;
        }
        Tool tool = viperClient.getToolByName(string);
        return tool;
    }

    protected void processChildNode(VScopeNode vScopeNode, VConfigurationNode vConfigurationNode) {
        if (vScopeNode == null || vConfigurationNode == null) {
            return;
        }
        try {
            if (vConfigurationNode instanceof ToolBoxURLNode) {
                URL uRL;
                Object object;
                URL uRL2 = ((ToolBoxURLNode)vConfigurationNode).getURL();
                uRL2 = ConfigManagement.aliasifyURL(uRL2);
                VScopeNode vScopeNode2 = vScopeNode;
                while (vScopeNode2 != null) {
                    object = vScopeNode2.getUserObject();
                    if (object == null || !(object instanceof URL)) {
                        vScopeNode2 = (VScopeNode)vScopeNode2.getParent();
                        continue;
                    }
                    uRL = (URL)object;
                    if (uRL2.sameFile(uRL)) {
                        this.notifyOfRecursion(vScopeNode, uRL2);
                        return;
                    }
                    vScopeNode2 = (VScopeNode)vScopeNode2.getParent();
                }
                uRL2 = ConfigManagement.unaliasifyURL(uRL2);
                object = VBaseConfiguration.createConfiguration(uRL2, ResourceManager.currentLocale);
                uRL = this.buildConfiguration((VBaseConfiguration)((Object)object), vConfigurationNode.getScope());
                if (vConfigurationNode.getName() != null) {
                    uRL.setText(vConfigurationNode.getName());
                }
                if (vConfigurationNode.getDescription() != null) {
                    uRL.setDescription(vConfigurationNode.getDescription());
                }
                if (vConfigurationNode.getSmallIcon() != null) {
                    uRL.setSmallIcon(new ImageIcon(vConfigurationNode.getSmallIcon()));
                }
                if (vConfigurationNode.getLargeIcon() != null) {
                    uRL.setLargeIcon(new ImageIcon(vConfigurationNode.getLargeIcon()));
                }
                ManagerUtility.setBackgroundImage(vConfigurationNode, (VScopeNode)uRL);
                ManagerUtility.addChildToParent(vConfigurationNode, vScopeNode, (VScopeNode)uRL);
            } else if (vConfigurationNode instanceof ToolNode) {
                this.processToolNode((ToolNode)vConfigurationNode, vScopeNode);
            } else {
                VScopeNode vScopeNode3 = ManagerUtility.createScopeNodeFor(vConfigurationNode);
                Enumeration enumeration = vConfigurationNode.children();
                ManagerUtility.addChildToParent(vConfigurationNode, vScopeNode, vScopeNode3);
                while (enumeration.hasMoreElements()) {
                    VConfigurationNode vConfigurationNode2 = (VConfigurationNode)enumeration.nextElement();
                    this.processChildNode(vScopeNode3, vConfigurationNode2);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)throwable);
        }
    }

    protected void processToolNode(ToolNode toolNode, VScopeNode vScopeNode) {
        try {
            boolean bl = true;
            String string = this.properties.getProperty("vconsole.toolloading");
            boolean bl2 = string.equals("vconsole.loadbeforedisplay");
            boolean bl3 = toolNode.isAutoLoad();
            String string2 = this.properties.getProperty("vconsole.overridetoolbox");
            boolean bl4 = string2.equals("true");
            bl = bl2 == bl3 ? bl2 ^ true : (bl3 ? (bl4 ? bl2 ^ true : bl3 ^ true) : bl2 ^ true);
            StubLoader stubLoader = new StubLoader(toolNode, vScopeNode, bl);
            ++this.numToolsToLoad;
            threadPool.run((Runnable)stubLoader);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Unexpected error loading tool stub", (Throwable)throwable);
        }
    }

    protected abstract ManagedCredentials promptUserForAuthInfo(String var1, int var2, String var3, boolean var4);

    protected abstract ManagedCredentials promptUserForRoleInfo(ManagedCredentials var1, String var2, VIdentity[] var3, boolean var4);

    protected abstract String promptUserForTool(String var1);

    protected abstract URL promptUserForToolbox();

    protected abstract boolean promptUserToRetryLogin(String var1, boolean var2);

    public abstract int saveConsole();

    public abstract int saveConsoleAs();

    protected void setIdentity(Object object) {
        this.properties.setPropertyObject("vconsole.useridentity", object);
    }

    public void setInitialOptions(String string, String string2, String string3, String string4, String string5, String string6, String string7, AdminMgmtScope adminMgmtScope, String[] stringArray, boolean bl, boolean bl2, boolean bl3, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        this.initialHostName = string;
        this.initialUserName = string2;
        this.initialPassword = string3;
        this.initialRoleName = string4;
        this.initialRolePassword = string5;
        this.initialToolBox = string6;
        this.initialTool = string7;
        this.initialScope = adminMgmtScope;
        this.initialToolOptions = stringArray;
        this.trusted = bl;
        this.yesToAll = bl2;
        this.silent = bl3;
        this.inputS = inputStream;
        this.outputS = printStream;
        this.errorS = printStream2;
    }

    protected void setPrivilegeManager() {
        if (this.privilegeMgr == null) {
            return;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager instanceof CSecurityManager) {
                CSecurityManager cSecurityManager = (CSecurityManager)securityManager;
                cSecurityManager.setPrivilegeManager(this.privilegeMgr);
                Debug.trace((String)"ConsoleManager", (int)Debug.INFORMATION, (String)"PrivilegeManager established", null);
            }
        }
        catch (Throwable throwable) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"No Privilege Manager set", (Throwable)throwable);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
    }

    public void shutDown() {
        this.shutDownLoadedTools();
    }

    protected void shutDownLoadedTools() {
        if (this.toolList != null) {
            int n = 0;
            while (n < this.toolList.size()) {
                try {
                    Tool tool = (Tool)this.toolList.elementAt(n);
                    tool.destroy();
                }
                catch (Throwable throwable) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Problem stopping or destroying tool", (Throwable)throwable);
                }
                ++n;
            }
        }
        this.toolList = new Vector();
    }

    protected abstract void toolDoesNotHaveLocalizedInfo(String var1, ToolNode var2, ToolInfo var3, VScopeNode var4, Throwable var5);

    protected abstract void toolDoesNotSupportContext(String var1, ToolNode var2, VLocalizedInfo var3, VScopeNode var4, String var5, Throwable var6);

    protected abstract void toolDoesNotSupportScope(String var1, ToolNode var2, VLocalizedInfo var3, VScopeNode var4, AdminMgmtScope var5, Throwable var6);

    protected abstract void toolInitializationFailed(String var1, VScopeNode var2, Throwable var3);

    protected abstract void toolNotFoundOnServer(String var1, ToolNode var2, VScopeNode var3, Throwable var4);

    protected abstract void unexpectedException(String var1, VConfigurationNode var2, VScopeNode var3, Throwable var4);

    protected void updateIdentity(VScopeNode vScopeNode) {
        if (vScopeNode == null) {
            this.setIdentity("");
            return;
        }
        try {
            while (vScopeNode != null) {
                if (this.identitySet.containsKey(vScopeNode)) {
                    this.setIdentity(this.identitySet.get(vScopeNode));
                    return;
                }
                vScopeNode = (VScopeNode)vScopeNode.getParent();
            }
            this.setIdentity("");
        }
        catch (Throwable throwable) {
            this.setIdentity("");
        }
    }

    protected abstract void userCanceledAuthenticationForTool(String var1, VScopeNode var2);

    protected abstract void warnUserOfFailedToolbox(String var1, Throwable var2);

    class StubLoader
    implements Runnable {
        protected ToolNode child = null;
        protected VScopeNode parent = null;
        protected boolean stubOnly = true;

        public StubLoader(ToolNode toolNode, VScopeNode vScopeNode, boolean bl) throws RuntimeException, IllegalArgumentException {
            if (vScopeNode == null || toolNode == null) {
                throw new IllegalArgumentException("Null input to StubLoader");
            }
            this.child = toolNode;
            this.parent = vScopeNode;
            this.stubOnly = bl;
        }

        public void run() {
            try {
                String string = BaseConsoleManager.this.getToolHost(this.child);
                ViperClient viperClient = BaseConsoleManager.this.handleStubClient(string, this.child.getClassName(), this.child, this.parent);
                ToolInfo toolInfo = BaseConsoleManager.this.handleToolInfo(viperClient, this.child.getClassName(), this.child, this.parent);
                VLocalizedInfo vLocalizedInfo = BaseConsoleManager.this.handleLocalizedToolInfo(viperClient, this.child.getClassName(), toolInfo, this.child, this.parent);
                AdminMgmtScope adminMgmtScope = BaseConsoleManager.this.handleMgmtScope(this.child.getScope(), string, this.child, vLocalizedInfo, this.parent);
                BaseConsoleManager.this.handleSupportedContext(this.child.getClassName(), this.child, toolInfo, vLocalizedInfo, this.parent, toolContext);
                BaseConsoleManager.this.handleSupportedScope(this.child.getClassName(), this.child, toolInfo, vLocalizedInfo, this.parent, adminMgmtScope);
                VScopeNode vScopeNode = BaseConsoleManager.this.addToolStubToParent(this.child, this.parent, vLocalizedInfo);
                ToolPayload toolPayload = new ToolPayload(this.child, toolInfo, vLocalizedInfo, adminMgmtScope, viperClient);
                vScopeNode.setPayload((Object)toolPayload);
                if (!this.stubOnly) {
                    BaseConsoleManager.this.loadToolAndReplaceStub(this.parent, vScopeNode, false);
                }
            }
            catch (Throwable throwable) {
                Debug.trace((String)"StubLoader", (int)Debug.ERROR, (String)"Unexpected throwable in StubLoader", (Throwable)throwable);
            }
            ++BaseConsoleManager.this.numToolsLoaded;
            if (BaseConsoleManager.this.numToolsLoaded >= BaseConsoleManager.this.numToolsToLoad) {
                BaseConsoleManager.this.establishConsoleModel();
            }
        }
    }

    class ClickLoader
    implements Runnable {
        protected VScopeNode parent = null;
        protected VScopeNode stubNode = null;
        protected boolean selectWhenDone = false;

        public ClickLoader(VScopeNode vScopeNode, VScopeNode vScopeNode2, boolean bl) {
            if (vScopeNode == null || vScopeNode2 == null) {
                throw new IllegalArgumentException("Null input to ClickLoader");
            }
            this.parent = vScopeNode;
            this.stubNode = vScopeNode2;
            this.selectWhenDone = bl;
        }

        public void run() {
            BaseConsoleManager.this.properties.setProperty("vconsole.working", "true");
            try {
                BaseConsoleManager.this.loadToolAndReplaceStub(this.parent, this.stubNode, this.selectWhenDone);
            }
            catch (Throwable throwable) {}
            BaseConsoleManager.this.properties.setProperty("vconsole.working", "false");
        }
    }
}

