/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_FIBRE_CHANNEL_FC_VERSION_H
#define	_SYS_FIBRE_CHANNEL_FC_VERSION_H

#pragma ident	"@(#)fc_version.h	1.8	02/04/17 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Leadville major releases
 */
#define	LEADVILLE_VERSION_1		"1"
#define	LEADVILLE_VERSION_2		"2"
#define	LEADVILLE_VERSION_3		"3"
#define	LEADVILLE_VERSION_4		"4"
#define	LEADVILLE_VERSION_5		"5"
#define	LEADVILLE_VERSION_6		"6"
#define	LEADVILLE_VERSION_7		"7"
#define	LEADVILLE_VERSION_8		"8"


/*
 * Leadville sub-releases (limited to a maximum of 'i')
 */
#define	LEADVILLE_SUB_VERSION_1		"a"
#define	LEADVILLE_SUB_VERSION_2		"b"
#define	LEADVILLE_SUB_VERSION_3		"c"
#define	LEADVILLE_SUB_VERSION_4		"d"
#define	LEADVILLE_SUB_VERSION_5		"e"
#define	LEADVILLE_SUB_VERSION_6		"f"
#define	LEADVILLE_SUB_VERSION_7		"g"
#define	LEADVILLE_SUB_VERSION_8		"h"
#define	LEADVILLE_SUB_VERSION_9		"i"
#define	LEADVILLE_SUB_VERSION_10	"j"


/*
 * ULP versions
 */
#define	ULP_VERSION_1			"1"
#define	ULP_VERSION_2			"2"
#define	ULP_VERSION_3			"3"
#define	ULP_VERSION_4			"4"
#define	ULP_VERSION_5			"5"
#define	ULP_VERSION_6			"6"
#define	ULP_VERSION_7			"7"
#define	ULP_VERSION_8			"8"


/*
 * TRANSPORT versions
 */
#define	TRANSPORT_VERSION_1		"1"
#define	TRANSPORT_VERSION_2		"2"
#define	TRANSPORT_VERSION_3		"3"
#define	TRANSPORT_VERSION_4		"4"
#define	TRANSPORT_VERSION_5		"5"
#define	TRANSPORT_VERSION_6		"6"
#define	TRANSPORT_VERSION_7		"7"
#define	TRANSPORT_VERSION_8		"8"


/*
 * FCA versions
 */
#define	FCA_VERSION_1			"1"
#define	FCA_VERSION_2			"2"
#define	FCA_VERSION_3			"3"
#define	FCA_VERSION_4			"4"
#define	FCA_VERSION_5			"5"
#define	FCA_VERSION_6			"6"
#define	FCA_VERSION_7			"7"
#define	FCA_VERSION_8			"8"


/*
 * Current version levels
 */
#define	LEADVILLE_VERSION	LEADVILLE_VERSION_5"."LEADVILLE_SUB_VERSION_5
#define	ULP_VERSION		ULP_VERSION_2
#define	FCA_VERSION		FCA_VERSION_2
#define	TRANSPORT_VERSION	TRANSPORT_VERSION_2


/*
 * Leadville layer version short hands
 */
#define	FC_ULP_VERSION		LEADVILLE_VERSION "-" ULP_VERSION "-"
#define	FC_TRAN_VERSION		LEADVILLE_VERSION "-" TRANSPORT_VERSION "-"
#define	FC_FCA_VERSION		LEADVILLE_VERSION "-" FCA_VERSION "-"

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_FIBRE_CHANNEL_FC_VERSION_H */
