/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.util;

import com.sun.management.viper.util.Debug;
import java.util.Vector;

public class UndoRedoStack {
    protected Vector stack = null;
    protected int topOfStack = -1;

    public Object addItem(Object object) {
        if (object == null) {
            return null;
        }
        if (this.stack == null) {
            this.stack = new Vector();
        }
        try {
            Object e;
            if (this.topOfStack >= 0 && (e = this.stack.elementAt(this.topOfStack)) == object) {
                return object;
            }
            this.stack.insertElementAt(object, ++this.topOfStack);
            int n = this.stack.size() - 1;
            while (n > this.topOfStack) {
                this.stack.removeElementAt(n);
                --n;
            }
            return object;
        }
        catch (Throwable throwable) {
            Debug.trace("UndoRedoStack", Debug.ERROR, "Could not add item to stack", throwable);
            return null;
        }
    }

    public boolean canRedo() {
        if (this.stack == null || this.stack.size() == 0) {
            return false;
        }
        try {
            return this.stack.elementAt(this.topOfStack + 1) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean canUndo() {
        if (this.stack == null || this.stack.size() == 0) {
            return false;
        }
        try {
            return this.stack.elementAt(this.topOfStack - 1) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Object getRedoItem() {
        if (this.stack == null || this.stack.size() == 0) {
            return null;
        }
        if (!this.canRedo()) {
            return null;
        }
        try {
            Object e = this.stack.elementAt(++this.topOfStack);
            return e;
        }
        catch (Throwable throwable) {
            Debug.trace("UndoRedoStack", Debug.ERROR, "Unexpected exception.", throwable);
            return null;
        }
    }

    public Object getUndoItem() {
        if (this.stack == null || this.stack.size() == 0) {
            return null;
        }
        if (!this.canUndo()) {
            return null;
        }
        try {
            Object e = this.stack.elementAt(--this.topOfStack);
            return e;
        }
        catch (Throwable throwable) {
            Debug.trace("UndoRedoStack", Debug.ERROR, "Unexpected exception.", throwable);
            return null;
        }
    }
}

