/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VHTMLEditorKit;
import com.sun.management.viper.console.gui.VLinkListener;
import com.sun.management.viper.console.gui.lf.VAuxiliaryComponent;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class VHelpPane
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener,
VAuxiliaryComponent {
    protected VConsoleProperties properties = null;
    protected scopeSelPanel selectionPanel = null;
    protected JPanel contentPanel = null;
    protected Vector listeners = null;
    protected Font bodyFont = ResourceManager.bodyFont;
    protected VScopeNode scopeNode = null;
    protected VLinkListener hLinkListener = null;
    protected JEditorPane helpMsg = null;
    protected VHTMLEditorKit editorKit = null;
    protected JPanel multiSelPane = null;
    protected String title = ResourceManager.getString("Context Help");
    protected static ImageIcon icon = null;
    protected static ImageIcon smallLeaf = null;
    protected static ImageIcon largeLeaf = null;
    protected static ImageIcon smallFolder = null;
    protected static ImageIcon largeFolder = null;
    protected String currentText = null;
    protected URL currentURL = null;
    protected String itemsSelected = ResourceManager.getString(" Items selected.");
    protected String selectAnItem = ResourceManager.getString("Select an item.");
    protected VDisplayModel displayModel = null;
    protected static ImageIcon defInfoIcon = null;
    protected static String defInfoText = null;
    protected static String defaultMessage = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY>Select an item in the left (Navigation) pane to display the result in the right (View) pane. To expand a collapsed item in the Navigation pane, double-click the item or single-click the \"turner\" to the left of the item.<P>Click <A HREF=\"smc_userguide_overview\">here</A> to display an overview of SMC, which includes definitions of console terminology and usage instructions, plus getting started instructions for the first user of SMC. Select \"Overview\" in the Help menu to view the overview at any time.</BODY></HTML>";

    public VHelpPane() {
        try {
            if (icon == null) {
                Class<?> clazz = Class.forName("com.sun.management.viper.console.gui.lf.VHelpPane");
                icon = ConsoleUtility.loadImageIcon("images/Console_Help16.gif", clazz);
                smallLeaf = ConsoleUtility.loadImageIcon("../images/file16.gif", clazz);
                largeLeaf = ConsoleUtility.loadImageIcon("../images/file32.gif", clazz);
                smallFolder = ConsoleUtility.loadImageIcon("../images/folder16.gif", clazz);
                largeFolder = ConsoleUtility.loadImageIcon("../images/folder32.gif", clazz);
                defInfoIcon = ConsoleUtility.loadImageIcon("../images/info32.gif", clazz);
                defInfoText = ResourceManager.getString("General Information");
            }
        }
        catch (Exception exception) {}
        this.setLayout(new BorderLayout());
        this.selectionPanel = new scopeSelPanel();
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(2, 5, 2, 2));
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBackground(Color.white);
        this.add((Component)this.selectionPanel, "West");
        this.add((Component)this.contentPanel, "Center");
        this.setBackground(Color.white);
        this.validate();
        this.repaint();
        this.hLinkListener = new VLinkListener();
        this.hLinkListener.addConsoleActionListener(new VConsoleActionListener(){

            public void consoleAction(VConsoleEvent vConsoleEvent) {
                VHelpPane.this.notifyListeners(vConsoleEvent);
            }
        });
        this.buildHTMLPane();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    protected void buildHTMLPane() {
        this.helpMsg = new JEditorPane(){

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        this.helpMsg.setEditable(false);
        if (this.editorKit == null) {
            this.editorKit = new VHTMLEditorKit();
        }
        this.helpMsg.setEditorKitForContentType("text/html", this.editorKit);
        this.helpMsg.setContentType("text/html");
        this.hLinkListener.setEditorPane(this.helpMsg);
        this.helpMsg.addHyperlinkListener(this.hLinkListener);
    }

    protected Component buildInfoPane(VScopeNode vScopeNode) {
        if (vScopeNode == null) {
            return null;
        }
        if (vScopeNode.getInfoPane() != null) {
            return vScopeNode.getInfoPane();
        }
        if (vScopeNode.getHTMLUrl() != null) {
            return this.buildInfoPane(vScopeNode.getHTMLUrl());
        }
        if (vScopeNode.getHTMLText() != null) {
            return this.buildInfoPane(vScopeNode.getHTMLText());
        }
        String string = vScopeNode.getDescription();
        string = string != null ? "<HTML><head><title></title></head><body>" + string + "</body></html>" : "<HTML><head><title></title></head><body></body></html>";
        return this.buildInfoPane(string);
    }

    protected Component buildInfoPane(String string) {
        if (this.currentText == null) {
            this.buildHTMLPane();
            this.helpMsg.setText(string);
            this.helpMsg.setCaretPosition(0);
        } else if (!this.currentText.equals(string)) {
            this.buildHTMLPane();
            this.helpMsg.setText(string);
            this.helpMsg.setCaretPosition(0);
        }
        this.currentText = string;
        return this.helpMsg;
    }

    protected Component buildInfoPane(URL uRL) {
        try {
            if (this.currentURL == null) {
                this.buildHTMLPane();
                this.helpMsg.setPage(uRL);
                this.helpMsg.setCaretPosition(0);
            } else if (this.currentURL != uRL) {
                this.buildHTMLPane();
                this.helpMsg.setPage(uRL);
                this.helpMsg.setCaretPosition(0);
            }
            this.currentURL = uRL;
        }
        catch (Exception exception) {
            this.currentURL = null;
            String string = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY>" + ResourceManager.getString("Error retrieving HTML URL.") + "</BODY></HTML>";
            this.helpMsg.setText(string);
            this.helpMsg.setCaretPosition(0);
        }
        return this.helpMsg;
    }

    protected Component buildMultiSelectPane(Vector vector) {
        if (this.multiSelPane == null) {
            this.multiSelPane = new JPanel();
            this.multiSelPane.setBackground(Color.white);
            this.multiSelPane.setLayout(new BoxLayout(this.multiSelPane, 1));
        } else {
            this.multiSelPane.removeAll();
        }
        try {
            int n = 0;
            while (n < vector.size()) {
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                ImageIcon imageIcon = vScopeNode.getSmallIcon();
                Image image = null;
                if (imageIcon != null) {
                    image = imageIcon.getImage();
                }
                if (image == null || imageIcon.getIconWidth() <= 0) {
                    imageIcon = vScopeNode.getChildCount() > 0 ? smallFolder : smallLeaf;
                }
                JLabel jLabel = new JLabel(vScopeNode.getText(), imageIcon, 2);
                jLabel.setForeground(Color.black);
                jLabel.setFont(this.bodyFont);
                this.multiSelPane.add(jLabel);
                ++n;
            }
        }
        catch (Exception exception) {}
        return this.multiSelPane;
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        block9: {
            String string;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            string = vConsoleEvent.getID();
                            if (!string.equals("vconsole.prihelpselection")) break block10;
                            System.err.println("PRIHELPSELECTION not implemented!");
                            break block9;
                        }
                        if (!string.equals("vconsole.sechelpselection")) break block11;
                        this.reflectSecHelpSelection(vConsoleEvent.getPayload());
                        break block9;
                    }
                    if (!string.equals("vconsole.scopeselected")) break block12;
                    this.reflectScopeSelection(vConsoleEvent.getPayload());
                    break block9;
                }
                if (!string.equals("vconsole.setcontexthelp")) break block13;
                try {
                    Object object;
                    Object object2 = vConsoleEvent.getPayload();
                    if (object2 instanceof Component) {
                        this.setContentPane((Component)object2);
                    }
                    if (object2 instanceof String) {
                        object = (String)object2;
                        this.setContentPane(this.buildInfoPane((String)object));
                    }
                    if (object2 instanceof URL) {
                        object = (URL)object2;
                        this.setContentPane(this.buildInfoPane((URL)object));
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Debug.trace("HelpPane", Debug.ERROR, "Could not set context help", throwable);
                }
                break block9;
            }
            if (!string.equals("vconsole.updatescope")) break block9;
            try {
                VScopeNode vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (this.scopeNode != null && vScopeNode != null && vScopeNode == this.scopeNode) {
                    if (this.displayModel == null) {
                        this.loadDisplayModel();
                    }
                    this.reflectScopeSelection(vScopeNode);
                    this.reflectSecHelpSelection(this.displayModel.getSelectedNodes());
                }
            }
            catch (Exception exception) {}
        }
    }

    public Component getComponent() {
        return this;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String getTitle() {
        return this.title;
    }

    protected void loadDisplayModel() {
        Object object;
        if (this.properties != null && (object = this.properties.getPropertyObject("vconsole.displaymodel")) != null) {
            this.displayModel = (VDisplayModel)object;
        }
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.bodyfont")) {
                this.selectionPanel.setFont((Font)object);
            } else if (string.equals("vconsole.bodycolor")) {
                this.selectionPanel.setForeground((Color)object);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void reflectScopeSelection(Object object) {
        try {
            this.setSecSelection(null, null);
            VScopeNode vScopeNode = (VScopeNode)object;
            if (vScopeNode != null) {
                ImageIcon imageIcon = vScopeNode.getLargeIcon();
                Image image = null;
                if (imageIcon != null) {
                    image = imageIcon.getImage();
                }
                if (image == null || imageIcon.getIconWidth() <= 0) {
                    if (vScopeNode.getChildCount() > 0) {
                        this.setMainSelection(largeFolder, vScopeNode.getText());
                    } else {
                        this.setMainSelection(largeLeaf, vScopeNode.getText());
                    }
                } else {
                    this.setMainSelection(imageIcon, vScopeNode.getText());
                }
                if (vScopeNode.getChildCount() > 0) {
                    this.setSecSelection(null, this.selectAnItem);
                } else {
                    VScopeNode vScopeNode2 = vScopeNode.getInternalRoot();
                    if (vScopeNode2 != null && vScopeNode2.getChildCount() > 0) {
                        this.setSecSelection(null, this.selectAnItem);
                    }
                }
                this.setContentPane(this.buildInfoPane(vScopeNode));
                this.scopeNode = vScopeNode;
            } else {
                this.setMainSelection(defInfoIcon, null);
                this.setSecSelection(null, defInfoText);
                this.setContentPane(this.buildInfoPane(defaultMessage));
            }
        }
        catch (Exception exception) {}
    }

    protected void reflectSecHelpSelection(Object object) {
        try {
            Vector vector = (Vector)object;
            if (vector != null && vector.size() > 0) {
                if (vector.size() == 1) {
                    Object e = vector.elementAt(0);
                    VScopeNode vScopeNode = (VScopeNode)e;
                    if (vScopeNode == null) {
                        this.setSecSelection(null, null);
                        this.setContentPane(this.buildInfoPane(this.scopeNode));
                        return;
                    }
                    ImageIcon imageIcon = vScopeNode.getSmallIcon();
                    Image image = null;
                    if (imageIcon != null) {
                        image = imageIcon.getImage();
                    }
                    if (image == null || imageIcon.getIconWidth() <= 0) {
                        if (vScopeNode.getChildCount() > 0) {
                            this.setSecSelection(smallFolder, vScopeNode.getText());
                        } else {
                            this.setSecSelection(smallLeaf, vScopeNode.getText());
                        }
                    } else {
                        this.setSecSelection(imageIcon, vScopeNode.getText());
                    }
                    this.setContentPane(this.buildInfoPane(vScopeNode));
                } else {
                    this.setSecSelection(null, String.valueOf(vector.size()) + this.itemsSelected);
                    this.setContentPane(this.buildMultiSelectPane(vector));
                }
            } else {
                this.setSecSelection(null, null);
                if (this.scopeNode.getChildCount() > 0) {
                    this.setSecSelection(null, this.selectAnItem);
                } else {
                    VScopeNode vScopeNode = this.scopeNode.getInternalRoot();
                    if (vScopeNode != null && vScopeNode.getChildCount() > 0) {
                        this.setSecSelection(null, this.selectAnItem);
                    }
                }
                this.setContentPane(this.buildInfoPane(this.scopeNode));
            }
        }
        catch (Throwable throwable) {}
    }

    protected void setContentPane(Component component) {
        this.contentPanel.removeAll();
        if (component != null) {
            this.contentPanel.add(component, "Center");
        }
        this.validate();
        this.repaint();
    }

    public void setDefaultMessage(String string) {
        defaultMessage = string;
    }

    protected void setMainSelection(ImageIcon imageIcon, String string) {
        this.selectionPanel.setTopSelection(imageIcon, string);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }

    protected void setSecSelection(ImageIcon imageIcon, String string) {
        this.selectionPanel.setBottomSelection(imageIcon, string);
    }

    class scopeSelPanel
    extends JPanel {
        protected JLabel topSel = null;
        protected JLabel botSel = null;

        public scopeSelPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new BorderLayout());
            this.topSel = new JLabel();
            Font font = new JTextField().getFont();
            this.topSel.setFont(font);
            this.topSel.setForeground(Color.black);
            this.topSel.setHorizontalTextPosition(0);
            this.topSel.setVerticalTextPosition(3);
            this.botSel = new JLabel();
            this.botSel.setFont(font);
            this.botSel.setForeground(Color.black);
            this.topSel.setBorder(new EmptyBorder(5, 5, 2, 2));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1));
            jPanel2.setBackground(Color.white);
            jPanel2.add(this.topSel);
            jPanel.add((Component)jPanel2, "North");
            JPanel jPanel3 = new JPanel(this){
                private final /* synthetic */ scopeSelPanel this$1;
                {
                    this.this$1 = scopeSelPanel2;
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, 4);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(super.getMinimumSize().width, 4);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 4);
                }

                public void paint(Graphics graphics) {
                    String string = this.this$1.topSel.getText();
                    Icon icon = this.this$1.topSel.getIcon();
                    if (!(string != null && string.length() != 0 || icon != null && icon.getIconWidth() != 0)) {
                        return;
                    }
                    Dimension dimension = this.getSize();
                    graphics.setColor(ResourceManager.sunBlue);
                    graphics.fillRect(0, 0, dimension.width, 2);
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(0, dimension.height - 2, dimension.width - 8, dimension.height - 1);
                }
            };
            jPanel.add((Component)jPanel3, "Center");
            this.botSel.setBorder(new EmptyBorder(2, 5, 2, 2));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(0));
            jPanel4.setBackground(Color.white);
            jPanel4.add(this.botSel);
            jPanel.add((Component)jPanel4, "South");
            this.add((Component)jPanel, "North");
        }

        public void setBottomSelection(ImageIcon imageIcon, String string) {
            this.botSel.setIcon(imageIcon);
            this.botSel.setText(string);
            this.botSel.invalidate();
            this.botSel.repaint();
        }

        public void setFont(Font font) {
            if (this.topSel != null) {
                this.topSel.setFont(font);
            }
            if (this.botSel != null) {
                this.botSel.setFont(font);
            }
            this.validate();
            this.repaint();
        }

        public void setForeground(Color color) {
            if (this.topSel != null) {
                this.topSel.setForeground(color);
            }
            if (this.botSel != null) {
                this.botSel.setForeground(color);
            }
            this.validate();
            this.repaint();
        }

        public void setTopSelection(ImageIcon imageIcon, String string) {
            this.topSel.setIcon(imageIcon);
            this.topSel.setText(string);
            this.topSel.invalidate();
            this.topSel.repaint();
        }
    }
}

