/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogAlarm;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.gui.VEventViewer;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VHyperLinkButton;
import com.sun.management.viper.console.gui.lf.VAuxiliaryComponent;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class VEventPane
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener,
VAuxiliaryComponent,
Serializable {
    protected transient VConsoleProperties properties = null;
    protected transient Vector listeners = null;
    protected static Class imageClass = null;
    protected static ImageIcon eventsIcon = null;
    protected static ImageIcon infoIcon = null;
    protected static ImageIcon warnIcon = null;
    protected static ImageIcon errIcon = null;
    protected static ImageIcon alarmsIcon = null;
    protected static ImageIcon indetermIcon = null;
    protected static ImageIcon warningIcon = null;
    protected static ImageIcon minorIcon = null;
    protected static ImageIcon majorIcon = null;
    protected static ImageIcon criticalIcon = null;
    protected transient int numAlarms = 0;
    protected transient int numEvInfo = 0;
    protected transient int numEvWarn = 0;
    protected transient int numEvErr = 0;
    protected transient int numAlIndt = 0;
    protected transient int numAlWarn = 0;
    protected transient int numAlMnor = 0;
    protected transient int numAlMjor = 0;
    protected transient int numAlCrtc = 0;
    protected transient Vector eventLog = null;
    protected String title = null;
    protected ImageIcon icon = null;
    protected JPanel leftPanel = null;
    protected JPanel rightPanel = null;
    protected JPanel alarmsPanel = null;
    protected JPanel eventsPanel = null;
    protected JButton allEvents = null;
    protected String allEventsS = null;
    protected JButton infoEvents = null;
    protected String infoEventsS = null;
    protected JButton warnEvents = null;
    protected String warnEventsS = null;
    protected JButton errEvents = null;
    protected String errEventsS = null;
    protected JButton allAlarms = null;
    protected String allAlarmsS = null;
    protected JButton indtAlarms = null;
    protected String indtAlarmsS = null;
    protected JButton warnAlarms = null;
    protected String warnAlarmsS = null;
    protected JButton minrAlarms = null;
    protected String minrAlarmsS = null;
    protected JButton majrAlarms = null;
    protected String majrAlarmsS = null;
    protected JButton critAlarms = null;
    protected String critAlarmsS = null;
    protected JButton noEvents = null;
    protected JTextArea helpDesc = null;
    protected VHyperLinkButton moreInfo = null;
    protected VEventViewer viewer = null;
    protected ActionListener filterListener = null;

    public VEventPane() {
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.lf.VEventPane");
                this.loadIcons();
            }
        }
        catch (Exception exception) {}
        this.icon = ConsoleUtility.loadImageIcon("images/Console_Log16.gif", imageClass);
        this.viewer = new VEventViewer();
        this.viewer.setContainer(new VFrame());
        this.filterListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                String string = ((AbstractButton)object).getActionCommand();
                VEventPane.this.viewer.setFilterID(new Integer(string));
                VEventPane.this.viewer.showCenter(null);
            }
        };
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.buildLeftPanel();
        this.add((Component)this.leftPanel, "West");
        this.buildRightPanel();
        this.add((Component)this.rightPanel, "Center");
        this.init();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (vConsoleActionListener != null && !this.listeners.contains(vConsoleActionListener)) {
            this.listeners.addElement(vConsoleActionListener);
        }
    }

    protected void buildLeftPanel() {
        this.leftPanel = new JPanel(){
            protected int prefWidth = 160;

            public Dimension getMaximumSize() {
                return new Dimension(this.prefWidth, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(this.prefWidth, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.prefWidth, super.getPreferredSize().height);
            }
        };
        this.leftPanel.setBackground(Color.white);
        this.leftPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.helpDesc = new JTextArea(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.helpDesc.setFont(ResourceManager.bodyFont);
        this.helpDesc.setEditable(false);
        this.helpDesc.setForeground(Color.black);
        this.helpDesc.setLineWrap(true);
        this.helpDesc.setWrapStyleWord(true);
        this.leftPanel.add(this.helpDesc);
        JPanel jPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 4);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 4);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 4);
            }

            public void paint(Graphics graphics) {
                Dimension dimension = this.getSize();
                graphics.setColor(ResourceManager.sunBlue);
                graphics.fillRect(0, 0, dimension.width, 2);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, dimension.height - 2, dimension.width - 8, dimension.height - 1);
            }
        };
        this.leftPanel.add(Box.createVerticalStrut(2));
        this.leftPanel.add(jPanel);
        this.moreInfo = new VHyperLinkButton("");
        this.moreInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VEventPane.this.notifyListeners(new VConsoleEvent(this, "vconsole.hyperlinkevent", "smc_userguide_console_log"));
            }
        });
        JPanel jPanel2 = new JPanel(){

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel2.add(this.moreInfo);
        this.leftPanel.add(jPanel2);
        this.leftPanel.add(Box.createVerticalGlue());
    }

    protected void buildRightPanel() {
        VHyperLinkButton vHyperLinkButton = new VHyperLinkButton(ResourceManager.getString("- No Events or Alarms -"));
        vHyperLinkButton.setHyperLinkOn(false);
        this.noEvents = vHyperLinkButton;
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new GridLayout(1, 2));
        this.rightPanel.setBackground(Color.white);
        this.rightPanel.setBorder(new EmptyBorder(0, 20, 0, 5));
        this.eventsPanel = new JPanel();
        this.eventsPanel.setBackground(Color.white);
        this.eventsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.eventsPanel.setLayout(new BoxLayout(this.eventsPanel, 1));
        this.alarmsPanel = new JPanel();
        this.alarmsPanel.setBackground(Color.white);
        this.alarmsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.alarmsPanel.setLayout(new BoxLayout(this.alarmsPanel, 1));
        this.allEventsS = ResourceManager.getString("All Events");
        this.allEvents = new VHyperLinkButton(String.valueOf(this.allEventsS) + " (0)", eventsIcon);
        this.allEvents.setActionCommand("0");
        this.allEvents.addActionListener(this.filterListener);
        this.eventsPanel.add(this.allEvents);
        this.infoEventsS = ResourceManager.getString("Informational Events Only");
        this.infoEvents = new VHyperLinkButton(String.valueOf(this.infoEventsS) + " (0)", infoIcon);
        this.infoEvents.setActionCommand("2");
        this.infoEvents.addActionListener(this.filterListener);
        this.eventsPanel.add(this.infoEvents);
        this.warnEventsS = ResourceManager.getString("Warning Events Only");
        this.warnEvents = new VHyperLinkButton(String.valueOf(this.warnEventsS) + " (0)", warnIcon);
        this.warnEvents.setActionCommand("3");
        this.warnEvents.addActionListener(this.filterListener);
        this.eventsPanel.add(this.warnEvents);
        this.errEventsS = ResourceManager.getString("Error Events Only");
        this.errEvents = new VHyperLinkButton(String.valueOf(this.errEventsS) + " (0)", errIcon);
        this.errEvents.setActionCommand("4");
        this.errEvents.addActionListener(this.filterListener);
        this.eventsPanel.add(this.errEvents);
        this.eventsPanel.add(Box.createVerticalGlue());
        this.rightPanel.add(this.eventsPanel);
        this.allAlarmsS = ResourceManager.getString("All Alarms Only");
        this.allAlarms = new VHyperLinkButton(String.valueOf(this.allAlarmsS) + " (0)", alarmsIcon);
        this.allAlarms.setActionCommand("5");
        this.allAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.allAlarms);
        this.indtAlarmsS = ResourceManager.getString("Indeterminate Alarms Only");
        this.indtAlarms = new VHyperLinkButton(String.valueOf(this.indtAlarmsS) + " (0)", indetermIcon);
        this.indtAlarms.setActionCommand("6");
        this.indtAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.indtAlarms);
        this.warnAlarmsS = ResourceManager.getString("Warning Alarms Only");
        this.warnAlarms = new VHyperLinkButton(String.valueOf(this.warnAlarmsS) + " (0)", warningIcon);
        this.warnAlarms.setActionCommand("7");
        this.warnAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.warnAlarms);
        this.minrAlarmsS = ResourceManager.getString("Minor Alarms Only");
        this.minrAlarms = new VHyperLinkButton(String.valueOf(this.minrAlarmsS) + " (0)", minorIcon);
        this.minrAlarms.setActionCommand("8");
        this.minrAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.minrAlarms);
        this.majrAlarmsS = ResourceManager.getString("Major Alarms Only");
        this.majrAlarms = new VHyperLinkButton(String.valueOf(this.majrAlarmsS) + " (0)", majorIcon);
        this.majrAlarms.setActionCommand("9");
        this.majrAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.majrAlarms);
        this.critAlarmsS = ResourceManager.getString("Critical Alarms Only");
        this.critAlarms = new VHyperLinkButton(String.valueOf(this.critAlarmsS) + " (0)", criticalIcon);
        this.critAlarms.setActionCommand("10");
        this.critAlarms.addActionListener(this.filterListener);
        this.alarmsPanel.add(this.critAlarms);
        this.alarmsPanel.add(Box.createVerticalGlue());
        this.rightPanel.add(this.alarmsPanel);
        this.refreshPanel();
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null || vConsoleEvent.getID() == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        VConsoleEvent vConsoleEvent2 = null;
        if (string.equals("vconsole.logevent")) {
            try {
                VLogEvent vLogEvent = (VLogEvent)vConsoleEvent.getPayload();
                vConsoleEvent2 = new VConsoleEvent(this, "vconsole.updatestatus", vLogEvent.getMessage());
                if (this.eventLog == null) {
                    this.eventLog = new Vector();
                }
                this.eventLog.add(vLogEvent);
                this.allEvents.setText(String.valueOf(this.allEventsS) + " (" + this.eventLog.size() + ")");
                int n = vLogEvent.getType();
                switch (n) {
                    case 20: {
                        ++this.numEvWarn;
                        this.warnEvents.setText(String.valueOf(this.warnEventsS) + " (" + this.numEvWarn + ")");
                        break;
                    }
                    case 30: {
                        ++this.numEvErr;
                        this.errEvents.setText(String.valueOf(this.errEventsS) + " (" + this.numEvErr + ")");
                        break;
                    }
                    default: {
                        ++this.numEvInfo;
                        this.infoEvents.setText(String.valueOf(this.infoEventsS) + " (" + this.numEvInfo + ")");
                        break;
                    }
                }
            }
            catch (Exception exception) {}
        } else if (string.equals("vconsole.logalarm")) {
            try {
                VLogAlarm vLogAlarm = (VLogAlarm)vConsoleEvent.getPayload();
                vConsoleEvent2 = new VConsoleEvent(this, "vconsole.updatestatus", vLogAlarm.getMessage());
                if (this.eventLog == null) {
                    this.eventLog.addElement(vLogAlarm);
                }
                this.allEvents.setText(String.valueOf(this.allEventsS) + " (" + this.eventLog.size() + ")");
                ++this.numEvWarn;
                this.warnEvents.setText(String.valueOf(this.warnEventsS) + " (" + this.numEvWarn + ")");
                ++this.numAlarms;
                this.allAlarms.setText(String.valueOf(this.allAlarmsS) + " (" + this.numAlarms + ")");
                int n = vLogAlarm.getSeverity();
                switch (n) {
                    case 50: {
                        ++this.numAlWarn;
                        this.warnAlarms.setText(String.valueOf(this.warnAlarmsS) + " (" + this.numAlWarn + ")");
                        break;
                    }
                    case 60: {
                        ++this.numAlMnor;
                        this.minrAlarms.setText(String.valueOf(this.minrAlarmsS) + " (" + this.numAlMnor + ")");
                        break;
                    }
                    case 70: {
                        ++this.numAlMjor;
                        this.majrAlarms.setText(String.valueOf(this.majrAlarmsS) + " (" + this.numAlMjor + ")");
                        break;
                    }
                    case 80: {
                        ++this.numAlCrtc;
                        this.critAlarms.setText(String.valueOf(this.critAlarmsS) + " (" + this.numAlCrtc + ")");
                        break;
                    }
                    default: {
                        ++this.numAlIndt;
                        this.indtAlarms.setText(String.valueOf(this.indtAlarmsS) + " (" + this.numAlIndt + ")");
                        break;
                    }
                }
            }
            catch (Exception exception) {}
        } else if (!string.equals("vconsole.clearlogalarm") && string.equals("vconsole.showconsolelog")) {
            this.viewer.setFilterID(0);
            this.viewer.showCenter(null);
        }
        if (vConsoleEvent2 != null) {
            this.notifyListeners(vConsoleEvent2);
        }
        this.refreshPanel();
        this.viewer.consoleAction(vConsoleEvent);
    }

    public Component getComponent() {
        return this;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void init() {
        this.installStrings();
    }

    protected void installStrings() {
        this.title = ResourceManager.getString("Console Log");
        this.helpDesc.setText(ResourceManager.getString("Click on the links to view the console log for all events, alarms, or for each type or severity."));
        this.moreInfo.setText(ResourceManager.getString("More Information"));
    }

    protected void loadIcons() {
        criticalIcon = ConsoleUtility.loadImageIcon("images/Event_CritAlarm16.gif", imageClass);
        majorIcon = ConsoleUtility.loadImageIcon("images/Event_MajorAlarm16.gif", imageClass);
        minorIcon = ConsoleUtility.loadImageIcon("images/Event_MinorAlarm16.gif", imageClass);
        warningIcon = ConsoleUtility.loadImageIcon("images/Event_Warn16.gif", imageClass);
        indetermIcon = ConsoleUtility.loadImageIcon("images/Event_IntdAlarm16.gif", imageClass);
        alarmsIcon = ConsoleUtility.loadImageIcon("images/Event_GenericAlarm16.gif", imageClass);
        errIcon = ConsoleUtility.loadImageIcon("images/Event_Err16.gif", imageClass);
        warnIcon = ConsoleUtility.loadImageIcon("images/Event_Warn16.gif", imageClass);
        infoIcon = ConsoleUtility.loadImageIcon("images/Event_Info16.gif", imageClass);
        eventsIcon = ConsoleUtility.loadImageIcon("images/events_sm16.gif", imageClass);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            try {
                Object e = this.listeners.elementAt(n);
                VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)e;
                vConsoleActionListener.consoleAction(vConsoleEvent);
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    protected void parseEventLog() {
        if (this.eventLog == null) {
            return;
        }
        this.resetCounts();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.bodyfont")) {
                this.helpDesc.setFont((Font)object);
                this.helpDesc.validate();
                this.helpDesc.repaint();
            } else if (string.equals("vconsole.bodycolor")) {
                this.helpDesc.setForeground((Color)object);
                this.helpDesc.validate();
                this.helpDesc.repaint();
            }
        }
        catch (Throwable throwable) {}
    }

    protected void refreshPanel() {
        this.eventsPanel.removeAll();
        this.alarmsPanel.removeAll();
        if (this.eventLog != null && this.eventLog.size() > 0) {
            this.eventsPanel.add(this.allEvents);
            if (this.numEvInfo > 0) {
                this.eventsPanel.add(this.infoEvents);
            }
            if (this.numEvWarn > 0) {
                this.eventsPanel.add(this.warnEvents);
            }
            if (this.numEvErr > 0) {
                this.eventsPanel.add(this.errEvents);
            }
            this.alarmsPanel.removeAll();
            if (this.numAlarms > 0) {
                this.alarmsPanel.add(this.allAlarms);
            }
            if (this.numAlIndt > 0) {
                this.alarmsPanel.add(this.indtAlarms);
            }
            if (this.numAlWarn > 0) {
                this.alarmsPanel.add(this.warnAlarms);
            }
            if (this.numAlMnor > 0) {
                this.alarmsPanel.add(this.minrAlarms);
            }
            if (this.numAlMjor > 0) {
                this.alarmsPanel.add(this.majrAlarms);
            }
            if (this.numAlCrtc > 0) {
                this.alarmsPanel.add(this.critAlarms);
            }
        } else {
            this.eventsPanel.add(Box.createVerticalGlue());
            this.eventsPanel.add(this.noEvents);
            this.eventsPanel.add(Box.createVerticalGlue());
        }
        this.validate();
        this.repaint();
    }

    protected void resetCounts() {
        this.numEvInfo = 0;
        this.numEvWarn = 0;
        this.numEvErr = 0;
        this.numAlIndt = 0;
        this.numAlWarn = 0;
        this.numAlMnor = 0;
        this.numAlMjor = 0;
        this.numAlCrtc = 0;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }
}

